package net.adventurez.entity;

import java.util.List;
import org.jetbrains.annotations.Nullable;

import net.adventurez.entity.nonliving.ThrownRockEntity;
import net.adventurez.entity.nonliving.VoidBulletEntity;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1307;
import net.minecraft.class_1315;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1937.class_7867;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2945.class_9222;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_8103;

public class VoidFragmentEntity extends class_1307 implements class_1569 {

    public static final class_2940<Boolean> IS_VOID_ORB = class_2945.method_12791(VoidFragmentEntity.class, class_2943.field_13323);
    public boolean isVoidOrb;
    private int deathTick;

    public VoidFragmentEntity(class_1299<? extends class_1307> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createVoidFragmentAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 10.0D).method_26868(class_5134.field_23719, 0.0D)
                .method_26868(class_5134.field_23718, 10.0D);
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        if (spawnReason == class_3730.field_16465) {
            this.setVoidOrb(true);
        }

        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    @Override
    protected void method_5693(class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IS_VOID_ORB, false);
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("IsVoidOrb", this.isVoidOrb);

    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.isVoidOrb = tag.method_10577("IsVoidOrb");
        this.setVoidOrb(this.isVoidOrb);
    }

    public void setVoidOrb(boolean orb) {
        this.isVoidOrb = orb;
        field_6011.method_12778(IS_VOID_ORB, orb);
        this.method_23311();
        this.method_18382();
    }

    @Override
    protected class_4048 method_55694(class_4050 pose) {
        return super.method_55694(pose).method_19539(1.0F, (this.isVoidOrb || this.field_6011.method_12789(IS_VOID_ORB)) ? 2.1F : 1.2F);
    }

    @Override
    public void method_5674(class_2940<?> data) {
        if (IS_VOID_ORB.equals(data)) {
            this.method_23311();
            this.method_18382();
            this.method_36456(this.field_6241);
            this.field_6283 = this.field_6241;
        }

        super.method_5674(data);
    }

    @Override
    public void method_6108() {
        if (this.method_37908().method_8608()) {
            for (int i = 0; i < 10; ++i) {
                double d = this.field_5974.method_43059() * 0.05D;
                double e = this.field_5974.method_43059() * 0.05D;
                double f = this.field_5974.method_43059() * 0.05D;
                this.method_37908().method_8406(class_2398.field_11207, this.method_23322(1.0D), this.method_23319(), this.method_23325(1.0D), d, e, f);
            }
        }
        ++this.deathTick;
        if (this.deathTick >= 20 && !this.method_37908().method_8608()) {
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    @Override
    public void method_6078(class_1282 source) {
        if (!this.method_37908().method_8608() && this.isVoidOrb) {
            class_238 box = new class_238(this.method_24515());
            List<VoidShadowEntity> list = this.method_37908().method_8390(VoidShadowEntity.class, box.method_1014(120D), class_1301.field_6155);
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).method_5643(this.method_48923().method_48831(), 40f);
            }
        }
        super.method_6078(source);
    }

    @Override
    public void method_5958() {
        super.method_5958();
        if (!this.method_37908().method_8608() && this.method_37908().method_18462(class_4051.method_36625().method_18418(0.8D), this) != null) {
            this.field_6272 = true;
            this.method_37908().method_8437(this, this.method_23317(), this.method_23318(), this.method_23321(), this.isVoidOrb ? 4.0F : 3.0F, class_7867.field_40888);
            this.method_31472();
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_48789(class_8103.field_42242)) {
            return super.method_5643(source, amount);
        } else if ((source.method_5529() != null && source.method_5529() instanceof class_1657 && ((class_1657) source.method_5529()).method_7337())) {
            return super.method_5643(source, amount);
        }
        if (this.method_5679(source) || source.method_5526() instanceof ThrownRockEntity || (this.isVoidOrb && !(source.method_5526() instanceof VoidBulletEntity))) {
            return false;
        } else {
            return super.method_5643(source, source.method_5526() instanceof VoidBulletEntity ? this.method_6032() : amount);
        }
    }

    @Override
    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801) {
            this.method_31472();
        }
    }

    @Override
    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    @Override
    public boolean method_37222(class_1293 effect, class_1297 entity) {
        return false;
    }

    @Override
    public boolean method_5860(class_1297 entity) {
        return false;
    }

    @Override
    public boolean method_5822(boolean allowVehicles) {
        return false;
    }

    @Override
    public boolean method_6049(class_1293 effect) {
        return false;
    }

    @Override
    public boolean method_5810() {
        return false;
    }

    @Override
    public boolean method_5675() {
        return false;
    }

}
