package net.adventurez.entity;

import java.util.EnumSet;

import net.adventurez.entity.nonliving.ThrownRockEntity;
import net.adventurez.entity.nonliving.VoidBulletEntity;
import net.adventurez.init.SoundInit;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1307;
import net.minecraft.class_1309;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1400;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class VoidShadeEntity extends class_1307 implements class_1569 {

    public VoidShadeEntity(class_1299<? extends class_1307> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new VoidShadeEntity.VoidShadeMoveControl(this);
        this.field_6194 = 0;
    }

    public static class_5132.class_5133 createVoidShadeAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 20.0D).method_26868(class_5134.field_23719, 0.15D)
                .method_26868(class_5134.field_23721, 7.0D).method_26868(class_5134.field_23722, 0.5D).method_26868(class_5134.field_23718, 10.0D)
                .method_26868(class_5134.field_23717, 80.0D);
    }

    @Override
    public void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(3, new VoidShadeEntity.LookAtTargetGoal(this));
        this.field_6201.method_6277(7, new class_1376(this));
        this.field_6201.method_6277(3, new VoidShadeEntity.MoveGoal(this));
        this.field_6201.method_6277(5, new VoidShadeEntity.ShootBulletGoal(this));
        this.field_6185.method_6277(1, new class_1400<>(this, class_1657.class, true));
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source) || source.method_5526() instanceof ThrownRockEntity) {
            return false;
        } else {
            return super.method_5643(source, amount);
        }
    }

    @Override
    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801) {
            this.method_31472();
        }
    }

    @Override
    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    @Override
    public boolean method_37222(class_1293 effect, class_1297 entity) {
        return false;
    }

    @Override
    public boolean method_5860(class_1297 entity) {
        return false;
    }

    @Override
    public boolean method_5822(boolean allowVehicles) {
        return false;
    }

    @Override
    public boolean method_6049(class_1293 effect) {
        return false;
    }

    static class ShootBulletGoal extends class_1352 {
        private final VoidShadeEntity voidShadeEntity;
        public int cooldown;

        public ShootBulletGoal(VoidShadeEntity voidShadeEntity) {
            this.voidShadeEntity = voidShadeEntity;
        }

        @Override
        public boolean method_6264() {
            class_1309 livingEntity = this.voidShadeEntity.method_5968();
            return livingEntity != null && this.voidShadeEntity.method_6057(livingEntity);
        }

        @Override
        public void method_6269() {
            this.cooldown = 0;
        }

        @Override
        public void method_6268() {
            class_1309 livingEntity = this.voidShadeEntity.method_5968();
            if (livingEntity.method_5739(this.voidShadeEntity) < 12.0D) {
                class_1937 world = this.voidShadeEntity.method_37908();
                ++this.cooldown;
                if (this.cooldown == 20) {
                    ((class_3218) world).method_43129(null, this.voidShadeEntity, SoundInit.SHADOW_CAST_EVENT, class_3419.field_15251, 1.0F, 1.0F);
                    class_243 vec3d = this.voidShadeEntity.method_5828(1.0F);
                    vec3d.method_1031(world.field_9229.method_43057() * 0.5F - 0.25F, 0, world.field_9229.method_43057() * 0.5F - 0.25F);
                    VoidBulletEntity voidBulletEntity = new VoidBulletEntity(this.voidShadeEntity, vec3d, world);
                    world.method_8649(voidBulletEntity);

                    this.cooldown = -40;
                }
                if (livingEntity.method_5739(this.voidShadeEntity) < 1.0D) {
                    this.voidShadeEntity.method_6121(livingEntity);
                }
            } else if (this.cooldown > 0) {
                --this.cooldown;
            }
        }
    }

    static class LookAtTargetGoal extends class_1352 {
        private final VoidShadeEntity voidShadeEntity;

        public LookAtTargetGoal(VoidShadeEntity voidShadeEntity) {
            this.voidShadeEntity = voidShadeEntity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        @Override
        public boolean method_6264() {
            return true;
        }

        @Override
        public void method_6268() {
            if (this.voidShadeEntity.method_5968() == null) {
                class_243 vec3d = this.voidShadeEntity.method_18798();
                this.voidShadeEntity.method_36456(-((float) class_3532.method_15349(vec3d.field_1352, vec3d.field_1350)) * 57.295776F);
                this.voidShadeEntity.field_6283 = this.voidShadeEntity.method_36454();
            } else {
                class_1309 livingEntity = this.voidShadeEntity.method_5968();
                if (livingEntity.method_5858(this.voidShadeEntity) < 4096.0D) {
                    double e = livingEntity.method_23317() - this.voidShadeEntity.method_23317();
                    double f = livingEntity.method_23321() - this.voidShadeEntity.method_23321();
                    this.voidShadeEntity.method_36456(-((float) class_3532.method_15349(e, f)) * 57.295776F);
                    this.voidShadeEntity.field_6283 = this.voidShadeEntity.method_36454();
                }
            }

        }
    }

    static class MoveGoal extends class_1352 {
        private final VoidShadeEntity voidShadeEntity;

        public MoveGoal(VoidShadeEntity voidShadeEntity) {
            this.voidShadeEntity = voidShadeEntity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        @Override
        public boolean method_6264() {
            if (this.voidShadeEntity.method_5968() != null) {
                return true;
            } else
                return false;
        }

        @Override
        public boolean method_6266() {
            return false;
        }

        @Override
        public void method_6269() {
            if (this.voidShadeEntity.method_5968() != null) {
                class_1309 livingEntity = this.voidShadeEntity.method_5968();
                this.voidShadeEntity.method_5962().method_6239(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), 1.0D);

            }
        }
    }

    static class VoidShadeMoveControl extends class_1335 {
        private final VoidShadeEntity voidShadeEntity;

        public VoidShadeMoveControl(VoidShadeEntity voidShadeEntity) {
            super(voidShadeEntity);
            this.voidShadeEntity = voidShadeEntity;
        }

        @Override
        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6378) {
                class_243 vec3d = new class_243(this.field_6370 - this.voidShadeEntity.method_23317(), this.field_6369 - this.voidShadeEntity.method_23318(), this.field_6367 - this.voidShadeEntity.method_23321());
                vec3d = vec3d.method_1029();
                this.voidShadeEntity.method_18799(this.voidShadeEntity.method_18798().method_1019(vec3d.method_1021(0.012D)));
                if (this.voidShadeEntity.method_5968() == null) {
                    this.field_6374 = class_1335.class_1336.field_6377;
                }

            }
        }
    }

}
