package net.adventurez.entity;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

import com.google.common.collect.Lists;

import org.jetbrains.annotations.Nullable;

import net.adventurez.block.ShadowChest;
import net.adventurez.entity.nonliving.ThrownRockEntity;
import net.adventurez.entity.nonliving.VoidCloudEntity;
import net.adventurez.init.EffectInit;
import net.adventurez.init.EntityInit;
import net.adventurez.init.SoundInit;
import net.adventurez.init.TagInit;
import net.adventurez.network.packet.VelocityPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1307;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2945.class_9222;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_8103;
import net.voidz.block.VoidStoneBlock;
import net.voidz.block.entity.PortalBlockEntity;
import net.voidz.init.BlockInit;
import net.voidz.init.DimensionInit;

public class VoidShadowEntity extends class_1307 implements class_1569 {

    public static final class_2940<Boolean> HALF_LIFE_CHANGE;
    public static final class_2940<Boolean> IS_THROWING_BLOCKS;
    public static final class_2940<Boolean> HOVERING_MAGIC_HANDS;
    public static final class_2940<Boolean> CIRCLING_HANDS;

    private List<class_2338> blockPosList = new ArrayList<class_2338>();
    private final class_3213 bossBar;
    private boolean circling;
    private boolean wasCircling;
    private int portalX;
    private int portalY;
    private int portalZ;
    private boolean isHalfLife;
    private final boolean isInVoidDungeon;
    private boolean invisible;
    public int ticksSinceDeath;

    public VoidShadowEntity(class_1299<? extends class_1307> entityType, class_1937 world) {
        super(entityType, world);
        this.bossBar = (class_3213) (new class_3213(this.method_5476(), class_1259.class_1260.field_5783, class_1259.class_1261.field_5795));
        this.field_6194 = 100;
        this.field_6207 = new VoidShadowEntity.VoidShadowMoveControl(this);
        this.isInVoidDungeon = FabricLoader.getInstance().isModLoaded("voidz") && world.method_27983() == DimensionInit.VOID_WORLD;
    }

    @Override
    public void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, new VoidShadowEntity.ThrowBlocks(this));
        this.field_6201.method_6277(1, new VoidShadowEntity.DestroyBlocksAttack(this));
        this.field_6201.method_6277(2, new VoidShadowEntity.SummonFragment(this));
        this.field_6201.method_6277(3, new VoidShadowEntity.SummonShade(this));
        this.field_6201.method_6277(4, new VoidShadowEntity.Insanity(this));
        this.field_6201.method_6277(6, new VoidShadowEntity.FlyGoal(this));
        this.field_6201.method_6277(5, new VoidShadowEntity.LookGoal(this));
    }

    public static class_5132.class_5133 createVoidShadowAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 1000.0D).method_26868(class_5134.field_23719, 0.1D)
                .method_26868(class_5134.field_23721, 10.0D).method_26868(class_5134.field_23722, 2.0D).method_26868(class_5134.field_23724, 1.0D)
                .method_26868(class_5134.field_23718, 10.0D).method_26868(class_5134.field_23717, 80.0D);
    }

    @Override
    public void method_5958() {
        super.method_5958();
        this.bossBar.method_5408(this.method_6032() / this.method_6063());
        if (this.method_6032() < this.method_6063() / 2) {
            if (!field_6011.method_12789(HALF_LIFE_CHANGE)) {
                field_6011.method_12778(HALF_LIFE_CHANGE, true);
            }
            if (!this.isHalfLife) {
                this.method_5996(class_5134.field_23722).method_6192((double) (6.0D));
                this.method_5996(class_5134.field_23721).method_6192((double) 14.0D);
                this.method_5996(class_5134.field_23724).method_6192((double) 4.0D);
                this.isHalfLife = true;
            }
            if (this.method_6032() < this.method_6063() / 8 && !this.invisible) {
                this.method_6092(new class_1293(class_1294.field_5905, 400, 0, false, false, false));
                this.invisible = true;
            }
        }
    }

    @Override
    protected void method_5693(class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HALF_LIFE_CHANGE, false);
        builder.method_56912(IS_THROWING_BLOCKS, false);
        builder.method_56912(HOVERING_MAGIC_HANDS, false);
        builder.method_56912(CIRCLING_HANDS, false);
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("VoidXPortal", portalX);
        tag.method_10569("VoidYPortal", portalY);
        tag.method_10569("VoidZPortal", portalZ);
        tag.method_10556("ShadowCircling", this.circling);
        tag.method_10556("ShadowIsHalfLife", this.isHalfLife);
        tag.method_10572("ShadowBrokenBlocks", this.blockListTransform(this.blockPosList));
        tag.method_10556("ShadowInvisible", this.invisible);
        tag.method_10556("ShadowWasCircling", this.wasCircling);

    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (this.method_16914()) {
            this.bossBar.method_5413(this.method_5476());
        }
        this.portalX = tag.method_10550("VoidXPortal");
        this.portalY = tag.method_10550("VoidYPortal");
        this.portalZ = tag.method_10550("VoidZPortal");
        this.circling = tag.method_10577("ShadowCircling");
        this.isHalfLife = tag.method_10577("ShadowIsHalfLife");
        this.setBlockList(tag.method_10561("ShadowBrokenBlocks"));
        this.invisible = tag.method_10577("ShadowInvisible");
        this.wasCircling = tag.method_10577("ShadowWasCircling");
        if (!this.circling && this.wasCircling) {
            this.circling = true;
        }
    }

    private List<Integer> blockListTransform(List<class_2338> oldBlockPosList) {
        List<Integer> list = Lists.newArrayList();
        for (int i = 0; i < oldBlockPosList.size(); i++) {
            list.add(oldBlockPosList.get(i).method_10263());
            list.add(oldBlockPosList.get(i).method_10264());
            list.add(oldBlockPosList.get(i).method_10260());
        }
        return list;
    }

    private void setBlockList(int[] integers) {
        if (integers.length != 0) {
            for (int i = 0; i < integers.length; i++) {
                if (i % 3 == 0) {
                    this.blockPosList.add(i / 3, new class_2338(integers[i], integers[i + 1], integers[i + 2]));
                }
            }
        }
    }

    @Override
    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossBar.method_5413(this.method_5476());
    }

    @Override
    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossBar.method_14088(player);
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        if (!this.hasVoidMiddleCoordinates() && FabricLoader.getInstance().isModLoaded("voidz")) {
            // For test purpose, use spawn egg on portal block
            if (world.method_8320(this.method_24515().method_10074()).method_26204() == BlockInit.PORTAL) {
                this.setVoidMiddle(this.method_24515().method_10263(), this.method_24515().method_10264(), this.method_24515().method_10260());
            }
        }

        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    @Override
    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
    }

    @Override
    public boolean method_5974(double num) {
        return false;
    }

    @Override
    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801) {
            this.method_31472();
        }
    }

    @Override
    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    @Override
    public boolean method_37222(class_1293 effect, class_1297 entity) {
        return false;
    }

    @Override
    public boolean method_5860(class_1297 entity) {
        return false;
    }

    @Override
    public boolean method_5822(boolean allowVehicles) {
        return false;
    }

    @Override
    public boolean method_6049(class_1293 effect) {
        return false;
    }

    private boolean hasVoidMiddleCoordinates() {
        return this.portalX != 0 || this.portalY != 0 || this.portalZ != 0;
    }

    // Set at VoidZ mod
    // Platform at y = 99, voidmiddle = 100
    public void setVoidMiddle(int x, int y, int z) {
        this.circling = true;
        this.portalX = x;
        this.portalY = y;
        this.portalZ = z;
    }

    public class_2338 getVoidMiddle() {
        return new class_2338(this.portalX, this.portalY, this.portalZ);
    }

    @Override
    public boolean method_5810() {
        return false;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_5529() instanceof class_1309 attacker && !(source.method_5529() instanceof VoidFragmentEntity)) {
            if (this.circling) {
                this.method_5980(attacker);
            }
            amount *= 0.5F;
            attacker.method_6005(4.0D, this.method_23317() - source.method_5529().method_23317(), this.method_23321() - source.method_5529().method_23321());
            attacker.method_5643(this.method_48923().method_48831(), 1f);
        }
        if (source.method_5526() instanceof ThrownRockEntity) {
            return false;
        }
        if (source.method_48789(class_8103.field_42247)) {
            if (source.method_5526() instanceof class_1667 arrowEntity) {
                if (arrowEntity.method_5851()) {
                    return true;
                }
                source.method_5526().method_31472();
                return false;
            }

        }
        return !this.method_5679(source) && super.method_5643(source, amount);
    }

    @Override
    public void method_6078(class_1282 source) {
        if (!this.method_37908().method_8608()) {
            if (!this.blockPosList.isEmpty()) {
                for (int u = 0; u < this.blockPosList.size(); ++u) {
                    this.method_37908().method_8501(this.blockPosList.get(u), BlockInit.VOID_STONE.method_9564());
                    this.method_37908().method_8396(null, this.blockPosList.get(u), class_3417.field_14574, class_3419.field_15245, 1F, 1F);
                }
            }
        }
        super.method_6078(source);
    }

    @Override
    protected class_3414 method_5994() {
        return SoundInit.SHADOW_IDLE_EVENT;
    }

    @Override
    protected class_3414 method_6002() {
        return SoundInit.SHADOW_DEATH_EVENT;
    }

    @Override
    protected float method_6107() {
        return 5.0F;
    }

    private void deathParticles(class_2394 particleEffect) {
        float f = (this.field_5974.method_43057() - 0.5F) * 16.0F;
        float g = (this.field_5974.method_43057() - 0.5F) * 10.0F;
        float h = (this.field_5974.method_43057() - 0.5F) * 16.0F;
        this.method_37908().method_8406(particleEffect, this.method_23317() + (double) f, this.method_23318() + 2.0D + (double) g, this.method_23321() + (double) h, 0.0D, 0.0D, 0.0D);
    }

    @Override
    protected void method_6108() {
        ++this.ticksSinceDeath;
        this.method_5977(true);
        this.method_5980(null);
        if (this.method_37908().method_8608()) {
            if (this.ticksSinceDeath >= 0 && this.ticksSinceDeath < 40) {
                for (int i = 0; i < 10; i++) {
                    deathParticles(class_2398.field_11214);
                }
            }

            if (this.ticksSinceDeath >= 41 && this.ticksSinceDeath <= 200) {
                deathParticles(class_2398.field_22447);
            }
        }
        if (!this.method_37908().method_8608()) {
            this.bossBar.method_5408(0.0F);
            if (this.ticksSinceDeath == 1 && !this.method_5701()) {
                this.method_37908().method_8474(1028, this.method_24515(), 0);
            }
            if (this.hasVoidMiddleCoordinates() && this.ticksSinceDeath == 40) {
                this.method_6082(this.getVoidMiddle().method_10263(), this.getVoidMiddle().method_10086(5).method_10264(), this.getVoidMiddle().method_10260(), false);
            }
        }

        this.method_5784(class_1313.field_6308, new class_243(0.0D, 0.05D, 0.0D));
        if (this.ticksSinceDeath >= 198) {
            for (int i = 0; i < 100; i++) {
                deathParticles(class_2398.field_11251);
            }
        }
        if (this.ticksSinceDeath >= 200 && !this.method_37908().method_8608()) {
            class_238 box = new class_238(this.method_24515());
            List<class_1657> list = this.method_37908().method_8390(class_1657.class, box.method_1014(128D), class_1301.field_6155);
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).method_6092(new class_1293(EffectInit.FAME, 48000, 0, false, false, true));
            }
            if (this.isInVoidDungeon) {
                boolean direction = this.method_37908().method_8409().method_43048(2) == 0;

                class_2338 pos = direction ? this.getVoidMiddle().method_10076(3) : this.getVoidMiddle().method_10077(3);
                class_2680 state = net.adventurez.init.BlockInit.SHADOW_CHEST.method_9564().method_11657(ShadowChest.FACING, direction ? class_2350.field_11035 : class_2350.field_11043);
                this.method_37908().method_8652(pos, state, 3);
                state.method_26204().method_9567(this.method_37908(), pos, state, null, class_1799.field_8037);

                if (this.method_37908().method_8321(this.getVoidMiddle().method_10074()) != null
                        && this.method_37908().method_8321(this.getVoidMiddle().method_10074()) instanceof PortalBlockEntity portalBlockEntity) {
                    portalBlockEntity.bossTime = (int) this.method_37908().method_8401().method_188();
                }
            } else {
                this.method_37908().method_8652(this.method_24515(), class_2246.field_10081.method_9564(), 3);
            }
            this.method_31472();
        }
    }

    static {
        HALF_LIFE_CHANGE = class_2945.method_12791(VoidShadowEntity.class, class_2943.field_13323);
        IS_THROWING_BLOCKS = class_2945.method_12791(VoidShadowEntity.class, class_2943.field_13323);
        HOVERING_MAGIC_HANDS = class_2945.method_12791(VoidShadowEntity.class, class_2943.field_13323);
        CIRCLING_HANDS = class_2945.method_12791(VoidShadowEntity.class, class_2943.field_13323);
    }

    static class FlyGoal extends class_1352 {
        private final VoidShadowEntity voidShadowEntity;

        public FlyGoal(VoidShadowEntity voidShadowEntity) {
            this.voidShadowEntity = voidShadowEntity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_1335 moveControl = this.voidShadowEntity.method_5962();
            if ((!moveControl.method_6241() || this.voidShadowEntity.method_5968() != null) && !voidShadowEntity.circling) {
                return true;
            } else {
                double d = moveControl.method_6236() - this.voidShadowEntity.method_23317();
                double e = moveControl.method_6235() - this.voidShadowEntity.method_23318();
                double f = moveControl.method_6237() - this.voidShadowEntity.method_23321();
                double g = d * d + e * e + f * f;
                return g < 1.0D || g > 3600.0D;
            }
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6269() {
            if (this.voidShadowEntity.method_5968() != null && this.voidShadowEntity.method_5739(this.voidShadowEntity.method_5968()) > 30.0F) {
                class_2338 pos = this.voidShadowEntity.method_5968().method_24515();
                this.voidShadowEntity.method_5962().method_6239(pos.method_10263(), pos.method_10264(), pos.method_10260(), 0.01D);
            }
        }
    }

    static class VoidShadowMoveControl extends class_1335 {
        private final VoidShadowEntity voidShadowEntity;

        public VoidShadowMoveControl(VoidShadowEntity voidShadowEntity) {
            super(voidShadowEntity);
            this.voidShadowEntity = voidShadowEntity;
        }

        @Override
        public void method_6240() {
            if (voidShadowEntity.circling && voidShadowEntity.hasVoidMiddleCoordinates()) {
                class_2338 pos = voidShadowEntity.getVoidMiddle();
                class_243 vec3d = new class_243((double) pos.method_10263() - this.voidShadowEntity.method_23317(), (double) pos.method_10264() - this.voidShadowEntity.method_23318(), (double) pos.method_10260() - this.voidShadowEntity.method_23321());
                vec3d = vec3d.method_1029();
                class_243 distanceVector = new class_243((double) this.voidShadowEntity.method_23317(), this.voidShadowEntity.method_23318(), this.voidShadowEntity.method_23321());
                if (distanceVector.method_1022(new class_243(pos.method_10263(), pos.method_10264(), pos.method_10260())) >= 50D) {
                    this.voidShadowEntity.method_18799(this.voidShadowEntity.method_18798().method_1019(vec3d.method_1021(0.1D)));
                } else {
                    this.voidShadowEntity.method_18799(this.voidShadowEntity.method_18798().method_1019(vec3d.method_1021(0.1D).method_1021(-1.0D)));
                    // Max partly Vector is 0.21 ca
                }

                this.voidShadowEntity.method_18799(this.voidShadowEntity.method_18798().method_1019(vec3d.method_1021(0.1D).method_1024(90F)));
                if (this.voidShadowEntity.method_18798().method_1033() <= 0.3D) {
                    this.voidShadowEntity.method_5762(0.1D, 0.1D, 0.1D);
                }
            } else if (this.field_6374 == class_1335.class_1336.field_6378) {
                class_243 vec3d = new class_243(this.field_6370 - this.voidShadowEntity.method_23317(), this.field_6369 - this.voidShadowEntity.method_23318(), this.field_6367 - this.voidShadowEntity.method_23321());
                vec3d = vec3d.method_1029();
                this.voidShadowEntity.method_18799(this.voidShadowEntity.method_18798().method_1019(vec3d.method_1021(0.1D)));
            }
        }

    }

    static class LookGoal extends class_1352 {
        private final VoidShadowEntity voidShadowEntity;
        private static final class_4051 PLAYER_PREDICATE = class_4051.method_36625().method_18418(80.0D).method_36627();

        public LookGoal(VoidShadowEntity voidShadowEntity) {
            this.voidShadowEntity = voidShadowEntity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        @Override
        public boolean method_6264() {
            return true;
        }

        @Override
        public void method_6268() {
            if (voidShadowEntity.circling && voidShadowEntity.hasVoidMiddleCoordinates()) {
                class_2338 pos = voidShadowEntity.getVoidMiddle();
                class_243 vec3d = new class_243((double) pos.method_10263() - this.voidShadowEntity.method_23317(), (double) pos.method_10264() - this.voidShadowEntity.method_23318(), (double) pos.method_10260() - this.voidShadowEntity.method_23321());
                this.voidShadowEntity.method_36456(-((float) class_3532.method_15349(vec3d.field_1352, vec3d.field_1350)) * 57.295776F);
                this.voidShadowEntity.field_6283 = this.voidShadowEntity.method_36454();
                this.voidShadowEntity.method_5980(this.voidShadowEntity.method_37908().method_18462(PLAYER_PREDICATE, this.voidShadowEntity));
            } else if (this.voidShadowEntity.method_5968() == null) {
                class_243 vec3d = this.voidShadowEntity.method_18798();
                this.voidShadowEntity.method_36456(-((float) class_3532.method_15349(vec3d.field_1352, vec3d.field_1350)) * 57.295776F);
                this.voidShadowEntity.field_6283 = this.voidShadowEntity.method_36454();
            } else {
                class_1309 livingEntity = this.voidShadowEntity.method_5968();
                if (livingEntity.method_5858(this.voidShadowEntity) < 4096.0D) {
                    double e = livingEntity.method_23317() - this.voidShadowEntity.method_23317();
                    double f = livingEntity.method_23321() - this.voidShadowEntity.method_23321();
                    this.voidShadowEntity.method_36456(-((float) class_3532.method_15349(e, f)) * 57.295776F);
                    this.voidShadowEntity.field_6283 = this.voidShadowEntity.method_36454();
                }
            }

        }
    }

    static class ThrowBlocks extends class_1352 {
        private final VoidShadowEntity voidShadow;
        private int throwTicker;
        private int throwBlocks;

        public ThrowBlocks(VoidShadowEntity voidShadow) {
            this.voidShadow = voidShadow;
        }

        @Override
        public boolean method_6264() {
            class_1309 livingEntity = this.voidShadow.method_5968();
            // distance 1F per block :)
            if (livingEntity != null && this.voidShadow.circling && this.voidShadow.method_5739(livingEntity) > 5.0F && this.voidShadow.method_5739(livingEntity) < 30.0F) {
                throwTicker++;
                return throwTicker >= 80;
            } else
                return false;
        }

        @Override
        public void method_6268() {
            class_1309 livingEntity = this.voidShadow.method_5968();
            if (livingEntity != null) {
                this.voidShadow.field_6206.method_6226(livingEntity, 1.0F, 1.0F);

                throwBlocks++;
                if (throwBlocks >= 10) {
                    class_2338 pos = this.voidShadow.method_24515();
                    for (int i = 0; i < (this.voidShadow.isHalfLife ? 60 : 40); i++) {
                        if (!this.voidShadow.method_37908().method_8608()) {
                            double random = this.voidShadow.method_37908().method_8409().method_43058() + 0.3D;
                            double anotherRandom = this.voidShadow.method_37908().method_8409().method_43058();
                            double anotherExtraRandom = this.voidShadow.method_37908().method_8409().method_43058() - 0.5D;
                            double anotherExtraXXXRandom = this.voidShadow.method_37908().method_8409().method_43058() - 0.5D;
                            class_2248 block;
                            if (this.voidShadow.hasVoidMiddleCoordinates()) {
                                block = this.voidShadow.method_37908().method_8320(this.voidShadow.getVoidMiddle().method_10095().method_10074()).method_26204();
                            } else if (!this.voidShadow.method_37908().method_8320(pos.method_10087(5)).method_26215()) {
                                block = this.voidShadow.method_37908().method_8320(pos.method_10087(5)).method_26204();
                            } else {
                                block = class_2246.field_10340;
                            }
                            ThrownRockEntity thrownRockEntity = new ThrownRockEntity(this.voidShadow.method_37908(), this.voidShadow);
                            class_243 vec3d = new class_243(livingEntity.method_23317() - this.voidShadow.method_23317(), livingEntity.method_23318() - this.voidShadow.method_23318(), livingEntity.method_23321() - this.voidShadow.method_23321());
                            vec3d = vec3d.method_1031(anotherExtraRandom * 12.0D, 5.0D * anotherRandom, anotherExtraXXXRandom * 12.0D);
                            vec3d = vec3d.method_1029();
                            thrownRockEntity.method_18799(thrownRockEntity.method_18798().method_1019(vec3d.method_1021(1.4D * random)));
                            thrownRockEntity.method_16940(new class_1799(block.method_8389()));
                            this.voidShadow.method_37908().method_8649(thrownRockEntity);

                        }
                    }
                    this.voidShadow.method_37908().method_43129((class_1657) null, this.voidShadow, SoundInit.ROCK_THROW_EVENT, class_3419.field_15251, 1.0F, 1.0F);
                    throwBlocks = 0;
                    this.method_6270();
                }
            }

        }

        @Override
        public boolean method_6266() {
            class_1309 livingEntity = this.voidShadow.method_5968();
            if (livingEntity == null || !livingEntity.method_5805()) {
                return false;
            } else
                return this.voidShadow.method_5739(livingEntity) > 5.0F && this.voidShadow.method_5739(livingEntity) < 30.0F && throwTicker == 0;
        }

        @Override
        public void method_6269() {
            this.voidShadow.field_6011.method_12778(IS_THROWING_BLOCKS, true);
            this.voidShadow.method_5942().method_6340();
            throwTicker = 0;
        }

        @Override
        public void method_6270() {
            this.voidShadow.field_6011.method_12778(IS_THROWING_BLOCKS, false);
            throwTicker++;
        }

    }

    // Goals run only on the server
    static class DestroyBlocksAttack extends class_1352 {
        private final VoidShadowEntity voidShadow;
        private int canStartTicker;
        private int destroyBlocksTicker;
        private static final class_4051 PLAYER_PREDICATE = class_4051.method_36625().method_18418(128.0D).method_36627();
        private List<class_2338> playerBlockPosList = new ArrayList<class_2338>();

        public DestroyBlocksAttack(VoidShadowEntity voidShadow) {
            this.voidShadow = voidShadow;
        }

        @Override
        public boolean method_6264() {
            class_1309 livingEntity = this.voidShadow.method_5968();
            if (livingEntity != null && this.voidShadow.isInVoidDungeon) {
                canStartTicker++;

                return canStartTicker >= 200;
            } else
                return false;
        }

        @Override
        public void method_6268() {
            destroyBlocksTicker++;
            if (destroyBlocksTicker == 40 && this.voidShadow.method_5968() != null) {
                class_238 box = new class_238(this.voidShadow.method_24515());
                List<class_1657> playerList = this.voidShadow.method_37908().method_18464(PLAYER_PREDICATE, this.voidShadow, box.method_1014(120D));
                for (int i = 0; i < playerList.size(); ++i) {
                    class_1657 playerEntity = playerList.get(i);
                    if (!playerEntity.method_7337() && !playerEntity.method_7325()) {
                        if (!this.voidShadow.method_37908().method_8320(playerEntity.method_24515().method_10074()).method_26215()) {
                            playerBlockPosList.add(playerEntity.method_24515().method_10074());
                        } else if (!this.voidShadow.method_37908().method_8320(playerEntity.method_24515().method_10087(2)).method_26215()) {
                            playerBlockPosList.add(playerEntity.method_24515().method_10087(2));
                        }
                    }
                }
                for (int u = 0; u < playerBlockPosList.size(); ++u) {
                    class_2338 pos = playerBlockPosList.get(u);
                    int radius = this.voidShadow.isHalfLife ? 5 : 3;
                    for (int k = -radius; k <= radius; k++) {
                        for (int i = -radius; i <= radius; i++) {
                            class_2338 blockPos = pos.method_10069(k, 0, i).method_10069(class_3532.method_15357(Math.sin(k)) * i, 0, class_3532.method_15357(Math.cos(k)) * i);
                            if (!this.voidShadow.blockPosList.contains(blockPos) && !this.voidShadow.method_37908().method_8320(blockPos).method_26215()
                                    && !this.voidShadow.method_37908().method_8320(blockPos).method_26164(TagInit.UNBREAKABLE_BLOCKS)) {
                                this.voidShadow.blockPosList.add(blockPos);
                            }
                        }
                    }
                }
                for (int u = 0; u < this.voidShadow.blockPosList.size(); ++u) {
                    this.voidShadow.method_37908().method_8501(this.voidShadow.blockPosList.get(u), BlockInit.VOID_STONE.method_9564().method_11657(VoidStoneBlock.ACTIVATED, true));
                }

            }
            if (destroyBlocksTicker == 110) {
                ((class_3218) this.voidShadow.method_37908()).method_43129(null, this.voidShadow, SoundInit.SHADOW_CAST_EVENT, class_3419.field_15251, 20.0F, 1.0F);
            }
            if (destroyBlocksTicker == 120) {
                this.voidShadow.field_6011.method_12778(HOVERING_MAGIC_HANDS, false);
            }
            if (destroyBlocksTicker >= 400) {
                destroyBlocksTicker = 0;
                this.method_6270();
            }

        }

        @Override
        public boolean method_6266() {
            return canStartTicker == 0;
        }

        @Override
        public void method_6269() {
            this.voidShadow.field_6011.method_12778(HOVERING_MAGIC_HANDS, true);
            canStartTicker = 0;
            ((class_3218) this.voidShadow.method_37908()).method_43129(null, this.voidShadow, SoundInit.SHADOW_PREPARE_EVENT, class_3419.field_15251, 20.0F, 1.0F);
        }

        @Override
        public void method_6270() {
            canStartTicker++;
            for (int u = 0; u < this.voidShadow.blockPosList.size(); ++u) {
                this.voidShadow.method_37908().method_8501(this.voidShadow.blockPosList.get(u), BlockInit.VOID_STONE.method_9564());
                this.voidShadow.method_37908().method_8396(null, this.voidShadow.blockPosList.get(u), class_3417.field_14574, class_3419.field_15245, 1F, 1F);
            }
            if (!this.voidShadow.blockPosList.isEmpty()) {
                this.voidShadow.blockPosList.clear();
            }
            if (!playerBlockPosList.isEmpty()) {
                playerBlockPosList.clear();
            }
        }

    }

    static class SummonFragment extends class_1352 {
        private final VoidShadowEntity voidShadow;
        private int summonStartTicker;
        private int summonTick;

        public SummonFragment(VoidShadowEntity voidShadow) {
            this.voidShadow = voidShadow;
        }

        @Override
        public boolean method_6264() {
            class_1309 livingEntity = this.voidShadow.method_5968();
            if (voidShadow.isInVoidDungeon && voidShadow.circling && voidShadow.hasVoidMiddleCoordinates() && livingEntity != null) {
                summonStartTicker++;
                if (summonStartTicker >= 200) {

                    class_238 box = new class_238(voidShadow.method_24515());
                    List<VoidFragmentEntity> list = voidShadow.method_37908().method_8390(VoidFragmentEntity.class, box.method_1014(120D), class_1301.field_6155);
                    if (list.isEmpty() || list.size() < 2) {
                        return true;
                    }
                    summonStartTicker = 0;
                }

                return false;
            } else
                return false;
        }

        @Override
        public void method_6268() {
            summonTick++;
            if (summonTick >= 40 && this.voidShadow.method_5968() != null) {
                class_2338 pos = this.voidShadow.getVoidMiddle();
                Boolean isOrb = this.voidShadow.field_5974.method_43057() < 0.35F;
                for (int i = 0; i < (isOrb ? 4 : 10); i++) {
                    if (!this.voidShadow.method_37908().method_8608()) {
                        class_2338 spawnPos;
                        if (isOrb) {
                            if (i < 2) {
                                spawnPos = new class_2338(pos.method_10263() + 28 * (i - 1), pos.method_10264(), pos.method_10260() + 28 * i);
                            } else {
                                spawnPos = new class_2338(pos.method_10263() + 28 * (-i + 3), pos.method_10264(), pos.method_10260() + 28 * (-i + 2));
                            }
                        } else {
                            spawnPos = new class_2338(pos.method_10263() - 35 + voidShadow.field_5974.method_43048(70), pos.method_10264(), pos.method_10260() - 35 + voidShadow.field_5974.method_43048(70));
                        }
                        if (!this.voidShadow.method_37908().method_8320(spawnPos.method_10074()).method_26215()) {
                            VoidFragmentEntity voidFragmentEntity = (VoidFragmentEntity) EntityInit.VOID_FRAGMENT.method_5883(voidShadow.method_37908());
                            voidFragmentEntity.method_5943((class_3218) voidShadow.method_37908(), voidShadow.method_37908().method_8404(pos), class_3730.field_16467, null);
                            voidFragmentEntity.setVoidOrb(isOrb);
                            voidFragmentEntity.method_5725(spawnPos, voidShadow.method_37908().method_8409().method_43057() * 360F, 0.0F);
                            voidShadow.method_37908().method_8649(voidFragmentEntity);
                            if (!isOrb) {
                                VoidCloudEntity voidCloudEntity = new VoidCloudEntity(voidShadow.method_37908(), voidFragmentEntity.method_23317(), voidFragmentEntity.method_23318(), voidFragmentEntity.method_23321());
                                int random = voidShadow.method_37908().method_8409().method_43048(7) + 6;
                                voidCloudEntity.setRadius(random);
                                voidCloudEntity.setDuration(random * 140);
                                voidShadow.method_37908().method_8649(voidCloudEntity);
                            }
                        }
                    }
                }
                summonTick = 0;
                this.method_6270();
            }

        }

        @Override
        public void method_6269() {
            this.voidShadow.field_6011.method_12778(HOVERING_MAGIC_HANDS, true);
            ((class_3218) this.voidShadow.method_37908()).method_43129(null, this.voidShadow, SoundInit.SHADOW_PREPARE_EVENT, class_3419.field_15251, 20.0F, 1.0F);
        }

        @Override
        public void method_6270() {
            this.voidShadow.field_6011.method_12778(HOVERING_MAGIC_HANDS, false);
            ((class_3218) this.voidShadow.method_37908()).method_43129(null, this.voidShadow, SoundInit.SHADOW_CAST_EVENT, class_3419.field_15251, 20.0F, 1.0F);
        }

    }

    static class Insanity extends class_1352 {
        private final VoidShadowEntity voidShadow;
        private int insanityStartTicker;
        private int tick;
        private static final class_4051 PLAYER_PREDICATE = class_4051.method_36625().method_18418(80.0D).method_36627();
        private List<class_1657> playerList;

        public Insanity(VoidShadowEntity voidShadow) {
            this.voidShadow = voidShadow;
        }

        @Override
        public boolean method_6264() {
            if (voidShadow.isInVoidDungeon && voidShadow.circling && this.voidShadow.isHalfLife && voidShadow.hasVoidMiddleCoordinates() && this.voidShadow.blockPosList.isEmpty()) {
                insanityStartTicker++;
                if (insanityStartTicker >= 600) {
                    return true;
                }
                return false;
            } else
                return false;
        }

        @Override
        public void method_6268() {
            tick++;
            this.voidShadow.method_5980(null);
            if (tick == 60) {
                class_238 box = new class_238(this.voidShadow.method_24515());
                playerList = this.voidShadow.method_37908().method_18464(PLAYER_PREDICATE, this.voidShadow, box.method_1014(120D));
                for (int i = 0; i < playerList.size(); ++i) {
                    class_1657 playerEntity = playerList.get(i);
                    playerEntity.method_6092(new class_1293(class_1294.field_5909, 60 + this.voidShadow.field_5974.method_43048(80), this.voidShadow.field_5974.method_43048(4), false, false, true));
                    playerEntity.method_6092(new class_1293(class_1294.field_5919, 40 + this.voidShadow.field_5974.method_43048(60), 0, false, false, true));
                }
            }
            if (tick == 100) {
                int radius = 8;
                class_2338 pos = this.voidShadow.getVoidMiddle().method_10074();
                for (int k = -radius; k <= radius; k++) {
                    for (int i = -radius; i <= radius; i++) {
                        class_2338 blockPos = pos.method_10069(k, 0, i);

                        if (this.voidShadow.field_5974.method_43057() < 0.4F) {
                            if (!this.voidShadow.blockPosList.contains(blockPos) && !this.voidShadow.method_37908().method_8320(blockPos).method_26215()
                                    && !this.voidShadow.method_37908().method_8320(blockPos).method_26164(TagInit.UNBREAKABLE_BLOCKS)) {
                                this.voidShadow.blockPosList.add(blockPos);
                            }
                        }
                    }
                }
                for (int u = 0; u < this.voidShadow.blockPosList.size(); ++u) {
                    this.voidShadow.method_37908().method_8501(this.voidShadow.blockPosList.get(u), BlockInit.INFESTED_VOID.method_9564());
                }
                ((class_3218) this.voidShadow.method_37908()).method_43129(null, this.voidShadow, SoundInit.SHADOW_CAST_EVENT, class_3419.field_15251, 20.0F, 1.0F);
            }
            if (tick >= 300) {
                if (this.voidShadow.method_6032() < this.voidShadow.method_6063() / 10 && !playerList.isEmpty()) {
                    for (int i = 0; i < playerList.size(); i++) {
                        if (playerList.get(i) instanceof class_3222 serverPlayerEntity) {
                            ServerPlayNetworking.send(serverPlayerEntity, new VelocityPacket(playerList.get(i).method_5628(), this.voidShadow.field_5974.method_43057() * 2F));
                        }
                    }
                    ((class_3218) this.voidShadow.method_37908()).method_43129(null, this.voidShadow, SoundInit.SHADOW_IDLE_EVENT, class_3419.field_15251, 20.0F, 1.0F);
                }
                tick = 0;
                this.method_6270();
            }

        }

        @Override
        public boolean method_6266() {
            return insanityStartTicker >= 600;
        }

        @Override
        public void method_6269() {
            voidShadow.circling = false;
            voidShadow.wasCircling = true;
            this.voidShadow.field_6207.method_6239((double) voidShadow.getVoidMiddle().method_10263(), (double) voidShadow.getVoidMiddle().method_10264(), (double) voidShadow.getVoidMiddle().method_10260(), 1.0D);
            this.voidShadow.method_5762(0D, 0.2D, 0D);
            this.voidShadow.field_6011.method_12778(CIRCLING_HANDS, true);
            ((class_3218) this.voidShadow.method_37908()).method_43129(null, this.voidShadow, SoundInit.SHADOW_PREPARE_EVENT, class_3419.field_15251, 20.0F, 1.0F);
        }

        @Override
        public void method_6270() {
            voidShadow.circling = true;
            voidShadow.wasCircling = false;
            this.voidShadow.field_6011.method_12778(CIRCLING_HANDS, false);
            ((class_3218) this.voidShadow.method_37908()).method_43129(null, this.voidShadow, SoundInit.SHADOW_CAST_EVENT, class_3419.field_15251, 20.0F, 1.0F);
            insanityStartTicker = 0;
            for (int u = 0; u < this.voidShadow.blockPosList.size(); ++u) {
                this.voidShadow.method_37908().method_8501(this.voidShadow.blockPosList.get(u), BlockInit.VOID_STONE.method_9564());
            }
            if (!this.playerList.isEmpty()) {
                this.playerList.clear();
            }
            if (!this.voidShadow.blockPosList.isEmpty()) {
                this.voidShadow.blockPosList.clear();
            }
        }

    }

    static class SummonShade extends class_1352 {
        private final VoidShadowEntity voidShadow;
        private int summonStartTicker;
        private int summonTick;

        public SummonShade(VoidShadowEntity voidShadow) {
            this.voidShadow = voidShadow;
        }

        @Override
        public boolean method_6264() {
            class_1309 livingEntity = this.voidShadow.method_5968();
            if (voidShadow.isInVoidDungeon && voidShadow.hasVoidMiddleCoordinates() && livingEntity != null) {
                summonStartTicker++;
                if (summonStartTicker >= 80) {
                    class_238 box = new class_238(voidShadow.method_24515());
                    List<VoidShadeEntity> list = voidShadow.method_37908().method_8390(VoidShadeEntity.class, box.method_1014(120D), class_1301.field_6155);
                    if (list.size() < 6) {
                        return true;
                    }
                    summonStartTicker = 0;
                }
                return false;
            } else
                return false;
        }

        @Override
        public void method_6268() {
            summonTick++;
            if (summonTick >= 40 && this.voidShadow.method_5968() != null) {
                class_2338 pos = this.voidShadow.getVoidMiddle();
                for (int i = 0; i < (this.voidShadow.isHalfLife ? 24 : 16); i++) {
                    if (!this.voidShadow.method_37908().method_8608()) {
                        class_2338 spawnPos = new class_2338(pos.method_10263() - 35 + voidShadow.field_5974.method_43048(70), pos.method_10264(), pos.method_10260() - 35 + voidShadow.field_5974.method_43048(70));
                        VoidShadeEntity voidShadeEntity = (VoidShadeEntity) EntityInit.VOID_SHADE.method_5883(voidShadow.method_37908());
                        voidShadeEntity.method_5943((class_3218) voidShadow.method_37908(), voidShadow.method_37908().method_8404(pos), class_3730.field_16467, null);
                        voidShadeEntity.method_5725(spawnPos, voidShadow.method_37908().method_8409().method_43057() * 360F, 0.0F);
                        voidShadow.method_37908().method_8649(voidShadeEntity);
                    }
                }
                summonTick = 0;
                this.method_6270();
            }

        }

        @Override
        public void method_6269() {
            this.voidShadow.field_6011.method_12778(HOVERING_MAGIC_HANDS, true);
            ((class_3218) this.voidShadow.method_37908()).method_43129(null, this.voidShadow, SoundInit.SHADOW_PREPARE_EVENT, class_3419.field_15251, 20.0F, 1.0F);
        }

        @Override
        public void method_6270() {
            this.voidShadow.field_6011.method_12778(HOVERING_MAGIC_HANDS, false);
            ((class_3218) this.voidShadow.method_37908()).method_43129(null, this.voidShadow, SoundInit.SHADOW_CAST_EVENT, class_3419.field_15251, 20.0F, 1.0F);
        }

    }
}
