package net.adventurez.entity.goal;

import java.util.EnumSet;

import net.adventurez.entity.DragonEntity;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_243;
import net.minecraft.class_7;

public class DragonFindOwnerGoal extends class_1352 {
    private final DragonEntity dragonEntity;
    private class_1309 owner;
    private final double speed;
    private final class_1408 navigation;
    private int updateCountdownTicks;
    private final float maxDistance;
    private final float minDistance;
    private float oldWaterPathfindingPenalty;

    public DragonFindOwnerGoal(DragonEntity dragonEntity, double speed, float minDistance, float maxDistance) {
        this.dragonEntity = dragonEntity;
        this.speed = speed;
        this.navigation = dragonEntity.method_5942();
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    @Override
    public boolean method_6264() {
        class_1309 livingEntity = this.dragonEntity.method_35057();
        if (livingEntity == null) {
            return false;
        } else if (livingEntity.method_7325()) {
            return false;
        } else if (this.dragonEntity.isInSittingPose()) {
            return false;
        } else if (!this.dragonEntity.isFlying) {
            return false;
        } else if (this.dragonEntity.method_5782()) {
            return false;
        } else if (!this.dragonEntity.method_6057(livingEntity)) {
            return false;
        } else if (this.dragonEntity.method_5858(livingEntity) < (double) (this.minDistance * this.minDistance)) {
            return false;
        } else {
            this.owner = livingEntity;
            return true;
        }
    }

    @Override
    public boolean method_6266() {
        if (this.dragonEntity.method_5858(this.owner) > 800.0D) {
            return false;
        } else if (this.dragonEntity.isInSittingPose() || !this.dragonEntity.method_6057(this.owner)) {
            return false;
        } else {
            return this.dragonEntity.method_5858(this.owner) > (double) (this.maxDistance * this.maxDistance) && !dragonEntity.method_24828() && dragonEntity.isFlying;
        }
    }

    @Override
    public void method_6269() {
        this.updateCountdownTicks = 0;
        this.oldWaterPathfindingPenalty = this.dragonEntity.method_5944(class_7.field_18);
        this.dragonEntity.method_5941(class_7.field_18, 0.0F);
    }

    @Override
    public void method_6270() {
        this.owner = null;
        this.navigation.method_6340();
        this.dragonEntity.method_5941(class_7.field_18, this.oldWaterPathfindingPenalty);
    }

    @Override
    public void method_6268() {
        this.dragonEntity.method_5988().method_6226(this.owner, 10.0F, (float) this.dragonEntity.method_5978());
        if (--this.updateCountdownTicks <= 0) {
            this.updateCountdownTicks = 10;
            if (!this.dragonEntity.method_60953() && !this.dragonEntity.method_5765()) {
                if (this.dragonEntity.method_5858(this.owner) <= 800.0D) {
                    class_243 vec3d = new class_243(this.owner.method_23317() - this.dragonEntity.method_23317(), this.owner.method_23318() - this.dragonEntity.method_23318(), this.owner.method_23321() - this.dragonEntity.method_23321());
                    vec3d = vec3d.method_1029();
                    this.dragonEntity.method_18799(this.dragonEntity.method_18798().method_1019(vec3d.method_1021(this.speed)));
                }

            }
        }
    }

}
