package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;

import net.adventurez.entity.AmethystGolemEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4595;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(EnvType.CLIENT)
public class AmethystGolemModel<T extends AmethystGolemEntity> extends class_4595<T> {
    private final class_630 root;
    private final class_630 amethyst_golem;
    private final class_630 body;
    private final class_630 body2;
    private final class_630 amethyst2;
    private final class_630 amethyst2_r1;
    private final class_630 amethyst3;
    private final class_630 head;
    private final class_630 head_r1;
    private final class_630 arms;
    private final class_630 left_arm;
    private final class_630 amethyst;
    private final class_630 right_arm;
    private final class_630 amethyst4;
    private final class_630 legs;
    private final class_630 left_leg;
    private final class_630 right_leg;

    public AmethystGolemModel(class_630 root) {
        this.root = root.method_32086("root");
        this.amethyst_golem = this.root.method_32086("amethyst_golem");
        this.legs = this.amethyst_golem.method_32086("legs");
        this.right_leg = this.legs.method_32086("right_leg");
        this.left_leg = this.legs.method_32086("left_leg");
        this.arms = this.amethyst_golem.method_32086("arms");
        this.right_arm = this.arms.method_32086("right_arm");
        this.amethyst4 = this.right_arm.method_32086("amethyst4");
        this.left_arm = this.arms.method_32086("left_arm");
        this.amethyst = this.left_arm.method_32086("amethyst");
        this.head = this.amethyst_golem.method_32086("head");
        this.head_r1 = this.head.method_32086("head_r1");
        this.body = this.amethyst_golem.method_32086("body");
        this.body2 = this.body.method_32086("body2");
        this.amethyst3 = this.body2.method_32086("amethyst3");
        this.amethyst2 = this.body2.method_32086("amethyst2");
        this.amethyst2_r1 = this.amethyst2.method_32086("amethyst2_r1");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();

        class_5610 modelPartData1 = modelPartData.method_32117("root", class_5606.method_32108(), class_5603.method_32090(0.0F, 24.0F, 0.0F));
        class_5610 modelPartData2 = modelPartData1.method_32117("amethyst_golem", class_5606.method_32108(), class_5603.method_32090(0.0F, 0.0F, 0.0F));
        class_5610 modelPartData3 = modelPartData2.method_32117("body", class_5606.method_32108().method_32101(24, 24).method_32098(-5.5F, -7.0F, -4.0F, 11.0F, 8.0F, 8.0F, new class_5605(0.5F)),
                class_5603.method_32090(0.0F, -15.0F, 0.0F));
        class_5610 modelPartData4 = modelPartData3.method_32117("body2",
                class_5606.method_32108().method_32101(0, 0).method_32097(-9.0F, -11.0F, -6.0F, 18.0F, 12.0F, 12.0F).method_32101(60, 74).method_32097(2.5F, -7.0F, 3.5F, 7.0F, 6.0F, 3.0F).method_32101(0, 0)
                        .method_32097(-0.5F, -6.0F, 3.5F, 3.0F, 4.0F, 3.0F).method_32101(0, 7).method_32097(3.5F, -1.0F, 3.5F, 2.0F, 1.0F, 3.0F).method_32101(17, 54).method_32097(-9.5F, -10.5F, -6.5F, 8.0F, 12.0F, 7.0F).method_32101(67, 64)
                        .method_32097(-9.5F, -6.5F, 0.5F, 8.0F, 6.0F, 4.0F).method_32101(79, 18).method_32097(-9.5F, -8.5F, 0.5F, 8.0F, 2.0F, 2.0F),
                class_5603.method_32090(0.0F, -7.0F, 0.0F));
        class_5610 modelPartData5 = modelPartData4.method_32117("amethyst2", class_5606.method_32108(), class_5603.method_32090(3.0F, -11.0F, 2.0F));
        modelPartData5.method_32117("amethyst2_r1", class_5606.method_32108().method_32101(76, 46).method_32097(-2.0F, -39.0F, 0.0F, 10.0F, 8.0F, 0.0F).method_32101(0, 63).method_32097(3.0F, -39.0F, -5.0F, 0.0F, 8.0F, 10.0F),
                class_5603.method_32090(-3.0F, 32.0F, 0.0F));
        modelPartData4.method_32117("amethyst3", class_5606.method_32108().method_32101(40, 73).method_32097(-5.0F, -7.5F, 0.0F, 10.0F, 9.0F, 0.0F).method_32101(62, 27).method_32097(0.0F, -7.5F, -5.0F, 0.0F, 9.0F, 10.0F),
                class_5603.method_32090(-8.0F, -5.0F, -6.0F));
        class_5610 modelPartData6 = modelPartData2.method_32117("head",
                class_5606.method_32108().method_32101(52, 46).method_32097(-4.0F, -6.0F, -7.5F, 8.0F, 10.0F, 8.0F).method_32101(24, 40).method_32097(-4.5F, -0.5F, -8.0F, 9.0F, 5.0F, 9.0F),
                class_5603.method_32090(0.0F, -29.0F, -5.0F));
        modelPartData6.method_32117("head_r1", class_5606.method_32108().method_32101(0, 24).method_32097(-1.0F, -1.0F, -1.5F, 2.0F, 2.0F, 1.0F), class_5603.method_32090(0.0F, -1.0F, -7.0F));
        class_5610 modelPartData7 = modelPartData2.method_32117("arms", class_5606.method_32108(), class_5603.method_32090(0.0F, 2.0F, 0.0F));
        class_5610 modelPartData8 = modelPartData7.method_32117("left_arm", class_5606.method_32108().method_32101(0, 24).method_32097(-1.0F, -2.5F, -3.0F, 6.0F, 27.0F, 6.0F).method_32101(0, 57)
                .method_32097(2.0F, 5.5F, -4.0F, 4.0F, 4.0F, 4.0F).method_32101(60, 0).method_32097(-1.5F, 14.5F, -3.5F, 7.0F, 11.0F, 7.0F), class_5603.method_32090(10.0F, -31.0F, 0.0F));
        modelPartData8.method_32117("amethyst", class_5606.method_32108().method_32101(20, 73).method_32097(-5.0F, -7.5F, 0.0F, 10.0F, 9.0F, 0.0F).method_32101(47, 54).method_32097(0.0F, -7.5F, -5.0F, 0.0F, 9.0F, 10.0F),
                class_5603.method_32090(4.0F, -1.0F, 0.0F));
        class_5610 modelPartData9 = modelPartData7.method_32117("right_arm", class_5606.method_32108().method_32101(0, 24).method_32100(-5.0F, -2.5F, -3.0F, 6.0F, 27.0F, 6.0F, true).method_32101(0, 57)
                .method_32100(-6.0F, 6.5F, -4.0F, 4.0F, 4.0F, 4.0F, true).method_32101(60, 0).method_32100(-5.5F, 14.5F, -3.5F, 7.0F, 11.0F, 7.0F, true), class_5603.method_32090(-10.0F, -31.0F, 0.0F));
        modelPartData9.method_32117("amethyst4", class_5606.method_32108().method_32101(20, 73).method_32100(-5.0F, -7.5F, 0.0F, 10.0F, 9.0F, 0.0F, true).method_32101(47, 54).method_32100(0.0F, -7.5F, -5.0F, 0.0F, 9.0F, 10.0F, true),
                class_5603.method_32090(-4.0F, -1.0F, 0.0F));
        class_5610 modelPartData10 = modelPartData2.method_32117("legs", class_5606.method_32108(), class_5603.method_32090(0.0F, -13.0F, 0.0F));
        modelPartData10.method_32117("left_leg", class_5606.method_32108().method_32101(62, 18).method_32097(-2.5F, -1.0F, -3.0F, 6.0F, 14.0F, 5.0F), class_5603.method_32090(4.0F, 0.0F, 0.0F));
        modelPartData10.method_32117("right_leg", class_5606.method_32108().method_32101(62, 18).method_32100(-3.5F, -1.0F, -3.0F, 6.0F, 14.0F, 5.0F, true), class_5603.method_32090(-4.0F, 0.0F, 0.0F));
        return class_5607.method_32110(modelData, 128, 128);

    }

    @Override
    public Iterable<class_630> method_22960() {
        return ImmutableList.of(this.root);
    }

    @Override
    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.amethyst2.field_3654 = -0.1745F;
        this.amethyst2.field_3675 = 0.1745F;
        this.amethyst2_r1.field_3675 = 0.3927F;
        this.amethyst3.field_3654 = 1.2217F;
        this.amethyst3.field_3675 = 0.4363F;
        this.head_r1.field_3654 = -0.0436F;
        this.amethyst.field_3674 = 0.6981F;
        this.amethyst4.field_3674 = -0.6981F;
        this.head.field_3675 = headYaw * 0.0089453292F;
        this.head.field_3654 = headPitch * 0.0047453292F;
        this.right_leg.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 1.4F * limbDistance;
        this.left_leg.field_3654 = class_3532.method_15362(limbAngle * 0.6662F) * 1.4F * limbDistance;
        this.right_arm.field_3654 = -class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 2.0F * limbDistance * 0.3F;
        this.left_arm.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 2.0F * limbDistance * 0.3F;
        float k = class_3532.method_15374(entity.field_6251 * 3.1415927F);
        if (k > 0) {
            this.right_arm.field_3654 = -k;
        }
        if (entity.method_5841().method_12789(AmethystGolemEntity.BACK_CRYSTALS) == 4) {
            amethyst.field_3665 = true;
            amethyst2.field_3665 = true;
            amethyst3.field_3665 = true;
            amethyst4.field_3665 = true;
        } else if (entity.method_5841().method_12789(AmethystGolemEntity.BACK_CRYSTALS) == 3) {
            amethyst.field_3665 = true;
            amethyst2.field_3665 = true;
            amethyst3.field_3665 = false;
            amethyst4.field_3665 = true;
        } else if (entity.method_5841().method_12789(AmethystGolemEntity.BACK_CRYSTALS) == 2) {
            amethyst.field_3665 = true;
            amethyst2.field_3665 = true;
            amethyst3.field_3665 = false;
            amethyst4.field_3665 = false;
        } else if (entity.method_5841().method_12789(AmethystGolemEntity.BACK_CRYSTALS) == 1) {
            amethyst.field_3665 = false;
            amethyst2.field_3665 = true;
            amethyst3.field_3665 = false;
            amethyst4.field_3665 = false;
        } else if (entity.method_5841().method_12789(AmethystGolemEntity.BACK_CRYSTALS) == 0) {
            amethyst.field_3665 = false;
            amethyst2.field_3665 = false;
            amethyst3.field_3665 = false;
            amethyst4.field_3665 = false;
        }
    }

}
