package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;

import net.adventurez.entity.BlackstoneGolemEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4595;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(EnvType.CLIENT)
public class BlackstoneGolemModel<T extends BlackstoneGolemEntity> extends class_4595<T> {
    private final class_630 head;
    private final class_630 torso;
    private final class_630 rightArm;
    private final class_630 leftArm;
    private final class_630 rightLeg;
    private final class_630 leftLeg;

    public BlackstoneGolemModel(class_630 root) {
        this.head = root.method_32086("head");
        this.torso = root.method_32086("torso");
        this.rightArm = root.method_32086("rightArm");
        this.leftArm = root.method_32086("leftArm");
        this.rightLeg = root.method_32086("rightLeg");
        this.leftLeg = root.method_32086("leftLeg");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        modelPartData.method_32117("head", class_5606.method_32108().method_32101(0, 0).method_32097(-4.0F, -7.0F, -5.6225F, 8.0F, 10.0F, 8.0F).method_32101(24, 0).method_32097(-1.0F, -0.0F, -7.6225F, 2.0F, 4.0F, 2.0F),
                class_5603.method_32090(0.0F, 2.5846F, -7.1554F));
        modelPartData.method_32117("torso",
                class_5606.method_32108().method_32101(0, 40).method_32097(-9.0F, -1.2929F, -8.1213F, 18.0F, 12.0F, 11.0F).method_32101(0, 70).method_32097(-4.5F, 10.7071F, -5.1213F, 9.0F, 5.0F, 6.0F).method_32101(42, 55)
                        .method_32097(-1.0F, 1.0F, 3.0F, 7.0F, 6.0F, 1.0F).method_32101(12, 57).method_32097(-1.0F, 6.0F, -9.0F, 8.0F, 3.0F, 1.0F).method_32101(28, 55).method_32097(-8.0F, 3.0F, -9.0F, 6.0F, 2.0F, 1.0F).method_32101(9, 56)
                        .method_32097(-6.0F, 5.0F, 3.0F, 3.0F, 4.0F, 1.0F).method_32101(33, 49).method_32097(-10.0F, 5.0F, -5.0F, 1.0F, 4.0F, 6.0F).method_32101(16, 54).method_32097(9.0F, 6.0F, -4.0F, 1.0F, 4.0F, 3.0F),
                class_5603.method_32090(0.0F, -2.0F, -1.0F));
        modelPartData.method_32117("rightArm", class_5606.method_32108().method_32101(60, 21).method_32097(-2.0F, -2.5F, -3.0F, 4.0F, 30.0F, 6.0F).method_32101(62, 29).method_32097(2.0F, 2.4378F, -1.4019F, 1.0F, 9.0F, 2.0F).method_32101(66, 47)
                .method_32097(2.0F, 19.5981F, 0.768F, 1.0F, 4.0F, 1.0F).method_32101(61, 46).method_32097(-3.0F, 18.4378F, -1.9019F, 1.0F, 9.0F, 2.0F), class_5603.method_32090(11.0F, 0.0F, -3.0F));
        modelPartData.method_32117("leftArm", class_5606.method_32108().method_32101(60, 58).method_32097(-2.0F, -2.5F, -3.0F, 4.0F, 30.0F, 6.0F).method_32101(70, 65).method_32097(-3.0F, 4.4378F, -0.4019F, 1.0F, 9.0F, 2.0F).method_32101(69, 85)
                .method_32097(-3.0F, 20.4378F, -0.9019F, 1.0F, 4.0F, 1.0F).method_32101(60, 80).method_32097(2.0F, 18.4378F, -1.9019F, 1.0F, 5.0F, 2.0F), class_5603.method_32090(-11.0F, 0.0F, -3.0F));
        modelPartData.method_32117("rightLeg", class_5606.method_32108().method_32101(37, 0).method_32097(1.5F, -0.6233F, -2.5578F, 6.0F, 16.0F, 5.0F), class_5603.method_32090(0.0F, 10.0F, 9.0F));
        modelPartData.method_32117("leftLeg", class_5606.method_32108().method_32101(60, 0).method_32097(-7.5F, -0.6233F, -2.5578F, 6.0F, 16.0F, 5.0F), class_5603.method_32090(0.0F, 10.0F, 9.0F));
        return class_5607.method_32110(modelData, 128, 128);
        // this.leftLeg.mirror = true;
    }

    @Override
    public Iterable<class_630> method_22960() {
        return ImmutableList.of(this.head, this.torso, this.rightLeg, this.leftLeg, this.rightArm, this.leftArm);
    }

    @Override
    public void setAngles(T stoneGolem, float f, float g, float h, float i, float j) {
        int roarTick = stoneGolem.getRoarTick();
        this.head.field_3675 = i * 0.0077453292F;
        this.head.field_3654 = j * 0.0017453292F + 0.2618F;
        this.rightLeg.field_3675 = 0.0F;
        this.leftLeg.field_3675 = 0.0F;
        this.rightLeg.field_3654 = -0.3F * class_3532.method_24504(f, 13.0F) * g + 0.1745F;
        this.leftLeg.field_3654 = 0.3F * class_3532.method_24504(f, 13.0F) * g + 0.1745F;
        this.torso.field_3654 = 0.7854F;
        this.rightArm.field_3654 = 0.5F * class_3532.method_24504(f, 13.0F) * g - 0.5236F;
        this.leftArm.field_3654 = -0.5F * class_3532.method_24504(f, 13.0F) * g - 0.5236F;
        int thrownRockTick = stoneGolem.method_5841().method_12789(BlackstoneGolemEntity.THROW_COOLDOWN);
        if (thrownRockTick >= 100) {
            this.leftArm.field_3654 = class_3532.method_15362(-thrownRockTick * 0.2F + 0.3F) - 0.3F;
        }
        if (roarTick > 18) {
            this.rightArm.field_3654 = class_3532.method_15374(roarTick / 5.832F) - 0.5236F;
            this.leftArm.field_3654 = class_3532.method_15374(roarTick / 5.832F) - 0.5236F;
        }
        float k = class_3532.method_15374(this.field_3447 * 3.1415927F) * 0.5F;
        if (k > 0.1F) {
            this.rightArm.field_3654 = -k - 0.5236F;
        }
    }

}
