package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;

import net.adventurez.entity.BrownFungusEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4595;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(EnvType.CLIENT)
public class BrownFungusModel<T extends BrownFungusEntity> extends class_4595<T> {
    private final class_630 head;
    private final class_630 body;
    private final class_630 leftFoot;
    private final class_630 rightFoot;

    public BrownFungusModel(class_630 root) {
        this.head = root.method_32086("head");
        this.body = root.method_32086("body");
        this.leftFoot = root.method_32086("leftFoot");
        this.rightFoot = root.method_32086("rightFoot");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        modelPartData.method_32117("head", class_5606.method_32108().method_32101(0, 0).method_32097(-8.5F, -5.204F, -8.5F, 17.0F, 7.0F, 16.0F), class_5603.method_32090(0.0F, 10.0F, 0.0F));
        modelPartData.method_32117("body", class_5606.method_32108().method_32101(0, 23).method_32097(-4.0F, -4.0F, -3.0F, 8.0F, 7.0F, 5.0F), class_5603.method_32090(0.0F, 15.0F, 0.0F));
        modelPartData.method_32117("leftFoot", class_5606.method_32108().method_32101(26, 26).method_32097(-1.0F, 0.0F, -1.5F, 3.0F, 6.0F, 3.0F), class_5603.method_32090(-2.0F, 18.0F, -0.5F));
        modelPartData.method_32117("rightFoot", class_5606.method_32108().method_32101(0, 0).method_32097(-2.0F, 0.0F, -1.5F, 3.0F, 6.0F, 3.0F), class_5603.method_32090(2.0F, 18.0F, -0.5F));
        return class_5607.method_32110(modelData, 128, 128);
    }

    @Override
    public Iterable<class_630> method_22960() {
        return ImmutableList.of(this.head, this.body, this.leftFoot, this.rightFoot);
    }

    @Override
    public void setAngles(T fungus, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.head.field_3654 = -0.1745F;
        this.rightFoot.field_3654 = class_3532.method_15362(limbAngle * 0.6662F) * 1.4F * limbDistance * 0.5F;
        this.leftFoot.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 1.4F * limbDistance * 0.5F;

        float k = class_3532.method_15374(this.field_3447 * 3.1415927F);
        if (k > 0) {
            this.head.field_3654 = -k * 1.2F;
        }

    }

}
