package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;

import net.adventurez.entity.DesertRhinoEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4595;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(EnvType.CLIENT)
public class DesertRhinoModel<T extends DesertRhinoEntity> extends class_4595<T> {
    private final class_630 main;
    private final class_630 body;
    private final class_630 tail;
    private final class_630 head;
    private final class_630 right_front_leg;
    private final class_630 right_back_leg;
    private final class_630 left_back_leg;
    private final class_630 left_front_leg;

    public DesertRhinoModel(class_630 root) {
        this.main = root.method_32086("main");
        this.left_front_leg = this.main.method_32086("left_front_leg");
        this.left_back_leg = this.main.method_32086("left_back_leg");
        this.right_back_leg = this.main.method_32086("right_back_leg");
        this.right_front_leg = this.main.method_32086("right_front_leg");
        this.body = this.main.method_32086("body");
        this.head = this.body.method_32086("head");
        this.tail = this.body.method_32086("tail");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 modelPartData1 = modelPartData.method_32117("main", class_5606.method_32108(), class_5603.method_32090(0.0F, 24.0F, 0.0F));
        class_5610 modelPartData2 = modelPartData1.method_32117("body",
                class_5606.method_32108().method_32101(0, 0).method_32097(-12.0F, -23.0F, -36.0F, 24.0F, 23.0F, 27.0F).method_32101(23, 82).method_32097(-8.0F, -28.0F, -32.0F, 4.0F, 5.0F, 4.0F).method_32101(54, 50)
                        .method_32097(5.0F, -29.0F, -25.0F, 4.0F, 6.0F, 4.0F).method_32101(86, 73).method_32097(-6.0F, -27.0F, -22.0F, 4.0F, 4.0F, 4.0F).method_32101(39, 82).method_32097(0.0F, -26.0F, -16.0F, 4.0F, 3.0F, 4.0F).method_32101(0, 50)
                        .method_32097(-10.0F, -18.0F, -9.0F, 20.0F, 18.0F, 14.0F),
                class_5603.method_32090(0.0F, -13.0F, 13.0F));
        modelPartData2.method_32117("tail", class_5606.method_32108().method_32101(85, 85).method_32097(-1.0F, 0.0F, 0.0F, 2.0F, 2.0F, 13.0F).method_32101(0, 0).method_32097(-3.0F, -2.0F, 13.0F, 6.0F, 6.0F, 6.0F),
                class_5603.method_32090(0.0F, -13.0F, 5.0F));
        modelPartData2.method_32117("head", class_5606.method_32108().method_32101(68, 50).method_32097(-5.0F, -5.0F, -13.0F, 10.0F, 10.0F, 13.0F).method_32101(16, 12).method_32097(-1.0F, -10.0F, -6.0F, 2.0F, 5.0F, 2.0F).method_32101(0, 12)
                .method_32097(-2.0F, -14.0F, -12.0F, 4.0F, 9.0F, 4.0F), class_5603.method_32090(0.0F, -8.0F, -36.0F));
        modelPartData1.method_32117("right_front_leg", class_5606.method_32108().method_32101(75, 0).method_32097(-4.0F, 0.0F, -6.0F, 9.0F, 13.0F, 12.0F), class_5603.method_32090(6.0F, -13.0F, -14.0F));
        modelPartData1.method_32117("right_back_leg", class_5606.method_32108().method_32101(32, 89).method_32097(-4.0F, 0.0F, -4.0F, 7.0F, 13.0F, 9.0F), class_5603.method_32090(6.0F, -13.0F, 12.0F));
        modelPartData1.method_32117("left_back_leg", class_5606.method_32108().method_32101(0, 82).method_32097(-3.0F, 0.0F, -4.0F, 7.0F, 13.0F, 9.0F), class_5603.method_32090(-6.0F, -13.0F, 12.0F));
        modelPartData1.method_32117("left_front_leg", class_5606.method_32108().method_32101(56, 73).method_32097(-5.0F, 0.0F, -6.0F, 9.0F, 13.0F, 12.0F), class_5603.method_32090(-6.0F, -13.0F, -14.0F));
        return class_5607.method_32110(modelData, 128, 128);
    }

    @Override
    public Iterable<class_630> method_22960() {
        return ImmutableList.of(this.main);
    }

    @Override
    public void setAngles(T fungus, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.tail.field_3654 = -1.0F;
        this.head.field_3654 = headPitch * 0.010453292F;
        this.head.field_3675 = headYaw * 0.010453292F;
        this.right_back_leg.field_3654 = class_3532.method_15362(limbAngle * 0.6662F) * 1.4F * limbDistance;
        this.left_back_leg.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 1.4F * limbDistance;
        this.right_front_leg.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 1.4F * limbDistance;
        this.left_front_leg.field_3654 = class_3532.method_15362(limbAngle * 0.6662F) * 1.4F * limbDistance;
        this.tail.field_3675 = class_3532.method_15362(limbAngle * 0.6662F) * 1.4F * limbDistance * 0.3F;

        float k = class_3532.method_15374(this.field_3447 * 3.1415927F);

        if (k > 0.0F)
            this.head.field_3654 = -k * 0.8F;

    }

}
