package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;

import net.adventurez.entity.DragonEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2398;
import net.minecraft.class_3532;
import net.minecraft.class_4595;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(EnvType.CLIENT)
public class DragonModel<T extends DragonEntity> extends class_4595<T> {
    private final class_630 body;
    private final class_630 chest;
    private final class_630 spike;
    private final class_630 wingLeft;
    private final class_630 wingTipLeft;
    private final class_630 wingRight;
    private final class_630 wingTipRight;
    private final class_630 rearLegRight;
    private final class_630 rearLegRightTip;
    private final class_630 rearLegRightTip_r1;
    private final class_630 rearFootRight;
    private final class_630 rearLegLeft;
    private final class_630 rearLegLefttip;
    private final class_630 rearLegLefttip_r1;
    private final class_630 rearFootLeft;
    private final class_630 frontLegRight;
    private final class_630 frontLegRight_r1;
    private final class_630 frontLegRighttip;
    private final class_630 frontLegRighttip_r1;
    private final class_630 frontFootRight;
    private final class_630 frontLegLeft;
    private final class_630 frontLegLeft_r1;
    private final class_630 frontLegLefttip;
    private final class_630 frontLegLefttip_r1;
    private final class_630 frontFootLeft;
    private final class_630 neck;
    private final class_630 neck2;
    private final class_630 neck3;
    private final class_630 neck4;
    private final class_630 head;
    private final class_630 otherEars;
    private final class_630 otherEars_r1;
    private final class_630 otherEars_r2;
    private final class_630 ears;
    private final class_630 jaw;
    private final class_630 tail;
    private final class_630 tail2;
    private final class_630 tail3;
    private final class_630 tail4;
    private final class_630 tail5;
    private final class_630 tail6;
    private final class_630 otherTail;
    private final class_630 otherTail_r1;
    private final class_630 otherTail_r2;
    private final class_630 otherTail_r3;
    private final class_630 otherTail_r4;
    private final class_630 extraTail;
    private final class_630 tail7;

    private float betweenFloater;
    private float startFlyingTicker;
    private boolean endFlying;
    private int endFlyingTicker;
    private boolean randomYawFire;
    private int randomYawFireTick;

    public DragonModel(class_630 root) {
        this.body = root.method_32086("body");
        this.spike = this.body.method_32086("spike");
        this.chest = this.body.method_32086("chest");
        this.wingLeft = root.method_32086("wingLeft");
        this.wingTipLeft = this.wingLeft.method_32086("wingTipLeft");
        this.wingRight = root.method_32086("wingRight");
        this.wingTipRight = this.wingRight.method_32086("wingTipRight");
        this.rearLegRight = root.method_32086("rearLegRight");
        this.rearLegRightTip = this.rearLegRight.method_32086("rearLegRightTip");
        this.rearFootRight = this.rearLegRightTip.method_32086("rearFootRight");
        this.rearLegRightTip_r1 = this.rearLegRightTip.method_32086("rearLegRightTip_r1");
        this.rearLegLeft = root.method_32086("rearLegLeft");
        this.rearLegLefttip = this.rearLegLeft.method_32086("rearLegLefttip");
        this.rearFootLeft = this.rearLegLefttip.method_32086("rearFootLeft");
        this.rearLegLefttip_r1 = this.rearLegLefttip.method_32086("rearLegLefttip_r1");
        this.frontLegRight = root.method_32086("frontLegRight");
        this.frontLegRighttip = this.frontLegRight.method_32086("frontLegRighttip");
        this.frontFootRight = this.frontLegRighttip.method_32086("frontFootRight");
        this.frontLegRighttip_r1 = this.frontLegRighttip.method_32086("frontLegRighttip_r1");
        this.frontLegRight_r1 = this.frontLegRight.method_32086("frontLegRight_r1");
        this.frontLegLeft = root.method_32086("frontLegLeft");
        this.frontLegLefttip = this.frontLegLeft.method_32086("frontLegLefttip");
        this.frontFootLeft = this.frontLegLefttip.method_32086("frontFootLeft");
        this.frontLegLefttip_r1 = this.frontLegLefttip.method_32086("frontLegLefttip_r1");
        this.frontLegLeft_r1 = this.frontLegLeft.method_32086("frontLegLeft_r1");
        this.neck = root.method_32086("neck");
        this.neck2 = this.neck.method_32086("neck2");
        this.neck3 = this.neck2.method_32086("neck3");
        this.neck4 = this.neck3.method_32086("neck4");
        this.head = this.neck4.method_32086("head");
        this.jaw = this.head.method_32086("jaw");
        this.ears = this.head.method_32086("ears");
        this.otherEars = this.head.method_32086("otherEars");
        this.otherEars_r2 = this.otherEars.method_32086("otherEars_r2");
        this.otherEars_r1 = this.otherEars.method_32086("otherEars_r1");
        this.tail = root.method_32086("tail");
        this.tail2 = this.tail.method_32086("tail2");
        this.tail3 = this.tail2.method_32086("tail3");
        this.tail4 = this.tail3.method_32086("tail4");
        this.tail5 = this.tail4.method_32086("tail5");
        this.tail6 = this.tail5.method_32086("tail6");
        this.tail7 = this.tail6.method_32086("tail7");
        this.extraTail = this.tail6.method_32086("extraTail");
        this.otherTail = this.tail6.method_32086("otherTail");
        this.otherTail_r4 = this.otherTail.method_32086("otherTail_r4");
        this.otherTail_r3 = this.otherTail.method_32086("otherTail_r3");
        this.otherTail_r2 = this.otherTail.method_32086("otherTail_r2");
        this.otherTail_r1 = this.otherTail.method_32086("otherTail_r1");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 modelPartData1 = modelPartData.method_32117("body", class_5606.method_32108().method_32101(0, 168).method_32097(-12.0F, -11.0F, -32.0F, 24.0F, 24.0F, 64.0F).method_32101(116, 256)
                .method_32097(-1.0F, -17.0F, -26.0F, 2.0F, 6.0F, 12.0F).method_32101(60, 256).method_32097(-1.0F, -17.0F, 14.0F, 2.0F, 6.0F, 12.0F), class_5603.method_32090(0.0F, -8.0F, -2.0F));
        modelPartData1.method_32117("chest", class_5606.method_32108().method_32101(252, 196).method_32097(-15.0F, -11.0F, 0.0F, 3.0F, 12.0F, 14.0F).method_32101(247, 86).method_32097(12.0F, -11.0F, 0.0F, 3.0F, 12.0F, 14.0F),
                class_5603.method_32090(0.0F, 1.0F, 0.0F));
        modelPartData1.method_32117("spike", class_5606.method_32108().method_32101(88, 256).method_32097(-1.0F, -6.0F, -5.0F, 2.0F, 6.0F, 12.0F), class_5603.method_32090(0.0F, -11.0F, -1.0F));
        class_5610 modelPartData2 = modelPartData.method_32117("wingLeft",
                class_5606.method_32108().method_32101(168, 0).method_32097(-56.0F, -4.0F, -4.0F, 56.0F, 8.0F, 8.0F).method_32101(112, 112).method_32097(-56.0F, 0.0F, 2.0F, 56.0F, 0.0F, 56.0F),
                class_5603.method_32090(-12.0F, -18.0F, -24.0F));
        modelPartData2.method_32117("wingTipLeft", class_5606.method_32108().method_32101(168, 24).method_32097(-56.0F, -3.0F, -2.0F, 56.0F, 4.0F, 4.0F).method_32101(0, 112).method_32097(-56.0F, 0.0F, 2.0F, 56.0F, 0.0F, 56.0F),
                class_5603.method_32090(-56.0F, 0.0F, 0.0F));
        class_5610 modelPartData3 = modelPartData.method_32117("wingRight",
                class_5606.method_32108().method_32101(112, 168).method_32097(0.0F, -4.0F, -4.0F, 56.0F, 8.0F, 8.0F).method_32101(0, 56).method_32097(0.0F, 0.0F, 2.0F, 56.0F, 0.0F, 56.0F),
                class_5603.method_32090(12.0F, -18.0F, -24.0F));
        modelPartData3.method_32117("wingTipRight", class_5606.method_32108().method_32101(168, 16).method_32097(0.0F, -3.0F, -2.0F, 56.0F, 4.0F, 4.0F).method_32101(0, 0).method_32097(0.0F, 0.0F, 2.0F, 56.0F, 0.0F, 56.0F),
                class_5603.method_32090(56.0F, 0.0F, 0.0F));
        class_5610 modelPartData4 = modelPartData.method_32117("rearLegRight", class_5606.method_32108().method_32101(0, 40).method_32097(-8.0F, -4.2322F, -6.0798F, 12.0F, 28.0F, 12.0F),
                class_5603.method_32090(16.0F, -5.0F, 22.0F));
        class_5610 modelPartData5 = modelPartData4.method_32117("rearLegRightTip", class_5606.method_32108(), class_5603.method_32090(-1.0F, 20.327F, 1.5816F));
        modelPartData5.method_32117("rearLegRightTip_r1", class_5606.method_32108().method_32101(176, 184).method_32097(-6.0F, -7.5F, -7.0F, 10.0F, 32.0F, 11.0F), class_5603.method_32090(0.0F, 1.1105F, -0.517F));
        modelPartData5.method_32117("rearFootRight", class_5606.method_32108().method_32101(168, 66).method_32097(-5.0F, 0.0F, -15.0F, 12.0F, 6.0F, 19.0F), class_5603.method_32090(-2.0F, 16.0502F, 14.6409F));
        class_5610 modelPartData6 = modelPartData.method_32117("rearLegLeft", class_5606.method_32108().method_32101(0, 0).method_32097(-4.0F, -5.1472F, -5.6383F, 12.0F, 28.0F, 12.0F),
                class_5603.method_32090(-16.0F, -5.0F, 21.0F));
        class_5610 modelPartData7 = modelPartData6.method_32117("rearLegLefttip", class_5606.method_32108(), class_5603.method_32090(2.0F, 19.9876F, 2.1028F));
        modelPartData7.method_32117("rearLegLefttip_r1", class_5606.method_32108().method_32101(0, 80).method_32097(-4.0F, -6.6164F, -6.486F, 10.0F, 32.0F, 11.0F), class_5603.method_32090(-1.0F, 0.6549F, -0.4294F));
        modelPartData7.method_32117("rearFootLeft", class_5606.method_32108().method_32101(0, 182).method_32097(-6.0F, 0.3F, -14.7F, 12.0F, 6.0F, 19.0F), class_5603.method_32090(0.0F, 15.6549F, 15.0706F));
        class_5610 modelPartData8 = modelPartData.method_32117("frontLegRight", class_5606.method_32108(), class_5603.method_32090(12.0F, -3.0F, -25.0F));
        modelPartData8.method_32117("frontLegRight_r1", class_5606.method_32108().method_32101(252, 32).method_32097(-4.0F, -38.2535F, -12.1057F, 8.0F, 24.0F, 8.0F), class_5603.method_32090(0.0F, 30.8475F, 16.5052F));
        class_5610 modelPartData9 = modelPartData8.method_32117("frontLegRighttip", class_5606.method_32108(), class_5603.method_32090(0.0F, 16.207F, -0.1549F));
        modelPartData9.method_32117("frontLegRighttip_r1", class_5606.method_32108().method_32101(0, 256).method_32097(-2.9F, 3.0F, -39.0F, 7.0F, 17.0F, 8.0F), class_5603.method_32090(-1.0F, -16.207F, 32.1549F));
        modelPartData9.method_32117("frontFootRight",
                class_5606.method_32108().method_32101(256, 256).method_32097(-4.8F, 0.0F, -15.1665F, 7.0F, 5.0F, 8.0F).method_32101(240, 168).method_32097(-4.8F, -1.0F, -7.1665F, 7.0F, 6.0F, 8.0F),
                class_5603.method_32090(1.0F, 10.793F, 3.1549F));
        class_5610 modelPartData10 = modelPartData.method_32117("frontLegLeft", class_5606.method_32108(), class_5603.method_32090(-12.0F, -3.0F, -25.0F));
        modelPartData10.method_32117("frontLegLeft_r1", class_5606.method_32108().method_32101(224, 238).method_32097(-4.0F, -38.2535F, -12.1057F, 8.0F, 24.0F, 8.0F), class_5603.method_32090(0.0F, 30.8475F, 16.5052F));
        class_5610 modelPartData11 = modelPartData10.method_32117("frontLegLefttip", class_5606.method_32108(), class_5603.method_32090(0.0F, 15.4023F, 0.2817F));
        modelPartData11.method_32117("frontLegLefttip_r1", class_5606.method_32108().method_32101(30, 256).method_32097(-4.9F, 4.0F, -37.0F, 7.0F, 17.0F, 8.0F), class_5603.method_32090(1.0F, -16.4023F, 30.7183F));
        modelPartData11.method_32117("frontFootLeft",
                class_5606.method_32108().method_32101(256, 243).method_32097(-3.8F, -0.3F, -14.4825F, 7.0F, 5.0F, 8.0F).method_32101(144, 256).method_32097(-3.8F, -1.3F, -6.4825F, 7.0F, 6.0F, 8.0F),
                class_5603.method_32090(0.0F, 12.1611F, 3.9136F));
        class_5610 modelPartData12 = modelPartData.method_32117("neck",
                class_5606.method_32108().method_32101(218, 184).method_32097(-7.0F, -8.0F, -10.0F, 14.0F, 16.0F, 10.0F).method_32101(168, 66).method_32097(-1.0F, -12.0F, -8.0F, 2.0F, 5.0F, 6.0F),
                class_5603.method_32090(0.0F, -10.0F, -34.0F));
        class_5610 modelPartData13 = modelPartData12.method_32117("neck2",
                class_5606.method_32108().method_32101(0, 207).method_32097(-7.0F, -7.0F, -10.0F, 14.0F, 15.0F, 10.0F).method_32101(168, 32).method_32097(-1.0F, -11.0F, -8.0F, 2.0F, 6.0F, 6.0F),
                class_5603.method_32090(0.0F, -2.0F, -10.0F));
        class_5610 modelPartData14 = modelPartData13.method_32117("neck3",
                class_5606.method_32108().method_32101(112, 207).method_32097(-7.0F, -7.0F, -10.0F, 14.0F, 14.0F, 10.0F).method_32101(39, 117).method_32097(-1.0F, -11.0F, -8.0F, 2.0F, 7.0F, 6.0F),
                class_5603.method_32090(0.0F, -1.0F, -10.0F));
        class_5610 modelPartData15 = modelPartData14.method_32117("neck4",
                class_5606.method_32108().method_32101(176, 238).method_32097(-7.0F, -6.0F, -10.0F, 14.0F, 12.0F, 10.0F).method_32101(0, 182).method_32097(-1.0F, -10.0F, -8.0F, 2.0F, 5.0F, 6.0F),
                class_5603.method_32090(0.0F, -2.0F, -10.0F));
        class_5610 modelPartData16 = modelPartData15.method_32117("head", class_5606.method_32108().method_32101(112, 184).method_32097(-8.0F, -3.0F, -30.0F, 16.0F, 7.0F, 16.0F).method_32101(168, 32)
                .method_32097(-10.0F, -10.0F, -16.0F, 20.0F, 18.0F, 16.0F).method_32101(39, 130).method_32097(2.0F, -5.0F, -28.0F, 3.0F, 4.0F, 4.0F).method_32101(0, 123).method_32097(-5.0F, -5.0F, -28.0F, 3.0F, 4.0F, 4.0F),
                class_5603.method_32090(0.0F, 0.0F, -10.0F));
        class_5610 modelPartData17 = modelPartData16.method_32117("otherEars", class_5606.method_32108(), class_5603.method_32090(0.0F, -9.0F, -7.0F));
        modelPartData17.method_32117("otherEars_r1", class_5606.method_32108().method_32101(42, 80).method_32097(-2.0F, -13.0F, -1.0F, 4.0F, 15.0F, 3.0F), class_5603.method_32090(5.0F, 0.0F, 0.0F));
        modelPartData17.method_32117("otherEars_r2", class_5606.method_32108().method_32101(42, 98).method_32097(-2.0F, -13.0F, -1.0F, 4.0F, 15.0F, 3.0F), class_5603.method_32090(-5.0F, 0.0F, 0.0F));
        modelPartData16.method_32117("ears", class_5606.method_32108().method_32101(194, 260).method_32097(8.0F, -5.0F, -4.0F, 4.0F, 7.0F, 6.0F).method_32101(174, 260).method_32097(-2.0F, -5.0F, -4.0F, 4.0F, 7.0F, 6.0F),
                class_5603.method_32090(-5.0F, -10.0F, -6.0F));
        modelPartData16.method_32117("jaw", class_5606.method_32108().method_32101(168, 91).method_32097(-6.0F, -2.0F, -14.0F, 12.0F, 4.0F, 14.0F), class_5603.method_32090(0.0F, 6.0F, -16.0F));
        class_5610 modelPartData18 = modelPartData.method_32117("tail",
                class_5606.method_32108().method_32101(0, 153).method_32097(-7.0F, -7.0F, -1.0F, 14.0F, 14.0F, 15.0F).method_32101(160, 219).method_32097(-1.0F, -12.0F, 3.0F, 2.0F, 5.0F, 8.0F),
                class_5603.method_32090(0.0F, -9.0F, 30.0F));
        class_5610 modelPartData19 = modelPartData18.method_32117("tail2",
                class_5606.method_32108().method_32101(0, 123).method_32097(-6.0F, -6.0F, -1.0F, 12.0F, 12.0F, 15.0F).method_32101(36, 40).method_32097(-1.0F, -10.0F, 3.0F, 2.0F, 4.0F, 8.0F),
                class_5603.method_32090(0.0F, 0.0F, 14.0F));
        class_5610 modelPartData20 = modelPartData19.method_32117("tail3",
                class_5606.method_32108().method_32101(203, 212).method_32097(-5.0F, -6.0F, -1.0F, 10.0F, 11.0F, 15.0F).method_32101(36, 0).method_32097(-1.0F, -10.0F, 2.0F, 2.0F, 4.0F, 8.0F),
                class_5603.method_32090(0.0F, 1.0F, 14.0F));
        class_5610 modelPartData21 = modelPartData20.method_32117("tail4",
                class_5606.method_32108().method_32101(215, 76).method_32097(-2.0F, -5.0F, -1.0F, 8.0F, 9.0F, 15.0F).method_32101(238, 214).method_32097(1.0F, -8.0F, 3.0F, 2.0F, 3.0F, 8.0F),
                class_5603.method_32090(-2.0F, 0.0F, 14.0F));
        class_5610 modelPartData22 = modelPartData21.method_32117("tail5",
                class_5606.method_32108().method_32101(225, 51).method_32097(-3.0F, -4.0F, -1.0F, 6.0F, 8.0F, 15.0F).method_32101(176, 227).method_32097(-1.0F, -7.0F, 3.0F, 2.0F, 3.0F, 8.0F),
                class_5603.method_32090(2.0F, 0.0F, 14.0F));
        class_5610 modelPartData23 = modelPartData22.method_32117("tail6",
                class_5606.method_32108().method_32101(248, 223).method_32097(0.0F, -2.0F, -1.0F, 4.0F, 5.0F, 15.0F).method_32101(160, 184).method_32097(1.0F, -5.0F, 3.0F, 2.0F, 3.0F, 8.0F),
                class_5603.method_32090(-2.0F, 0.0F, 14.0F));
        class_5610 modelPartData24 = modelPartData23.method_32117("otherTail", class_5606.method_32108(), class_5603.method_32090(0.0F, 0.0F, 8.0F));
        modelPartData24.method_32117("otherTail_r1", class_5606.method_32108().method_32101(38, 207).method_32097(-12.0F, -1.0F, -1.0F, 11.0F, 2.0F, 2.0F), class_5603.method_32090(2.0F, 0.0F, 0.0F));
        modelPartData24.method_32117("otherTail_r2", class_5606.method_32108().method_32101(206, 100).method_32097(1.0F, -1.0F, -1.0F, 12.0F, 2.0F, 2.0F), class_5603.method_32090(2.0F, 0.0F, 0.0F));
        modelPartData24.method_32117("otherTail_r3", class_5606.method_32108().method_32101(150, 207).method_32097(-12.0F, -1.0F, -1.0F, 11.0F, 2.0F, 2.0F), class_5603.method_32090(2.0F, 0.0F, -6.0F));
        modelPartData24.method_32117("otherTail_r4", class_5606.method_32108().method_32101(218, 107).method_32097(1.0F, -1.0F, -1.0F, 12.0F, 2.0F, 2.0F), class_5603.method_32090(2.0F, 0.0F, -6.0F));
        modelPartData23.method_32117("extraTail", class_5606.method_32108().method_32101(210, 32).method_32097(4.0F, 0.0F, -7.0F, 11.0F, 0.0F, 14.0F).method_32101(29, 182).method_32097(-10.0F, 0.0F, -7.0F, 10.0F, 0.0F, 14.0F),
                class_5603.method_32090(0.0F, 0.0F, 7.0F));
        modelPartData23.method_32117("tail7", class_5606.method_32108().method_32101(252, 64).method_32097(-1.0F, -1.0F, -1.0F, 2.0F, 3.0F, 15.0F).method_32101(0, 0).method_32097(0.0F, -3.0F, 5.0F, 0.0F, 2.0F, 4.0F),
                class_5603.method_32090(2.0F, 0.0F, 14.0F));
        return class_5607.method_32110(modelData, 512, 512);
    }

    @Override
    public Iterable<class_630> method_22960() {
        return ImmutableList.of(this.body, this.wingLeft, this.wingRight, this.rearLegLeft, this.rearLegRight, this.frontLegLeft, this.frontLegRight, this.neck, this.tail);
    }

    @Override
    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        // Extras
        this.renderExtras(entity);
        // General Body
        this.otherEars.field_3654 = -1.0036F;
        this.otherEars_r1.field_3654 = 0.1745F;
        this.otherEars_r1.field_3674 = 0.2182F;
        this.otherEars_r2.field_3654 = 0.1745F;
        this.otherEars_r2.field_3674 = -0.2182F;
        this.otherTail_r1.field_3675 = 0.7418F;
        this.otherTail_r2.field_3675 = -0.7418F;
        this.otherTail_r3.field_3675 = 0.6109F;
        this.otherTail_r4.field_3675 = -0.7418F;

        this.rearLegRight.field_3654 = -0.9599F;
        this.rearLegRightTip.field_3654 = 1.309F;
        this.rearLegRightTip_r1.field_3654 = 0.9599F;
        this.rearFootRight.field_3654 = -0.3491F;
        this.rearLegLeft.field_3654 = -0.9599F;
        this.rearLegLefttip.field_3654 = 1.309F;
        this.rearLegLefttip_r1.field_3654 = 0.9599F;
        this.rearFootLeft.field_3654 = -0.3491F;
        this.frontLegRight.field_3654 = 0.3491F;
        this.frontLegRight_r1.field_3654 = 0.2618F;
        this.frontLegRighttip.field_3654 = -1.5708F;
        this.frontLegRighttip_r1.field_3654 = 0.2618F;
        this.frontFootRight.field_3654 = 1.2217F;
        this.frontLegLeft.field_3654 = 0.3491F;
        this.frontLegLeft_r1.field_3654 = 0.2618F;
        this.frontLegLefttip.field_3654 = -1.5708F;
        this.frontLegLefttip_r1.field_3654 = 0.2618F;
        this.frontFootLeft.field_3654 = 1.2217F;

        // Watching Animation
        // Head glitches while riding
        this.head.field_3675 = headYaw * (0.017453292F / 6.0F); // 0.0049453292F
        this.head.field_3654 = headPitch * 0.0037453292F;
        this.neck.field_3675 = headYaw * (0.017453292F / 5.0F);
        this.neck2.field_3675 = headYaw * (0.017453292F / 5.0F);
        this.neck3.field_3675 = headYaw * (0.017453292F / 4.0F);
        this.neck4.field_3675 = headYaw * (0.017453292F / 4.0F);

        this.neck.field_3654 = headPitch * 0.0017453292F;
        this.neck2.field_3654 = headPitch * 0.0017453292F;
        this.neck3.field_3654 = headPitch * 0.0017453292F;
        this.neck4.field_3654 = headPitch * 0.0017453292F;

        // Fire Breath
        Boolean isFireBreathing = entity.method_5841().method_12789(DragonEntity.FIRE_BREATH);
        if (isFireBreathing) {
            this.jaw.field_3654 = 0.4F;
        }

        float slowlyIncreasingFloat = ((float) Math.floorMod(entity.method_37908().method_8510(), 100L) + animationProgress) / 100.0F;

        // Between Animation
        if (entity.method_5841().method_12789(DragonEntity.CLIENT_START_FLYING)) {
            if (entity.method_5841().method_12789(DragonEntity.IS_START_FLYING)) {
                startFlyingTicker = class_3532.method_15363(startFlyingTicker + 0.05164F, 0.0F, 1.4981F);
            } else {
                startFlyingTicker = class_3532.method_15363(startFlyingTicker - 0.05164F, 0.0F, 1.4981F);
            }
            this.wingRight.field_3674 = 0.6981F - startFlyingTicker;
            this.wingLeft.field_3674 = -0.6981F + startFlyingTicker;
            this.wingTipLeft.field_3674 = 2.618F - (startFlyingTicker * 1.32033909618F);
            this.wingTipRight.field_3674 = -2.618F + (startFlyingTicker * 1.32033909618F);
            betweenFloater = 12.566370614F * slowlyIncreasingFloat;
            if (entity.method_24828()) {
                float walkFloat = 32.0F;
                this.rearLegRight.field_3654 = -0.9599F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F;
                this.rearLegLeft.field_3654 = -0.9599F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F;

                this.rearFootRight.field_3654 = -0.3491F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.9F;
                this.rearFootLeft.field_3654 = -0.3491F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.9F;

                this.frontLegRight.field_3654 = 0.3491F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F;
                this.frontLegLeft.field_3654 = 0.3491F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F;

                this.frontLegRighttip.field_3654 = -1.5708F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.8F;
                this.frontLegLefttip.field_3654 = -1.5708F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.8F;

                this.frontFootRight.field_3654 = 1.2217F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.2F;
                this.frontFootLeft.field_3654 = 1.2217F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.2F;
            }
        } else

        // While Flying Animation
        if (entity.method_5841().method_12789(DragonEntity.IS_FLYING)) {
            startFlyingTicker = 0.0F;
            // mediumSpeedSin goes from -1 to 1
            float mediumSpeedSin = class_3532.method_15362(12.566370614F * slowlyIncreasingFloat - (betweenFloater + 3.1415926535897F));
            // Wings
            this.wingRight.field_3674 = mediumSpeedSin * 0.8F; // double pi inside cos does it make faster
            this.wingTipRight.field_3674 = this.wingRight.field_3674 * 0.8F;
            this.wingLeft.field_3674 = -this.wingRight.field_3674;
            this.wingTipLeft.field_3674 = -this.wingTipRight.field_3674;

            // Body Floating
            float bodyFloating = -mediumSpeedSin - 4.0F;
            this.body.field_3656 = bodyFloating;
            this.wingLeft.field_3656 = bodyFloating - 10.0F;
            this.wingRight.field_3656 = bodyFloating - 10.0F; // Dont know why it has to be -10F
            this.rearLegLeft.field_3656 = bodyFloating;
            this.rearLegRight.field_3656 = bodyFloating;
            this.frontLegLeft.field_3656 = bodyFloating;
            this.frontLegRight.field_3656 = bodyFloating;
            this.neck.field_3656 = bodyFloating;
            this.tail.field_3656 = bodyFloating;
            // head floating
            float headFloat = class_3532.method_15362(bodyFloating / 2.0F);
            this.neck2.field_3656 = -headFloat;
            this.neck3.field_3656 = -headFloat;
            this.neck4.field_3656 = -headFloat * 0.9F;
            this.head.field_3656 = -headFloat * 0.8F;
            // yaw
            if (!isFireBreathing) {
                this.jaw.field_3654 = -headFloat * 0.3F;
            }
            // tail
            this.tail2.field_3656 = class_3532.method_15362(6.2831855F * slowlyIncreasingFloat - (6.2831855F / 3F));
            this.tail3.field_3656 = class_3532.method_15362(6.2831855F * slowlyIncreasingFloat - (6.2831855F / 3F));
            this.tail4.field_3656 = class_3532.method_15362(6.2831855F * slowlyIncreasingFloat - (6.2831855F / 4F));
            this.tail5.field_3656 = class_3532.method_15362(6.2831855F * slowlyIncreasingFloat - (6.2831855F / 4F));
            this.tail5.field_3656 = class_3532.method_15362(6.2831855F * slowlyIncreasingFloat - (6.2831855F / 5F));
            this.tail6.field_3656 = class_3532.method_15362(6.2831855F * slowlyIncreasingFloat - (6.2831855F / 5F));
            this.tail7.field_3656 = class_3532.method_15362(6.2831855F * slowlyIncreasingFloat - (6.2831855F / 6F)) * 0.5F;
            if (entity.method_24828()) {
                float walkFloat = 32.0F;
                this.rearLegRight.field_3654 = -0.9599F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F;
                this.rearLegLeft.field_3654 = -0.9599F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F;

                this.rearFootRight.field_3654 = -0.3491F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.9F;
                this.rearFootLeft.field_3654 = -0.3491F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.9F;

                this.frontLegRight.field_3654 = 0.3491F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F;
                this.frontLegLeft.field_3654 = 0.3491F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F;

                this.frontLegRighttip.field_3654 = -1.5708F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.8F;
                this.frontLegLefttip.field_3654 = -1.5708F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.8F;

                this.frontFootRight.field_3654 = 1.2217F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.2F;
                this.frontFootLeft.field_3654 = 1.2217F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.2F;
            } else {
                // Legs rear
                this.rearLegRight.field_3654 = 0.5672F;
                this.rearLegRightTip.field_3654 = -0.2182F;
                this.rearLegRightTip_r1.field_3654 = 0.9599F;
                this.rearFootRight.field_3654 = 1.4835F;

                this.rearLegLeft.field_3654 = 0.5672F;
                this.rearLegLefttip.field_3654 = -0.2182F;
                this.rearLegLefttip_r1.field_3654 = 0.9599F;
                this.rearFootLeft.field_3654 = 1.4835F;

                // Legs front
                this.frontLegRight.field_3654 = 0.7418F;
                this.frontLegRight_r1.field_3654 = 0.2618F;
                this.frontLegRighttip.field_3654 = -1.0472F;
                this.frontLegRighttip_r1.field_3654 = 0.2618F;
                this.frontFootRight.field_3654 = 1.4835F;

                this.frontLegLeft.field_3654 = 0.7418F;
                this.frontLegLeft_r1.field_3654 = 0.2618F;
                this.frontLegLefttip.field_3654 = -1.0472F;
                this.frontLegLefttip_r1.field_3654 = 0.2618F;
                this.frontFootLeft.field_3654 = 1.4835F;
            }
        } else

        // End of Flying Animation
        if (entity.method_5841().method_12789(DragonEntity.CLIENT_END_FLYING)) {
            float mediumSpeedSin = class_3532.method_15362(12.566370614F * slowlyIncreasingFloat - (betweenFloater + 3.1415926535897F)); // 1to-1
            if (mediumSpeedSin < 0.04F && mediumSpeedSin > -0.04F) {
                endFlying = true;
            }
            if (endFlying == false) {
                this.wingRight.field_3674 = mediumSpeedSin * 0.8F;
                this.wingTipRight.field_3674 = this.wingRight.field_3674 * 0.8F;
                this.wingLeft.field_3674 = -this.wingRight.field_3674;
                this.wingTipLeft.field_3674 = -this.wingTipRight.field_3674;
            } else {
                endFlyingTicker++;
                // Wings
                if (endFlyingTicker <= 10) {
                    startFlyingTicker = class_3532.method_15363(startFlyingTicker + 0.06205F, 0.0F, 0.6981F);
                    // a*b=c
                    this.wingRight.field_3674 = startFlyingTicker;
                    this.wingLeft.field_3674 = -startFlyingTicker;
                    this.wingTipLeft.field_3674 = (startFlyingTicker * 3.75017905F);
                    this.wingTipRight.field_3674 = -(startFlyingTicker * 3.75017905F);

                } else {
                    entity.method_5841().method_12778(DragonEntity.CLIENT_END_FLYING, false);
                    endFlyingTicker = 0;
                    startFlyingTicker = 0;
                    endFlying = false;
                }

            }

            if (entity.method_24828()) {
                float walkFloat = 32.0F;
                this.rearLegRight.field_3654 = -0.9599F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F;
                this.rearLegLeft.field_3654 = -0.9599F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F;

                this.rearFootRight.field_3654 = -0.3491F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.9F;
                this.rearFootLeft.field_3654 = -0.3491F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.9F;

                this.frontLegRight.field_3654 = 0.3491F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F;
                this.frontLegLeft.field_3654 = 0.3491F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F;

                this.frontLegRighttip.field_3654 = -1.5708F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.8F;
                this.frontLegLefttip.field_3654 = -1.5708F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.8F;

                this.frontFootRight.field_3654 = 1.2217F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.2F;
                this.frontFootLeft.field_3654 = 1.2217F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.2F;
            }

        } else

        // Walk Animation
        if (!entity.isInSittingPose() || entity.method_5782()) {
            float walkFloat = 32.0F;
            this.rearLegRight.field_3654 = -0.9599F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F;
            this.rearLegLeft.field_3654 = -0.9599F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F;

            this.rearFootRight.field_3654 = -0.3491F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.9F;
            this.rearFootLeft.field_3654 = -0.3491F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.9F;

            this.frontLegRight.field_3654 = 0.3491F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F;
            this.frontLegLeft.field_3654 = 0.3491F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F;

            this.frontLegRighttip.field_3654 = -1.5708F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.8F;
            this.frontLegLefttip.field_3654 = -1.5708F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.8F;

            this.frontFootRight.field_3654 = 1.2217F + 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.2F;
            this.frontFootLeft.field_3654 = 1.2217F - 0.3F * class_3532.method_24504(limbAngle, walkFloat) * limbDistance * 1.3F * 0.2F;

            // tail
            this.tail.field_3654 = -0.1309F;
            this.tail2.field_3654 = -0.1309F;
            this.tail3.field_3654 = -0.1309F;
            this.tail4.field_3654 = -0.1745F;
            this.tail5.field_3654 = 0.1309F;
            this.tail6.field_3654 = 0.1745F;
            this.tail7.field_3654 = 0.2618F;

            this.tail.field_3675 = 0.0436F * class_3532.method_24504(limbAngle, 60.0F) * limbDistance;
            this.tail2.field_3675 = 0.0436F * class_3532.method_24504(limbAngle, 60.0F) * limbDistance;
            this.tail3.field_3675 = 0.0436F * class_3532.method_24504(limbAngle, 60.0F) * limbDistance;
            this.tail4.field_3675 = 0.0436F * class_3532.method_24504(limbAngle, 60.0F) * limbDistance;
            this.tail5.field_3675 = 0.0436F * class_3532.method_24504(limbAngle, 70.0F) * limbDistance;
            this.tail6.field_3675 = 0.0436F * class_3532.method_24504(limbAngle, 70.0F) * limbDistance;
            this.tail7.field_3675 = 0.0436F * class_3532.method_24504(limbAngle, 80.0F) * limbDistance;

            this.tail2.field_3656 = 0.0F;
            this.tail3.field_3656 = 0.0F;
            this.tail4.field_3656 = 0.0F;
            this.tail5.field_3656 = 0.0F;
            this.tail5.field_3656 = 0.0F;
            this.tail6.field_3656 = 0.0F;
            this.tail7.field_3656 = 0.0F;

            // wings
            this.wingLeft.field_3674 = -0.6981F + 0.0236F * class_3532.method_24504(limbAngle, 40.0F) * limbDistance;
            this.wingTipLeft.field_3674 = 2.618F;
            this.wingRight.field_3674 = 0.6981F - 0.0236F * class_3532.method_24504(limbAngle, 40.0F) * limbDistance;
            this.wingTipRight.field_3674 = -2.618F;

            // Jaw
            if (!isFireBreathing) {
                this.jaw.field_3654 = 0.0F;
            }
        } else// if (entity.isInSittingPose())

        // Sitting Position Animation
        {
            this.tail.field_3654 = -0.1309F;
            this.tail2.field_3654 = -0.1309F;
            this.tail3.field_3654 = -0.1309F;
            this.tail4.field_3654 = -0.1745F;
            this.tail5.field_3654 = 0.1309F;
            this.tail6.field_3654 = 0.1745F;
            this.tail7.field_3654 = 0.1745F;

            this.tail.field_3675 = -0.0436F;
            this.tail2.field_3675 = -0.0436F;
            this.tail3.field_3675 = -0.0873F;
            this.tail4.field_3675 = -0.0436F;
            this.tail5.field_3675 = -0.2182F;
            this.tail6.field_3675 = -0.2182F;
            this.tail6.field_3674 = -0.0436F;
            this.tail7.field_3674 = -0.1309F;

            // Wings
            this.wingLeft.field_3674 = -0.6981F;
            this.wingTipLeft.field_3674 = 2.618F;
            this.wingRight.field_3674 = 0.6981F;
            this.wingTipRight.field_3674 = -2.618F;

            // Random Yaw Fire
            Float yawPitch = Math.abs(class_3532.method_15362(6.2831853071F * slowlyIncreasingFloat) * 0.3F);
            if (entity.getSize() == 3 && !this.randomYawFire && yawPitch <= 0.01F && entity.method_37908().method_8409().method_43048(16) == 0 && !isFireBreathing) {
                this.randomYawFire = true;
            }
            if (this.randomYawFire) {
                this.randomYawFireTick++;
                Float yawler = this.head.field_3675 + this.neck.field_3675 + this.neck2.field_3675 + this.neck3.field_3675 + this.neck4.field_3675;
                Float pitcher = this.head.field_3654 + this.neck.field_3654 + this.neck2.field_3654 + this.neck3.field_3654 + this.neck4.field_3654;
                yawler = (yawler / (float) (Math.PI)) * 1.5F;
                pitcher = pitcher * 3F;
                entity.method_37908().method_8466(class_2398.field_11240, true, entity.method_23317() + Math.sin((entity.field_6283 / 360F) * 2F * Math.PI + (Math.PI) + yawler) * 6D, entity.method_23318() - pitcher + 1.95D,
                        entity.method_23321() - Math.cos((entity.field_6283 / 360F) * 2F * Math.PI + (Math.PI) + yawler) * 6D, 0.0D, 0.0D, 0.0D);

                this.jaw.field_3654 = yawPitch;
                if ((this.randomYawFireTick > 10 && yawPitch <= 0.01F) || isFireBreathing) {
                    this.randomYawFireTick = 0;
                    this.randomYawFire = false;
                }
            }

        }

    }

    private void renderExtras(class_1297 entity) {
        if (entity.method_5841().method_12789(DragonEntity.HAS_SADDLE)) {
            this.spike.field_3665 = false;
        } else {
            this.spike.field_3665 = true;
        }
        if (entity.method_5841().method_12789(DragonEntity.HAS_CHEST)) {
            this.chest.field_3665 = true;
        } else {
            this.chest.field_3665 = false;
        }
        if (entity.method_5841().method_12789(DragonEntity.OTHER_EARS)) {
            this.otherEars.field_3665 = true;
            this.ears.field_3665 = false;
        } else {
            this.otherEars.field_3665 = false;
            this.ears.field_3665 = true;
        }
        if (entity.method_5841().method_12789(DragonEntity.OTHER_TAIL)) {
            this.otherTail.field_3665 = true;
            this.extraTail.field_3665 = false;
        } else {
            this.otherTail.field_3665 = false;
            this.extraTail.field_3665 = true;
        }

    }

}
