package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;

import net.adventurez.entity.EnderWhaleEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4595;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(EnvType.CLIENT)
public class EnderWhaleModel<T extends EnderWhaleEntity> extends class_4595<T> {
    private final class_630 body1;
    private final class_630 body2;
    private final class_630 frontLflipper1a;
    private final class_630 frontRflipper1a;
    private final class_630 body3;
    private final class_630 backLflipper1a;
    private final class_630 backRflipper1a;
    private final class_630 tailflipperM;
    private final class_630 tailflipperL;
    private final class_630 tailflipperR;
    private final class_630 backLflipper2b;
    private final class_630 backRflipper2b;

    private float oldAnimationProgress;
    private float slowlyIncreasingFloat;

    public EnderWhaleModel(class_630 root) {
        this.body1 = root.method_32086("body1");
        this.frontRflipper1a = this.body1.method_32086("frontRflipper1a");
        this.body2 = this.body1.method_32086("body2");
        this.backRflipper1a = this.body2.method_32086("backRflipper1a");
        this.frontLflipper1a = this.body1.method_32086("frontLflipper1a");
        this.backLflipper1a = this.body2.method_32086("backLflipper1a");
        this.body3 = this.body2.method_32086("body3");
        this.tailflipperM = this.body3.method_32086("tailflipperM");
        this.backLflipper2b = this.backLflipper1a.method_32086("backLflipper2b");
        this.backRflipper2b = this.backRflipper1a.method_32086("backRflipper2b");
        this.tailflipperR = this.tailflipperM.method_32086("tailflipperR");
        this.tailflipperL = this.tailflipperM.method_32086("tailflipperL");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 modelPartData4 = modelPartData.method_32117("body1", class_5606.method_32108().method_32101(0, 165).method_32097(-19.0F, -16.0F, -26.0F, 38.0F, 36.0F, 52.0F),
                class_5603.method_32090(0.0F, 3.0F, 0.0F));
        class_5610 modelPartData6 = modelPartData4.method_32117("frontLflipper1a", class_5606.method_32108().method_32101(0, 100).method_32097(0.0F, -2.5F, -9.0F, 25.0F, 5.0F, 20.0F),
                class_5603.method_32090(16.0F, 13.0F, 9.0F));
        class_5610 modelPartData5 = modelPartData4.method_32117("body2", class_5606.method_32108().method_32101(200, 185).method_32097(-14.5F, -14.5F, 0.0F, 29.0F, 29.0F, 37.0F),
                class_5603.method_32090(0.0F, 2.0F, 15.5F));
        class_5610 modelPartData8 = modelPartData5.method_32117("body3", class_5606.method_32108().method_32101(360, 195).method_32097(-11.5F, -11.5F, 0.0F, 23.0F, 23.0F, 33.0F),
                class_5603.method_32090(0.0F, 0.0F, 31.0F));
        class_5610 modelPartData1 = modelPartData5.method_32117("backLflipper1a", class_5606.method_32108().method_32101(0, 50).method_32097(0.0F, -2.5F, -5.0F, 18.0F, 5.0F, 13.0F),
                class_5603.method_32090(13.0F, 9.0F, 24.0F));
        modelPartData6.method_32117("frontLflipper2b", class_5606.method_32108().method_32101(80, 110).method_32100(0.0F, 0.0F, -9.0F, 26.0F, 0.0F, 20.0F, true), class_5603.method_32090(12.0F, 0.0F, 0.0F));
        class_5610 modelPartData2 = modelPartData5.method_32117("backRflipper1a", class_5606.method_32108().method_32101(0, 50).method_32100(-18.0F, -2.5F, -5.0F, 18.0F, 5.0F, 13.0F, true),
                class_5603.method_32090(-13.0F, 9.0F, 24.0F));
        modelPartData2.method_32117("backRflipper2b", class_5606.method_32108().method_32101(70, 60).method_32097(-20.0F, 0.0F, -6.0F, 21.0F, 0.0F, 13.0F), class_5603.method_32090(-8.0F, 0.0F, 1.0F));
        modelPartData4.method_32117("eyeglowlayer", class_5606.method_32108().method_32101(190, 80).method_32098(-19.0F, -16.0F, -16.5F, 38.0F, 36.0F, 33.0F, new class_5605(0.05F)),
                class_5603.method_32090(0.0F, 0.0F, -9.0F));
        class_5610 modelPartData7 = modelPartData4.method_32117("frontRflipper1a", class_5606.method_32108().method_32101(0, 100).method_32100(-25.0F, -2.5F, -9.0F, 25.0F, 5.0F, 20.0F, true),
                class_5603.method_32090(-16.0F, 13.0F, 9.0F));
        modelPartData7.method_32117("frontRflipper2b", class_5606.method_32108().method_32101(80, 110).method_32097(-26.0F, 0.0F, -9.0F, 26.0F, 0.0F, 20.0F), class_5603.method_32090(-12.0F, 0.0F, 0.0F));
        class_5610 modelPartData3 = modelPartData8.method_32117("tailflipperM", class_5606.method_32108().method_32101(1, 0).method_32097(-14.0F, -3.0F, 0.0F, 28.0F, 6.0F, 16.0F),
                class_5603.method_32090(0.0F, 0.0F, 29.0F));
        modelPartData3.method_32117("tailflipperdetail", class_5606.method_32108().method_32101(160, 0).method_32097(-46.5F, 0.0F, 0.0F, 93.0F, 0.0F, 57.0F), class_5603.method_32090(0.0F, 0.0F, 5.0F));
        modelPartData3.method_32117("tailflipperL", class_5606.method_32108().method_32101(110, 0).method_32100(0.0F, -2.0F, -5.0F, 28.0F, 4.0F, 16.0F, true), class_5603.method_32090(10.0F, 0.0F, 9.0F));
        modelPartData3.method_32117("tailflipperR", class_5606.method_32108().method_32101(110, 0).method_32097(-28.0F, -2.0F, -5.0F, 28.0F, 4.0F, 16.0F), class_5603.method_32090(-10.0F, 0.0F, 9.0F));
        modelPartData1.method_32117("backLflipper2b", class_5606.method_32108().method_32101(70, 60).method_32100(0.0F, 0.0F, -6.0F, 21.0F, 0.0F, 13.0F, true), class_5603.method_32090(8.0F, 0.0F, 1.0F));
        return class_5607.method_32110(modelData, 512, 256);

    }

    @Override
    public Iterable<class_630> method_22960() {
        return ImmutableList.of(this.body1);
    }

    @Override
    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.backLflipper2b.field_3675 = -0.41887902047863906F;
        this.backRflipper2b.field_3675 = 0.41887902047863906F;
        this.frontLflipper1a.field_3675 = -0.19198621771937624F;
        this.body3.field_3654 = 0.017453292519943295F;
        this.body3.field_3675 = 0.017453292519943295F;
        this.body1.field_3654 = 0.017453292519943295F;
        this.backLflipper1a.field_3675 = -0.19198621771937624F;
        this.backLflipper1a.field_3674 = 0.296705972839036F;
        this.body2.field_3654 = 0.017453292519943295F;
        this.body2.field_3675 = 0.017453292519943295F;
        this.tailflipperL.field_3675 = -0.4363323129985824F;
        this.tailflipperR.field_3675 = 0.4363323129985824F;
        this.backRflipper1a.field_3675 = 0.19198621771937624F;
        this.backRflipper1a.field_3674 = -0.296705972839036F;
        this.frontRflipper1a.field_3675 = 0.19198621771937624F;
        this.body1.field_3675 = headYaw * 0.0017453292F;

        slowlyIncreasingFloat += (animationProgress - oldAnimationProgress) * 0.005F;

        float slowSpeedSin = class_3532.method_15362(12.566370614F * slowlyIncreasingFloat) * 0.34F;
        frontRflipper1a.field_3674 = 0.22689280275926282F * 0.3F + slowSpeedSin;
        frontLflipper1a.field_3674 = -0.22689280275926282F * 0.3F + -slowSpeedSin;

        backRflipper1a.field_3674 = 0.41887902047863906F * 0.3F + -slowSpeedSin * 0.7F;
        backLflipper1a.field_3674 = -0.41887902047863906F * 0.3F + slowSpeedSin * 0.7F;

        body2.field_3656 = 2.0F + slowSpeedSin * 3.0F;
        body3.field_3656 = slowSpeedSin * 3.6F;
        body2.field_3654 = slowSpeedSin * -0.08F;
        body3.field_3654 = slowSpeedSin * -0.096F;
        tailflipperM.field_3656 = slowSpeedSin * 4.2F;
        tailflipperM.field_3654 = -slowSpeedSin * 0.45F;

        oldAnimationProgress = animationProgress;
    }
}