package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;

import net.adventurez.entity.EnderwarthogEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4595;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(EnvType.CLIENT)
public class EnderwarthogModel<T extends EnderwarthogEntity> extends class_4595<T> {
    private final class_630 mainbody;
    private final class_630 neck;
    private final class_630 head;
    private final class_630 jaw;
    private final class_630 ribbon1L;
    private final class_630 ribbon2L;
    private final class_630 ribbon1R;
    private final class_630 ribbon2R;
    private final class_630 horn1L;
    private final class_630 horn2L;
    private final class_630 horn3L;
    private final class_630 horn1R;
    private final class_630 horn2R;
    private final class_630 horn3R;
    private final class_630 legfL;
    private final class_630 legbL;
    private final class_630 legfR;
    private final class_630 legbR;

    public EnderwarthogModel(class_630 root) {
        this.mainbody = root.method_32086("mainbody");
        this.legbR = this.mainbody.method_32086("legbR");
        this.legfR = this.mainbody.method_32086("legfR");
        this.legbL = this.mainbody.method_32086("legbL");
        this.legfL = this.mainbody.method_32086("legfL");
        this.neck = this.mainbody.method_32086("neck");
        this.horn1R = this.neck.method_32086("horn1R");
        this.horn2R = this.horn1R.method_32086("horn2R");
        this.horn3R = this.horn2R.method_32086("horn3R");
        this.horn1L = this.neck.method_32086("horn1L");
        this.horn2L = this.horn1L.method_32086("horn2L");
        this.horn3L = this.horn2L.method_32086("horn3L");
        this.head = this.neck.method_32086("head");
        this.ribbon1R = this.head.method_32086("ribbon1R");
        this.ribbon2R = this.ribbon1R.method_32086("ribbon2R");
        this.ribbon1L = this.head.method_32086("ribbon1L");
        this.ribbon2L = this.ribbon1L.method_32086("ribbon2L");
        this.jaw = this.head.method_32086("jaw");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 modelPartData1 = modelPartData.method_32117("mainbody", class_5606.method_32108().method_32101(0, 190).method_32097(-10.5F, -8.5F, -16.5F, 21.0F, 19.0F, 36.0F),
                class_5603.method_32090(0.0F, 3.0F, 0.0F));
        class_5610 modelPartData2 = modelPartData1.method_32117("neck", class_5606.method_32108().method_32101(0, 10).method_32097(-8.5F, -7.5F, -15.0F, 17.0F, 18.0F, 15.0F),
                class_5603.method_32090(0.0F, -3.5F, -10.0F));
        class_5610 modelPartData3 = modelPartData2.method_32117("head", class_5606.method_32108().method_32101(180, 20).method_32097(-6.5F, -3.6F, -13.0F, 13.0F, 7.0F, 17.0F),
                class_5603.method_32090(0.0F, -2.0F, -17.0F));
        class_5610 modelPartData4 = modelPartData3.method_32117("jaw", class_5606.method_32108().method_32101(180, 60).method_32097(-7.0F, -2.5F, -16.0F, 14.0F, 5.0F, 18.0F), class_5603.method_32090(0.0F, 6.0F, 2.0F));
        modelPartData4.method_32117("jawguard", class_5606.method_32108().method_32101(180, 100).method_32097(-7.0F, -3.0F, -8.0F, 14.0F, 3.0F, 18.0F), class_5603.method_32090(0.0F, -2.0F, -8.0F));
        class_5610 modelPartData5 = modelPartData3.method_32117("ribbon1L", class_5606.method_32108().method_32101(140, 0).method_32097(-1.5F, 0.0F, 0.0F, 3.0F, 0.0F, 9.0F), class_5603.method_32090(-4.0F, -3.5F, 0.0F));
        modelPartData5.method_32117("ribbon2L", class_5606.method_32108().method_32101(140, 20).method_32097(-1.5F, 0.0F, 0.0F, 3.0F, 0.0F, 9.0F), class_5603.method_32090(0.0F, 0.0F, 9.0F));
        class_5610 modelPartData6 = modelPartData3.method_32117("ribbon1R", class_5606.method_32108().method_32101(140, 0).method_32100(-1.5F, 0.0F, 0.0F, 3.0F, 0.0F, 9.0F, true),
                class_5603.method_32090(4.0F, -3.5F, 0.0F));
        modelPartData6.method_32117("ribbon2R", class_5606.method_32108().method_32101(140, 20).method_32100(-1.5F, 0.0F, 0.0F, 3.0F, 0.0F, 9.0F, true), class_5603.method_32090(0.0F, 0.0F, 9.0F));
        class_5610 modelPartData7 = modelPartData2.method_32117("horn1L", class_5606.method_32108().method_32101(80, 0).method_32100(-10.0F, -3.5F, -5.0F, 10.0F, 7.0F, 7.0F, true),
                class_5603.method_32090(-6.0F, -2.0F, -9.1F));
        class_5610 modelPartData8 = modelPartData7.method_32117("horn2L", class_5606.method_32108().method_32101(80, 20).method_32100(-10.0F, -2.5F, -2.5F, 10.0F, 5.0F, 5.0F, true),
                class_5603.method_32090(-8.0F, -1.0F, -1.0F));
        modelPartData8.method_32117("horn3L", class_5606.method_32108().method_32101(80, 40).method_32100(-8.0F, -2.5F, -2.5F, 9.0F, 4.0F, 4.0F, true), class_5603.method_32090(-9.0F, 0.4F, 0.0F));
        class_5610 modelPartData9 = modelPartData2.method_32117("horn1R", class_5606.method_32108().method_32101(80, 0).method_32097(0.0F, -3.5F, -5.0F, 10.0F, 7.0F, 7.0F), class_5603.method_32090(6.0F, 0.0F, -8.9F));
        class_5610 modelPartData10 = modelPartData9.method_32117("horn2R", class_5606.method_32108().method_32101(80, 20).method_32097(0.0F, -2.5F, -2.5F, 10.0F, 5.0F, 5.0F),
                class_5603.method_32090(8.0F, -1.0F, -1.0F));
        modelPartData10.method_32117("horn3R", class_5606.method_32108().method_32101(80, 40).method_32097(-1.0F, -2.5F, -2.5F, 9.0F, 4.0F, 4.0F), class_5603.method_32090(9.0F, 0.4F, 0.0F));
        class_5610 modelPartData11 = modelPartData1.method_32117("legfL", class_5606.method_32108().method_32101(0, 120).method_32097(-4.0F, 0.0F, -4.5F, 8.0F, 24.0F, 9.0F),
                class_5603.method_32090(-10.0F, -3.0F, -11.0F));
        modelPartData11.method_32117("thighfLL", class_5606.method_32108().method_32101(40, 130).method_32098(-7.0F, 0.0F, -4.5F, 8.0F, 8.0F, 9.0F, new class_5605(0.3F)), class_5603.method_32090(3.0F, 0.0F, 0.0F));
        class_5610 modelPartData12 = modelPartData1.method_32117("legbL", class_5606.method_32108().method_32101(0, 70).method_32097(-4.0F, 0.0F, -4.5F, 8.0F, 24.0F, 9.0F),
                class_5603.method_32090(-10.0F, -3.0F, 13.0F));
        modelPartData12.method_32117("thighbL", class_5606.method_32108().method_32101(40, 90).method_32098(-8.0F, 0.0F, -4.5F, 8.0F, 8.0F, 9.0F, new class_5605(0.3F)), class_5603.method_32090(4.0F, 0.0F, 0.0F));
        class_5610 modelPartData13 = modelPartData1.method_32117("legfR", class_5606.method_32108().method_32101(0, 120).method_32097(-4.0F, 0.0F, -4.5F, 8.0F, 24.0F, 9.0F),
                class_5603.method_32090(10.0F, -3.0F, -11.0F));
        modelPartData13.method_32117("thighfLR", class_5606.method_32108().method_32101(40, 130).method_32098(0.0F, 0.0F, -4.5F, 8.0F, 8.0F, 9.0F, new class_5605(0.3F)), class_5603.method_32090(-4.0F, 0.0F, 0.0F));
        class_5610 modelPartData14 = modelPartData1.method_32117("legbR", class_5606.method_32108().method_32101(0, 70).method_32097(-4.0F, 0.0F, -4.5F, 8.0F, 24.0F, 9.0F), class_5603.method_32090(10.0F, -3.0F, 13.0F));
        modelPartData14.method_32117("thighbR", class_5606.method_32108().method_32101(40, 90).method_32098(0.0F, 0.0F, -4.5F, 8.0F, 8.0F, 9.0F, new class_5605(0.3F)), class_5603.method_32090(-4.0F, 0.0F, 0.0F));
        return class_5607.method_32110(modelData, 256, 256);
    }

    @Override
    public Iterable<class_630> method_22960() {
        return ImmutableList.of(this.mainbody);
    }

    @Override
    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {

        this.head.field_3654 = 0.2602F + headPitch * 0.010453292F;
        this.neck.field_3675 = headYaw * 0.004453292F;
        this.head.field_3675 = headYaw * 0.005453292F;
        this.jaw.field_3654 = 0.0524F;
        this.ribbon1L.field_3654 = 0.7854F;
        this.ribbon1L.field_3675 = -0.4712F;
        this.ribbon2L.field_3654 = -0.3491F;
        this.ribbon2L.field_3675 = 0.2443F;
        this.ribbon1R.field_3654 = 0.7854F;
        this.ribbon1R.field_3675 = 0.4712F;
        this.ribbon2R.field_3654 = -0.3491F;
        this.ribbon2R.field_3675 = -0.2443F;
        this.horn1L.field_3654 = 0.1022F;
        this.horn1L.field_3675 = -0.2274F;
        this.horn1L.field_3674 = -0.8633F;
        this.horn2L.field_3654 = -0.0524F;
        this.horn2L.field_3675 = -0.5411F;
        this.horn2L.field_3674 = -0.3142F;
        this.horn3L.field_3654 = 0.2269F;
        this.horn3L.field_3675 = -0.576F;
        this.horn3L.field_3674 = -0.2793F;
        this.horn1R.field_3654 = -0.1047F;
        this.horn1R.field_3675 = 0.3142F;
        this.horn1R.field_3674 = 0.8727F;
        this.horn2R.field_3654 = 0.0524F;
        this.horn2R.field_3675 = 0.5411F;
        this.horn2R.field_3674 = 0.3142F;
        this.horn3R.field_3654 = 0.2269F;
        this.horn3R.field_3675 = 0.576F;
        this.horn3R.field_3674 = 0.2793F;

        this.legbR.field_3654 = class_3532.method_15362(limbAngle * 0.6662F) * 0.8F * limbDistance;
        this.legbL.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 0.8F * limbDistance;
        this.legfR.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 0.8F * limbDistance;
        this.legfL.field_3654 = class_3532.method_15362(limbAngle * 0.6662F) * 0.8F * limbDistance;

        float k = class_3532.method_15374(this.field_3447 * 3.1415927F);

        if (k > 0.0F) {
            if (entity.method_5841().method_12789(EnderwarthogEntity.BITE_ATTACK)) {
                this.neck.field_3654 = -k * 0.05F;
                this.head.field_3654 = -k * 0.01F;
                this.jaw.field_3654 = 0.0524F + k * 0.45F;
            } else {
                this.neck.field_3654 = -k * 0.4F;
                this.head.field_3654 = -k * 0.2F;
            }
        } else {
            this.neck.field_3654 = 0.0F;
        }
    }

}
