package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;

import net.adventurez.entity.IguanaEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4592;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(EnvType.CLIENT)
public class IguanaModel<T extends IguanaEntity> extends class_4592<T> {
    private final class_630 body;
    private final class_630 tail;
    private final class_630 cube_r1;
    private final class_630 head;
    private final class_630 jaw;
    private final class_630 left_middle;
    private final class_630 left_front;
    private final class_630 left_back;
    private final class_630 right_middle;
    private final class_630 right_front;
    private final class_630 right_back;

    public IguanaModel(class_630 root) {
        this.body = root.method_32086("body");
        this.tail = this.body.method_32086("tail");
        this.cube_r1 = this.tail.method_32086("cube_r1");
        this.head = root.method_32086("head");
        this.jaw = this.head.method_32086("jaw");
        this.left_middle = root.method_32086("left_middle");
        this.left_front = root.method_32086("left_front");
        this.left_back = root.method_32086("left_back");
        this.right_middle = root.method_32086("right_middle");
        this.right_front = root.method_32086("right_front");
        this.right_back = root.method_32086("right_back");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();

        class_5610 modelPartData1 = modelPartData.method_32117("body",
                class_5606.method_32108().method_32101(0, 0).method_32097(-5.5F, -3.5F, -18.0F, 11.0F, 6.0F, 15.0F).method_32101(0, 0).method_32097(-5.5F, -3.5F, -18.0F, 11.0F, 6.0F, 15.0F).method_32101(37, 0)
                        .method_32097(-4.5F, -2.5F, -3.0F, 9.0F, 5.0F, 6.0F).method_32101(0, 20).method_32097(0.0F, -6.0F, -17.0F, 0.0F, 3.0F, 13.0F).method_32101(0, 0).method_32097(0.0F, -5.0F, -1.0F, 0.0F, 3.0F, 3.0F),
                class_5603.method_32090(0.0F, 20.5F, 10.0F));
        class_5610 modelPartData2 = modelPartData1.method_32117("tail", class_5606.method_32108(), class_5603.method_32090(0.0F, 0.5F, 2.5F));
        modelPartData2.method_32117("cube_r1", class_5606.method_32108().method_32101(26, 23).method_32097(-3.5F, -2.5F, -0.5F, 7.0F, 4.0F, 10.0F), class_5603.method_32090(0.0F, 0.0F, 0.0F));
        class_5610 modelPartData3 = modelPartData.method_32117("head", class_5606.method_32108().method_32101(0, 21).method_32097(-4.5F, -3.5F, -8.5F, 9.0F, 3.0F, 9.0F), class_5603.method_32090(0.0F, 21.5F, -7.5F));
        modelPartData3.method_32117("jaw", class_5606.method_32108().method_32101(0, 37).method_32097(-4.5F, -0.5F, -8.5F, 9.0F, 2.0F, 9.0F), class_5603.method_32090(0.0F, 0.0F, 0.0F));
        modelPartData.method_32117("left_middle", class_5606.method_32108().method_32101(27, 37).method_32097(-2.0F, -0.5F, -2.0F, 4.0F, 5.0F, 4.0F), class_5603.method_32090(7.5F, 19.5F, 4.0F));
        modelPartData.method_32117("left_front", class_5606.method_32108().method_32101(27, 37).method_32097(-2.0F, -0.5F, -2.0F, 4.0F, 5.0F, 4.0F), class_5603.method_32090(7.5F, 19.5F, -5.0F));
        modelPartData.method_32117("left_back", class_5606.method_32108().method_32101(27, 37).method_32097(-2.0F, -0.5F, -2.0F, 4.0F, 5.0F, 4.0F), class_5603.method_32090(6.5F, 19.5F, 10.0F));
        modelPartData.method_32117("right_middle", class_5606.method_32108().method_32101(27, 37).method_32100(-2.0F, -0.5F, -2.0F, 4.0F, 5.0F, 4.0F, true), class_5603.method_32090(-7.5F, 19.5F, 4.0F));
        modelPartData.method_32117("right_front", class_5606.method_32108().method_32101(27, 37).method_32100(-2.0F, -0.5F, -2.0F, 4.0F, 5.0F, 4.0F, true), class_5603.method_32090(-7.5F, 19.5F, -5.0F));
        modelPartData.method_32117("right_back", class_5606.method_32108().method_32101(27, 37).method_32100(-2.0F, -0.5F, -2.0F, 4.0F, 5.0F, 4.0F, true), class_5603.method_32090(-6.5F, 19.5F, 10.0F));
        return class_5607.method_32110(modelData, 128, 128);
    }

    @Override
    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.cube_r1.field_3654 = -0.1745F;
        this.head.field_3654 = headPitch * 0.007453292F;
        this.head.field_3675 = headYaw * 0.0017453292F;
        this.right_back.field_3654 = class_3532.method_15362(limbAngle * 0.6662F) * 1.4F * limbDistance;
        this.left_back.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 1.4F * limbDistance;
        this.right_front.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 1.4F * limbDistance;
        this.left_front.field_3654 = class_3532.method_15362(limbAngle * 0.6662F) * 1.4F * limbDistance;

        this.right_middle.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + 4.7123889803F) * 1.4F * limbDistance;
        this.left_middle.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + 1.57079632F) * 1.4F * limbDistance;

        if (entity.method_5841().method_12789(IguanaEntity.OPEN_MOUTH)) {
            this.jaw.field_3654 = 0.3F;
        } else
            this.jaw.field_3654 = 0.0F;
    }

    @Override
    protected Iterable<class_630> method_22946() {
        return ImmutableList.of();
    }

    @Override
    protected Iterable<class_630> method_22948() {
        return ImmutableList.of(this.head, this.body, this.left_middle, this.left_front, this.left_back, this.right_middle, this.right_front, this.right_back);
    }

}
