package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;

import net.adventurez.entity.MammothEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4595;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(EnvType.CLIENT)
public class MammothModel<T extends MammothEntity> extends class_4595<T> {
    private final class_630 body;
    private final class_630 humpRight;
    private final class_630 tail;
    private final class_630 legBackLeft;
    private final class_630 legBackRight;
    private final class_630 legFrontLeft;
    private final class_630 legFrontRight;
    private final class_630 head;
    private final class_630 headRight;
    private final class_630 headLeft;
    private final class_630 trunk;
    private final class_630 trunk_r1;
    private final class_630 trunkOne;
    private final class_630 trunkOne_r1;
    private final class_630 trunkTwo;
    private final class_630 trunkTwo_r1;
    private final class_630 tuskRight;
    private final class_630 tuskTipRight_r1;
    private final class_630 tuskMidRight_r1;
    private final class_630 tuskBackRight_r1;
    private final class_630 tuskFurOverlay_r1;
    private final class_630 tuskLeft;
    private final class_630 tuskTipLeft_r1;
    private final class_630 tuskMidLeft_r1;
    private final class_630 tuskBackLeft_r1;
    private final class_630 tuskBaseLeft_r1;

    public MammothModel(class_630 root) {
        this.body = root.method_32086("body");
        this.tail = this.body.method_32086("tail");
        this.humpRight = this.body.method_32086("humpRight");
        this.legBackLeft = root.method_32086("legBackLeft");
        this.legBackRight = root.method_32086("legBackRight");
        this.legFrontLeft = root.method_32086("legFrontLeft");
        this.legFrontRight = root.method_32086("legFrontRight");
        this.head = root.method_32086("head");
        this.tuskLeft = this.head.method_32086("tuskLeft");
        this.tuskBaseLeft_r1 = this.tuskLeft.method_32086("tuskBaseLeft_r1");
        this.tuskBackLeft_r1 = this.tuskLeft.method_32086("tuskBackLeft_r1");
        this.tuskMidLeft_r1 = this.tuskLeft.method_32086("tuskMidLeft_r1");
        this.tuskTipLeft_r1 = this.tuskLeft.method_32086("tuskTipLeft_r1");
        this.tuskRight = this.head.method_32086("tuskRight");
        this.tuskFurOverlay_r1 = this.tuskRight.method_32086("tuskFurOverlay_r1");
        this.tuskBackRight_r1 = this.tuskRight.method_32086("tuskBackRight_r1");
        this.tuskMidRight_r1 = this.tuskRight.method_32086("tuskMidRight_r1");
        this.tuskTipRight_r1 = this.tuskRight.method_32086("tuskTipRight_r1");
        this.trunk = this.head.method_32086("trunk");
        this.trunkOne = this.trunk.method_32086("trunkOne");
        this.trunkTwo = this.trunkOne.method_32086("trunkTwo");
        this.trunkTwo_r1 = this.trunkTwo.method_32086("trunkTwo_r1");
        this.trunkOne_r1 = this.trunkOne.method_32086("trunkOne_r1");
        this.trunk_r1 = this.trunk.method_32086("trunk_r1");
        this.headLeft = this.head.method_32086("headLeft");
        this.headRight = this.head.method_32086("headRight");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 modelPartData1 = modelPartData.method_32117("body",
                class_5606.method_32108().method_32101(0, 0).method_32097(-8.0F, -9.0F, -11.0F, 16.0F, 15.0F, 13.0F).method_32101(80, 0).method_32097(-7.0F, -6.0F, 2.0F, 14.0F, 12.0F, 10.0F).method_32101(0, 23)
                        .method_32097(-7.0F, 6.0F, 2.0F, 0.0F, 2.0F, 10.0F).method_32101(0, 15).method_32097(-8.0F, 6.0F, -11.0F, 0.0F, 3.0F, 13.0F).method_32101(0, 15).method_32097(8.0F, 6.0F, -11.0F, 0.0F, 3.0F, 13.0F).method_32101(0, 35)
                        .method_32097(-8.0F, 6.0F, -11.0F, 16.0F, 3.0F, 0.0F).method_32101(0, 23).method_32097(7.0F, 6.0F, 2.0F, 0.0F, 2.0F, 10.0F).method_32101(0, 31).method_32097(-7.0F, 6.0F, 12.0F, 14.0F, 2.0F, 0.0F),
                class_5603.method_32090(0.0F, 7.0F, 0.0F));
        modelPartData1.method_32117("humpRight", class_5606.method_32108().method_32101(45, 0).method_32097(-5.0F, 0.0F, -7.0F, 10.0F, 6.0F, 7.0F), class_5603.method_32090(0.0F, -9.0F, -1.0F));
        modelPartData1.method_32117("tail", class_5606.method_32108().method_32101(5, 5).method_32097(-1.0F, 0.0F, -2.0F, 2.0F, 6.0F, 2.0F), class_5603.method_32090(0.0F, -1.0F, 12.0F));
        modelPartData.method_32117("legBackLeft", class_5606.method_32108().method_32101(59, 14).method_32097(-3.0F, 0.0F, -3.0F, 5.0F, 11.0F, 5.0F), class_5603.method_32090(-3.0F, 13.0F, 9.0F));
        modelPartData.method_32117("legBackRight", class_5606.method_32108().method_32101(59, 14).method_32097(-2.0F, 0.0F, -3.0F, 5.0F, 11.0F, 5.0F), class_5603.method_32090(3.0F, 13.0F, 9.0F));
        modelPartData.method_32117("legFrontLeft", class_5606.method_32108().method_32101(59, 14).method_32097(-2.0F, 0.0F, -2.0F, 5.0F, 11.0F, 5.0F), class_5603.method_32090(-5.0F, 13.0F, -8.0F));
        modelPartData.method_32117("legFrontRight", class_5606.method_32108().method_32101(59, 14).method_32097(-2.0F, 0.0F, -2.0F, 5.0F, 11.0F, 5.0F), class_5603.method_32090(4.0F, 13.0F, -8.0F));
        class_5610 modelPartData2 = modelPartData.method_32117("head", class_5606.method_32108().method_32101(92, 22).method_32097(-4.5F, -5.316F, -5.8794F, 9.0F, 12.0F, 9.0F),
                class_5603.method_32090(0.0F, 1.0F, -11.0F));
        modelPartData2.method_32117("headRight", class_5606.method_32108().method_32101(92, 23).method_32097(-3.0F, 0.0F, 0.0F, 3.0F, 6.0F, 1.0F), class_5603.method_32090(-4.5F, -3.316F, -2.8794F));
        modelPartData2.method_32117("headLeft", class_5606.method_32108().method_32101(92, 23).method_32097(0.0F, 0.0F, 0.0F, 3.0F, 6.0F, 1.0F), class_5603.method_32090(4.5F, -3.316F, -2.8794F));
        class_5610 modelPartData3 = modelPartData2.method_32117("trunk", class_5606.method_32108(), class_5603.method_32090(0.0F, 6.684F, -3.8794F));
        modelPartData3.method_32117("trunk_r1", class_5606.method_32108().method_32101(112, 43).method_32097(-2.0F, 0.0F, 0.0F, 4.0F, 8.0F, 4.0F), class_5603.method_32090(0.0F, 0.5176F, -1.9319F));
        class_5610 modelPartData4 = modelPartData3.method_32117("trunkOne", class_5606.method_32108(), class_5603.method_32090(0.0F, 6.4458F, 3.0681F));
        modelPartData4.method_32117("trunkOne_r1", class_5606.method_32108().method_32101(100, 43).method_32097(-1.5F, 0.0F, 0.0F, 3.0F, 7.0F, 3.0F), class_5603.method_32090(0.0F, 0.909F, -1.0834F));
        class_5610 modelPartData5 = modelPartData4.method_32117("trunkTwo", class_5606.method_32108(), class_5603.method_32090(0.0F, 4.8588F, 4.8663F));
        modelPartData5.method_32117("trunkTwo_r1", class_5606.method_32108().method_32101(92, 43).method_32097(-1.0F, 0.0F, 0.0F, 2.0F, 5.0F, 2.0F), class_5603.method_32090(0.0F, 0.8609F, -1.1219F));
        class_5610 modelPartData6 = modelPartData2.method_32117("tuskRight", class_5606.method_32108(), class_5603.method_32090(4.5F, 2.684F, -3.8794F));
        modelPartData6.method_32117("tuskTipRight_r1", class_5606.method_32108().method_32101(102, 53).method_32097(-2.0F, 0.0F, -2.0F, 2.0F, 7.0F, 2.0F), class_5603.method_32090(7.907F, 12.1641F, -1.8623F));
        modelPartData6.method_32117("tuskMidRight_r1", class_5606.method_32108().method_32101(110, 55).method_32097(-2.0F, 0.0F, -2.0F, 2.0F, 7.0F, 2.0F), class_5603.method_32090(5.3262F, 8.4783F, 3.5F));
        modelPartData6.method_32117("tuskBackRight_r1", class_5606.method_32108().method_32101(118, 55).method_32097(-2.0F, -1.0F, 0.0F, 2.0F, 6.0F, 3.0F), class_5603.method_32090(2.4583F, 4.3826F, 0.5F));
        modelPartData6.method_32117("tuskFurOverlay_r1", class_5606.method_32108().method_32101(46, 28).method_32097(-3.0F, 4.0F, 0.0F, 3.0F, 2.0F, 4.0F).method_32101(32, 28).method_32097(-3.0F, 0.0F, 0.0F, 3.0F, 4.0F, 4.0F),
                class_5603.method_32090(0.0F, 0.0F, 0.0F));
        class_5610 modelPartData7 = modelPartData2.method_32117("tuskLeft", class_5606.method_32108(), class_5603.method_32090(-5.5F, 1.684F, -3.8794F));
        modelPartData7.method_32117("tuskTipLeft_r1", class_5606.method_32108().method_32101(102, 53).method_32097(0.0F, 0.0F, -2.0F, 2.0F, 7.0F, 2.0F), class_5603.method_32090(-4.6746F, 14.3523F, -1.8623F));
        modelPartData7.method_32117("tuskMidLeft_r1", class_5606.method_32108().method_32101(110, 55).method_32097(0.0F, 0.0F, -2.0F, 2.0F, 7.0F, 2.0F), class_5603.method_32090(-2.773F, 10.2744F, 3.5F));
        modelPartData7.method_32117("tuskBackLeft_r1", class_5606.method_32108().method_32101(118, 55).method_32097(0.0F, -1.0F, -3.0F, 2.0F, 6.0F, 3.0F), class_5603.method_32090(-0.6599F, 5.7428F, 3.5F));
        modelPartData7.method_32117("tuskBaseLeft_r1", class_5606.method_32108().method_32101(46, 28).method_32097(0.0F, 4.0F, 0.0F, 3.0F, 2.0F, 4.0F).method_32101(32, 28).method_32097(0.0F, 0.0F, 0.0F, 3.0F, 4.0F, 4.0F),
                class_5603.method_32090(1.0F, 1.0F, 0.0F));
        return class_5607.method_32110(modelData, 128, 128);
    }

    @Override
    public Iterable<class_630> method_22960() {
        return ImmutableList.of(this.head, this.body, this.legBackLeft, this.legBackRight, this.legFrontLeft, this.legFrontRight);
    }

    @Override
    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.head.field_3675 = headYaw * 0.007453292F;
        this.head.field_3654 = headPitch * 0.007453292F;
        this.humpRight.field_3654 = -0.6981F;
        this.tail.field_3654 = 0.5236F;
        this.head.field_3654 = -0.3491F;
        this.headRight.field_3675 = 0.6109F;
        this.headLeft.field_3675 = -0.6109F;
        this.trunk.field_3654 = -0.2618F;
        this.trunk_r1.field_3654 = 0.5236F;
        this.trunkOne.field_3654 = 0.0873F;
        this.trunkOne_r1.field_3654 = 0.7854F;
        this.trunkTwo.field_3654 = 0.1309F;
        this.trunkTwo_r1.field_3654 = 1.309F;
        this.tuskRight.field_3674 = 0.1745F;
        this.tuskTipRight_r1.field_3654 = -1.7453F;
        this.tuskTipRight_r1.field_3674 = -0.6109F;
        this.tuskMidRight_r1.field_3654 = -0.8727F;
        this.tuskMidRight_r1.field_3674 = -0.6109F;
        this.tuskBackRight_r1.field_3674 = -0.6109F;
        this.tuskFurOverlay_r1.field_3674 = -0.6109F;
        this.tuskTipLeft_r1.field_3654 = -1.7453F;
        this.tuskTipLeft_r1.field_3674 = 0.4363F;
        this.tuskMidLeft_r1.field_3654 = -0.8727F;
        this.tuskMidLeft_r1.field_3674 = 0.4363F;
        this.tuskBackLeft_r1.field_3674 = 0.4363F;
        this.tuskBaseLeft_r1.field_3674 = 0.4363F;
        float slowerWalking = 0.6662F;
        if (entity.method_6109()) {
            slowerWalking = 0.1F;
        }
        this.legBackRight.field_3654 = class_3532.method_15362(limbAngle * slowerWalking + 3.1415927F) * 0.7F * limbDistance;
        this.legBackLeft.field_3654 = class_3532.method_15362(limbAngle * slowerWalking) * 0.7F * limbDistance;
        this.legFrontLeft.field_3654 = class_3532.method_15362(limbAngle * slowerWalking + 3.1415927F) * 0.7F * limbDistance;
        this.legFrontRight.field_3654 = class_3532.method_15362(limbAngle * slowerWalking) * 0.7F * limbDistance;

        int i = entity.method_5841().method_12789(MammothEntity.ATTACK_TICKS);
        if (i > 0) {
            this.head.field_3654 = -0.3491F + class_3532.method_15374((3.14159265358F / 10F) * ((float) i - 9)) * 0.4F;
        }

    }

}
