package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;

import net.adventurez.entity.MiniBlackstoneGolemEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4595;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(EnvType.CLIENT)
public class MiniBlackstoneGolemModel<T extends MiniBlackstoneGolemEntity> extends class_4595<T> {
    private final class_630 head;
    private final class_630 torso;
    private final class_630 rightArm;
    private final class_630 leftArm;
    private final class_630 rightLeg;
    private final class_630 leftLeg;

    public MiniBlackstoneGolemModel(class_630 root) {
        this.head = root.method_32086("head");
        this.torso = root.method_32086("torso");
        this.rightArm = root.method_32086("rightArm");
        this.leftArm = root.method_32086("leftArm");
        this.rightLeg = root.method_32086("rightLeg");
        this.leftLeg = root.method_32086("leftLeg");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        modelPartData.method_32117("head", class_5606.method_32108().method_32101(0, 0).method_32097(-4.0F, -8.2796F, -7.044F, 8.0F, 10.0F, 8.0F).method_32101(24, 0).method_32097(-1.0F, -1.2796F, -9.044F, 2.0F, 4.0F, 2.0F),
                class_5603.method_32090(0.0F, 13.0F, -5.0F));
        modelPartData.method_32117("torso", class_5606.method_32108().method_32101(0, 40).method_32097(-9.0F, -5.7148F, -5.5702F, 18.0F, 11.0F, 11.0F), class_5603.method_32090(0.0F, 15.0F, 0.0F));
        modelPartData.method_32117("rightArm", class_5606.method_32108().method_32101(60, 21).method_32097(9.0F, -2.4685F, -2.9247F, 4.0F, 13.0F, 6.0F), class_5603.method_32090(0.0F, 15.0F, -4.0F));
        modelPartData.method_32117("leftArm", class_5606.method_32108().method_32101(60, 58).method_32097(-13.0F, -2.4685F, -2.9247F, 4.0F, 13.0F, 6.0F), class_5603.method_32090(0.0F, 15.0F, -4.0F));
        modelPartData.method_32117("rightLeg", class_5606.method_32108().method_32101(37, 0).method_32097(1.5F, -1.7043F, -2.5805F, 6.0F, 11.0F, 5.0F), class_5603.method_32090(0.0F, 16.0F, 5.0F));
        modelPartData.method_32117("leftLeg", class_5606.method_32108().method_32101(60, 0).method_32097(-7.5F, -1.7043F, -2.5805F, 6.0F, 11.0F, 5.0F), class_5603.method_32090(0.0F, 16.0F, 5.0F));
        return class_5607.method_32110(modelData, 128, 128);
    }

    @Override
    public Iterable<class_630> method_22960() {
        return ImmutableList.of(this.head, this.torso, this.rightLeg, this.leftLeg, this.rightArm, this.leftArm);
    }

    @Override
    public void setAngles(T stoneGolem, float f, float g, float h, float i, float j) {
        this.head.field_3675 = i * 0.0077453292F;
        this.head.field_3654 = j * 0.0017453292F + 0.1745F;
        this.rightLeg.field_3675 = 0.0F;
        this.leftLeg.field_3675 = 0.0F;
        this.rightLeg.field_3654 = -0.3F * class_3532.method_24504(f, 13.0F) * g * 1.3F + 0.4363F;
        this.leftLeg.field_3654 = 0.3F * class_3532.method_24504(f, 13.0F) * g * 1.3F + 0.4363F;
        this.torso.field_3654 = 1.309F;
        this.rightArm.field_3654 = 0.5F * class_3532.method_24504(f, 13.0F) * g * 1.3F - 0.6109F;
        this.leftArm.field_3654 = -0.5F * class_3532.method_24504(f, 13.0F) * g * 1.3F - 0.6109F;
        float k = class_3532.method_15374(this.field_3447 * 3.1415927F);
        if (k > 0) {
            this.rightArm.field_3654 = -k * 1.5F;
        }
    }

}
