package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;

import net.adventurez.entity.NecromancerEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4595;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(EnvType.CLIENT)
public class NecromancerModel<T extends NecromancerEntity> extends class_4595<T> {
    private final class_630 head;
    private final class_630 head2;
    private final class_630 body;
    private final class_630 leftArm;
    private final class_630 rightArm;
    private final class_630 leftLeg;
    private final class_630 rightLeg;

    public NecromancerModel(class_630 root) {
        this.head = root.method_32086("head");
        this.head2 = this.head.method_32086("head2");
        this.body = root.method_32086("body");
        this.leftArm = root.method_32086("leftArm");
        this.rightArm = root.method_32086("rightArm");
        this.leftLeg = root.method_32086("leftLeg");
        this.rightLeg = root.method_32086("rightLeg");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 modelPartData1 = modelPartData.method_32117("head",
                class_5606.method_32108().method_32101(27, 8).method_32097(-4.0F, -6.0F, -4.0F, 8.0F, 8.0F, 8.0F).method_32101(16, 0).method_32097(5.0F, -2.0F, -2.0F, 1.0F, 3.0F, 1.0F).method_32101(0, 2)
                        .method_32097(-6.0F, -2.0F, -2.0F, 1.0F, 3.0F, 1.0F).method_32101(4, 20).method_32097(-5.0F, -2.0F, -2.0F, 1.0F, 1.0F, 1.0F).method_32101(0, 20).method_32097(-5.0F, 0.0F, -2.0F, 1.0F, 1.0F, 1.0F).method_32101(19, 3)
                        .method_32097(4.0F, 0.0F, -2.0F, 1.0F, 1.0F, 1.0F).method_32101(16, 4).method_32097(4.0F, -2.0F, -2.0F, 1.0F, 1.0F, 1.0F).method_32101(0, 0).method_32097(-1.0F, -1.0F, -5.0F, 2.0F, 1.0F, 1.0F),
                class_5603.method_32090(0.0F, -6.0F, -2.0F));
        modelPartData1.method_32117("head2", class_5606.method_32108().method_32101(36, 36).method_32097(-8.0F, -11.0F, 0.0F, 16.0F, 14.0F, 0.0F), class_5603.method_32090(0.0F, -2.0F, 1.0F));
        modelPartData.method_32117("body",
                class_5606.method_32108().method_32101(0, 27).method_32097(-5.0F, -5.0F, -3.0F, 10.0F, 9.0F, 8.0F).method_32101(0, 44).method_32097(-5.0F, 4.0F, -3.0F, 10.0F, 6.0F, 6.0F).method_32101(19, 0)
                        .method_32097(-6.0F, 10.0F, -4.0F, 12.0F, 0.0F, 8.0F).method_32101(52, 24).method_32097(-6.0F, 10.0F, 4.0F, 12.0F, 12.0F, 0.0F).method_32101(51, 0).method_32097(-6.0F, 10.0F, -4.0F, 12.0F, 12.0F, 0.0F).method_32101(48, 48)
                        .method_32097(-6.0F, 10.0F, -4.0F, 0.0F, 12.0F, 8.0F).method_32101(0, 48).method_32097(6.0F, 10.0F, -4.0F, 0.0F, 12.0F, 8.0F),
                class_5603.method_32090(0.0F, 0.0F, 0.0F));
        modelPartData.method_32117("leftArm", class_5606.method_32108().method_32101(60, 64).method_32097(-1.0F, 3.0F, -2.0F, 4.0F, 14.0F, 4.0F).method_32101(10, 64).method_32097(-2.0F, -3.0F, -3.0F, 5.0F, 6.0F, 6.0F),
                class_5603.method_32090(-8.0F, -3.0F, 0.0F));
        modelPartData.method_32117("rightArm", class_5606.method_32108().method_32101(44, 68).method_32097(-2.0F, 3.0F, -2.0F, 4.0F, 14.0F, 4.0F).method_32101(0, 0).method_32097(0.0F, 13.0F, -15.0F, 1.0F, 2.0F, 25.0F).method_32101(59, 12)
                .method_32097(-2.0F, 11.0F, -21.0F, 5.0F, 6.0F, 6.0F).method_32101(62, 44).method_32097(-2.0F, -3.0F, -3.0F, 5.0F, 6.0F, 6.0F), class_5603.method_32090(7.0F, -3.0F, 0.0F));
        modelPartData.method_32117("leftLeg", class_5606.method_32108().method_32101(26, 50).method_32097(-2.0F, 2.0F, -3.0F, 5.0F, 14.0F, 6.0F), class_5603.method_32090(-2.9F, 8.0F, 0.0F));
        modelPartData.method_32117("rightLeg", class_5606.method_32108().method_32101(0, 0).method_32097(-3.0F, 2.0F, -3.0F, 5.0F, 14.0F, 6.0F), class_5603.method_32090(2.9F, 8.0F, 0.0F));
        return class_5607.method_32110(modelData, 128, 128);
    }

    @Override
    public Iterable<class_630> method_22960() {
        return ImmutableList.of(this.head, this.body, this.rightLeg, this.leftLeg, this.rightArm, this.leftArm);
    }

    @Override
    public void setAngles(T necromancer, float f, float g, float h, float i, float j) {
        this.head.field_3675 = i * 0.0119453292F;
        this.head.field_3654 = j * 0.0061453292F;
        this.head2.field_3654 = -0.2618F;
        this.rightArm.field_3654 = class_3532.method_15362(f * 0.6662F + 3.1415927F) * 2.0F * g * 0.5F;
        this.rightArm.field_3675 = 0.0F;
        this.rightArm.field_3674 = 0.0F;
        this.leftArm.field_3654 = class_3532.method_15362(f * 0.6662F) * 2.0F * g * 0.5F;
        this.leftArm.field_3675 = 0.0F;
        this.leftArm.field_3674 = 0.0F;
        this.rightLeg.field_3654 = class_3532.method_15362(f * 0.6662F) * 1.4F * g * 0.5F;
        this.rightLeg.field_3675 = 0.0F;
        this.rightLeg.field_3674 = 0.0F;
        this.leftLeg.field_3654 = class_3532.method_15362(f * 0.6662F + 3.1415927F) * 1.4F * g * 0.5F;
        this.leftLeg.field_3675 = 0.0F;
        this.leftLeg.field_3674 = 0.0F;

        if (necromancer.isSpellcasting()) {
            this.rightArm.field_3655 = 0.0F;
            this.rightArm.field_3657 = 7.0F;
            this.rightArm.field_3654 = class_3532.method_15362(h * 0.6662F) * 0.1F - 0.6F;
            this.rightArm.field_3674 = -2.0F;
            this.rightArm.field_3675 = -0.5F;
        }
    }

}
