package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;

import net.adventurez.entity.OrcEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4595;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(EnvType.CLIENT)
public class OrcModel<T extends OrcEntity> extends class_4595<T> {
    private final class_630 leftLeg;
    private final class_630 rightLeg;
    private final class_630 torso;
    private final class_630 leftArm;
    private final class_630 rightArm;
    private final class_630 head;
    private final class_630 header;
    private final class_630 earLeft;
    private final class_630 ear2;
    private final class_630 earRight;
    private final class_630 ear;

    public OrcModel(class_630 root) {
        this.leftLeg = root.method_32086("leftLeg");
        this.rightLeg = root.method_32086("rightLeg");
        this.torso = root.method_32086("torso");
        this.leftArm = root.method_32086("leftArm");
        this.rightArm = root.method_32086("rightArm");
        this.head = root.method_32086("head");
        this.header = this.head.method_32086("header");
        this.earRight = this.header.method_32086("earRight");
        this.ear = this.earRight.method_32086("ear");
        this.earLeft = this.header.method_32086("earLeft");
        this.ear2 = this.earLeft.method_32086("ear2");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        modelPartData.method_32117("leftLeg", class_5606.method_32108().method_32101(54, 0).method_32097(-3.5F, 6.0F, -3.0F, 6.0F, 6.0F, 6.0F).method_32101(60, 35).method_32097(-3.0F, -1.0F, -2.5F, 5.0F, 7.0F, 5.0F),
                class_5603.method_32090(-3.0F, 12.0F, 0.0F));
        modelPartData.method_32117("rightLeg", class_5606.method_32108().method_32101(42, 50).method_32097(-2.5F, 6.0F, -3.0F, 6.0F, 6.0F, 6.0F).method_32101(0, 57).method_32097(-2.0F, -1.0F, -2.5F, 5.0F, 7.0F, 5.0F),
                class_5603.method_32090(3.0F, 12.0F, 0.0F));
        modelPartData.method_32117("torso", class_5606.method_32108().method_32101(0, 17).method_32097(-7.0F, 5.0F, -4.0F, 14.0F, 7.0F, 8.0F).method_32101(0, 0).method_32097(-7.0F, -5.0F, -3.0F, 14.0F, 10.0F, 7.0F),
                class_5603.method_32090(0.0F, 0.0F, 0.0F));
        modelPartData.method_32117("leftArm", class_5606.method_32108().method_32101(18, 50).method_32097(-3.0F, -2.0F, -3.0F, 6.0F, 6.0F, 6.0F).method_32101(61, 61).method_32097(-2.5F, 4.0F, -2.5F, 5.0F, 6.0F, 5.0F).method_32101(44, 23)
                .method_32097(-3.0F, 10.0F, -3.0F, 6.0F, 6.0F, 6.0F), class_5603.method_32090(-10.0F, -2.0F, 1.0F));
        modelPartData.method_32117("rightArm", class_5606.method_32108().method_32101(0, 44).method_32097(-3.0F, -2.0F, -3.0F, 6.0F, 6.0F, 6.0F).method_32101(60, 12).method_32097(-2.5F, 4.0F, -2.5F, 5.0F, 6.0F, 5.0F).method_32101(36, 11)
                .method_32097(-3.0F, 10.0F, -3.0F, 6.0F, 6.0F, 6.0F), class_5603.method_32090(10.0F, -2.0F, 1.0F));
        class_5610 modelPartData1 = modelPartData.method_32117("head", class_5606.method_32108().method_32101(0, 32).method_32097(-4.5F, 0.0F, -8.0F, 9.0F, 3.0F, 9.0F).method_32101(0, 2)
                .method_32097(2.5F, -1.0F, -7.5F, 1.0F, 1.0F, 1.0F).method_32101(0, 0).method_32097(-3.5F, -1.0F, -7.5F, 1.0F, 1.0F, 1.0F), class_5603.method_32090(0.0F, -4.0F, 0.0F));
        class_5610 modelPartData2 = modelPartData1.method_32117("header", class_5606.method_32108().method_32101(28, 36).method_32097(-4.0F, 0.0F, 0.2F, 8.0F, 6.0F, 8.0F), class_5603.method_32090(0.0F, -6.0F, -7.0F));
        class_5610 modelPartData3 = modelPartData2.method_32117("earLeft", class_5606.method_32108(), class_5603.method_32090(0.0F, 2.0F, 7.0F));
        modelPartData3.method_32117("ear2", class_5606.method_32108().method_32101(42, 0).method_32097(-1.0F, 0.0F, 0.0F, 1.0F, 4.0F, 4.0F), class_5603.method_32090(-2.0F, -2.0F, -1.0F));
        class_5610 modelPartData4 = modelPartData2.method_32117("earRight", class_5606.method_32108(), class_5603.method_32090(0.0F, -4.0F, 7.0F));
        modelPartData4.method_32117("ear", class_5606.method_32108().method_32101(60, 47).method_32097(0.0F, 0.0F, 0.0F, 1.0F, 4.0F, 4.0F), class_5603.method_32090(2.0F, 4.0F, -1.0F));
        return class_5607.method_32110(modelData, 128, 128);
    }

    @Override
    public Iterable<class_630> method_22960() {
        return ImmutableList.of(this.head, this.torso, this.rightLeg, this.leftLeg, this.rightArm, this.leftArm);
    }

    @Override
    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.leftArm.field_3654 = -0.2618F;
        this.leftArm.field_3674 = 0.0436F;
        this.rightArm.field_3654 = -0.2618F;
        this.rightArm.field_3674 = -0.0436F;
        this.header.field_3654 = -0.0436F;
        this.ear2.field_3654 = 0.48F;
        this.ear2.field_3675 = -0.5236F;
        this.ear.field_3654 = 0.48F;
        this.ear.field_3675 = 0.5236F;

        this.head.field_3675 = headYaw * 0.0089453292F;
        this.head.field_3654 = headPitch * 0.0047453292F;

        this.rightLeg.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 1.4F * limbDistance;
        this.leftLeg.field_3654 = class_3532.method_15362(limbAngle * 0.6662F) * 1.4F * limbDistance;

        this.rightArm.field_3654 = -class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 2.0F * limbDistance * 0.32F;
        this.leftArm.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 2.0F * limbDistance * 0.32F;
        float k = class_3532.method_15374(entity.field_6251 * 3.1415927F);
        if (k > 0) {
            this.rightArm.field_3654 = -k;
            if (entity.method_5841().method_12789(OrcEntity.DOUBLE_HAND_ATTACK)) {
                this.leftArm.field_3654 = -k;
            }
        }
    }

    public class_630 getTorso() {
        return this.torso;
    }

}