package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;

import net.adventurez.entity.PiglinBeastEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4595;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(EnvType.CLIENT)
public class PiglinBeastModel<T extends PiglinBeastEntity> extends class_4595<T> {
    private final class_630 head;
    private final class_630 body;
    private final class_630 leftHorn;
    private final class_630 rightHorn;
    private final class_630 leftEar;
    private final class_630 rightEar;
    private final class_630 flagHolder;
    private final class_630 flag;
    private final class_630 leftArm;
    private final class_630 rightArm;
    private final class_630 leftLeg;
    private final class_630 rightLeg;

    public PiglinBeastModel(class_630 root) {
        this.head = root.method_32086("head");
        this.rightEar = this.head.method_32086("rightEar");
        this.leftEar = this.head.method_32086("leftEar");
        this.rightHorn = this.head.method_32086("rightHorn");
        this.leftHorn = this.head.method_32086("leftHorn");
        this.body = root.method_32086("body");
        this.flagHolder = this.body.method_32086("flagHolder");
        this.flag = this.flagHolder.method_32086("flag");
        this.leftArm = root.method_32086("leftArm");
        this.rightArm = root.method_32086("rightArm");
        this.leftLeg = root.method_32086("leftLeg");
        this.rightLeg = root.method_32086("rightLeg");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 modelPartData1 = modelPartData.method_32117("head", class_5606.method_32108().method_32101(74, 0).method_32097(-5.0F, -11.0F, -5.0F, 10.0F, 9.0F, 10.0F).method_32101(57, 11)
                .method_32097(3.0F, -5.0F, -6.0F, 3.0F, 2.0F, 1.0F).method_32101(48, 56).method_32097(-6.0F, -5.0F, -6.0F, 3.0F, 2.0F, 1.0F).method_32101(0, 38).method_32097(-3.0F, -7.0F, -6.0F, 6.0F, 4.0F, 1.0F),
                class_5603.method_32090(0.0F, -16.0F, -1.0F));
        modelPartData1.method_32117("leftHorn", class_5606.method_32108().method_32101(51, 30).method_32097(-4.7379F, 1.2403F, 0.62F, 6.0F, 2.0F, 1.0F), class_5603.method_32090(-3.0F, -6.0F, -7.0F));
        modelPartData1.method_32117("rightHorn", class_5606.method_32108().method_32101(0, 14).method_32097(-1.8264F, 1.6629F, -0.3197F, 6.0F, 2.0F, 1.0F), class_5603.method_32090(3.0F, -7.0F, -6.0F));
        modelPartData1.method_32117("hair",
                class_5606.method_32108().method_32101(61, 32).method_32097(-3.0F, -8.0F, 6.0F, 0.0F, 4.0F, 1.0F).method_32101(0, 51).method_32097(-3.0F, -7.0F, 8.0F, 0.0F, 3.0F, 1.0F).method_32101(10, 51)
                        .method_32097(-3.0F, -9.0F, 4.0F, 0.0F, 5.0F, 1.0F).method_32101(50, 46).method_32097(-3.0F, -6.0F, 10.0F, 0.0F, 2.0F, 1.0F).method_32101(48, 48).method_32097(-3.0F, 1.0F, 11.0F, 0.0F, 1.0F, 3.0F).method_32101(8, 45)
                        .method_32097(-3.0F, -1.0F, 11.0F, 0.0F, 1.0F, 2.0F).method_32101(13, 12).method_32097(-3.0F, -3.0F, 11.0F, 0.0F, 1.0F, 2.0F).method_32101(0, 49).method_32097(-3.0F, -4.0F, 11.0F, 0.0F, 1.0F, 1.0F).method_32101(8, 41)
                        .method_32097(-3.0F, -2.0F, 11.0F, 0.0F, 1.0F, 3.0F).method_32101(0, 40).method_32097(-3.0F, 0.0F, 11.0F, 0.0F, 1.0F, 4.0F).method_32101(0, 39).method_32097(-3.0F, 2.0F, 11.0F, 0.0F, 1.0F, 4.0F).method_32101(8, 40)
                        .method_32097(-3.0F, 3.0F, 11.0F, 0.0F, 1.0F, 3.0F).method_32101(13, 37).method_32097(-3.0F, 4.0F, 11.0F, 0.0F, 1.0F, 1.0F).method_32101(61, 1).method_32097(-3.0F, -8.0F, 2.0F, 0.0F, 4.0F, 1.0F).method_32101(48, 46)
                        .method_32097(-3.0F, -6.0F, 3.0F, 0.0F, 2.0F, 1.0F).method_32101(0, 29).method_32097(-3.0F, -7.0F, 5.0F, 0.0F, 3.0F, 1.0F).method_32101(14, 14).method_32097(-3.0F, -6.0F, 7.0F, 0.0F, 2.0F, 1.0F).method_32101(2, 49)
                        .method_32097(-3.0F, -5.0F, 9.0F, 0.0F, 1.0F, 1.0F),
                class_5603.method_32090(3.0F, -7.0F, -6.0F));
        modelPartData1.method_32117("leftEar", class_5606.method_32108().method_32101(57, 0).method_32097(-5.0F, -1.0F, -3.0F, 6.0F, 1.0F, 6.0F), class_5603.method_32090(-5.0F, -8.0F, 0.0F));
        modelPartData1.method_32117("rightEar", class_5606.method_32108().method_32101(48, 49).method_32097(-5.0F, -0.0603F, -3.0F, 6.0F, 1.0F, 6.0F), class_5603.method_32090(5.0F, -8.0F, 0.0F));
        class_5610 modelPartData2 = modelPartData.method_32117("body",
                class_5606.method_32108().method_32101(47, 56).method_32097(-8.0F, 12.0F, -8.0F, 18.0F, 3.0F, 13.0F).method_32101(0, 30).method_32097(-8.0F, 10.0F, -9.0F, 18.0F, 2.0F, 15.0F).method_32101(0, 0)
                        .method_32097(-9.0F, -3.0F, -10.0F, 20.0F, 13.0F, 17.0F).method_32101(74, 19).method_32097(-9.0F, 10.0F, -10.0F, 20.0F, 10.0F, 0.0F).method_32101(72, 72).method_32097(-9.0F, 10.0F, 7.0F, 20.0F, 10.0F, 0.0F)
                        .method_32101(29, 55).method_32097(11.0F, 10.0F, -10.0F, 0.0F, 10.0F, 17.0F).method_32101(29, 55).method_32097(-9.0F, 10.0F, -10.0F, 0.0F, 10.0F, 17.0F).method_32101(52, 33)
                        .method_32097(-8.0F, -5.0F, -7.0F, 18.0F, 2.0F, 14.0F).method_32101(0, 47).method_32097(-8.0F, -15.0F, -5.0F, 18.0F, 10.0F, 12.0F),
                class_5603.method_32090(-1.0F, -3.0F, 1.0F));
        class_5610 modelPartData3 = modelPartData2.method_32117("flagHolder", class_5606.method_32108().method_32101(76, 95).method_32097(-2.0F, -37.9319F, 0.4824F, 2.0F, 29.0F, 2.0F).method_32101(46, 72)
                .method_32097(-3.0F, -42.0F, -1.0F, 4.0F, 5.0F, 18.0F).method_32101(0, 0).method_32097(-3.0F, -8.9319F, -0.5176F, 4.0F, 10.0F, 4.0F), class_5603.method_32090(4.0F, 8.0F, 6.0F));
        modelPartData3.method_32117("flag", class_5606.method_32108().method_32101(0, 79).method_32097(0.0F, -0.6136F, -6.8755F, 0.0F, 24.0F, 14.0F), class_5603.method_32090(-1.0F, -38.0F, 9.0F));
        modelPartData.method_32117("leftArm", class_5606.method_32108().method_32101(28, 93).method_32097(-3.3939F, -1.3963F, -3.0F, 5.0F, 24.0F, 6.0F), class_5603.method_32090(-9.0F, -15.0F, 2.0F));
        modelPartData.method_32117("rightArm", class_5606.method_32108().method_32101(84, 89).method_32097(-0.899F, -1.1716F, -3.0F, 5.0F, 25.0F, 6.0F).method_32101(101, 71).method_32097(0.8422F, 18.7943F, -6.0F, 2.0F, 3.0F, 11.0F)
                .method_32101(51, 39).method_32097(-0.1578F, 18.7943F, -8.0F, 3.0F, 4.0F, 2.0F).method_32101(0, 30).method_32097(-0.1578F, 17.7943F, -11.0F, 4.0F, 5.0F, 3.0F).method_32101(0, 69)
                .method_32097(-1.1578F, 16.7943F, -28.0F, 6.0F, 7.0F, 17.0F).method_32101(51, 33).method_32097(-0.1578F, 17.7943F, -29.0F, 4.0F, 5.0F, 1.0F).method_32101(64, 13).method_32097(1.3951F, 15.9987F, -14.0F, 3.0F, 1.0F, 1.0F)
                .method_32101(57, 7).method_32097(0.3951F, 15.9987F, -21.0F, 1.0F, 1.0F, 3.0F).method_32101(12, 0).method_32097(1.361F, 14.2576F, -27.0F, 1.0F, 3.0F, 1.0F).method_32101(0, 0)
                .method_32097(3.5517F, 13.8093F, -24.0F, 1.0F, 3.0F, 1.0F).method_32101(11, 30).method_32097(2.5858F, 14.5505F, -19.0F, 1.0F, 2.0F, 1.0F).method_32101(57, 0).method_32097(4.9319F, 17.5176F, -24.0F, 2.0F, 1.0F, 1.0F)
                .method_32101(48, 52).method_32097(4.6731F, 18.4836F, -16.0F, 2.0F, 1.0F, 1.0F).method_32101(0, 56).method_32097(4.3801F, 19.7083F, -25.0F, 4.0F, 1.0F, 1.0F).method_32101(64, 10)
                .method_32097(4.0F, 21.6401F, -24.0F, 3.0F, 1.0F, 1.0F).method_32101(0, 52).method_32097(3.5F, 21.6401F, -17.0F, 2.0F, 1.0F, 3.0F).method_32101(57, 2).method_32097(3.3449F, 23.572F, -26.0F, 1.0F, 2.0F, 1.0F).method_32101(56, 56)
                .method_32097(0.4471F, 23.7955F, -24.0F, 1.0F, 2.0F, 1.0F).method_32101(0, 47).method_32097(1.413F, 23.7F, -19.0F, 1.0F, 2.0F, 1.0F).method_32101(8, 48).method_32097(2.3789F, 23.3131F, -16.0F, 1.0F, 2.0F, 1.0F).method_32101(62, 7)
                .method_32097(-2.9331F, 21.0872F, -27.0F, 3.0F, 1.0F, 1.0F).method_32101(57, 14).method_32097(-3.3813F, 18.8965F, -23.0F, 3.0F, 1.0F, 1.0F).method_32101(48, 49).method_32097(-2.1225F, 17.9306F, -16.0F, 2.0F, 1.0F, 1.0F)
                .method_32101(0, 47).method_32097(-2.3813F, 19.8965F, -18.0F, 2.0F, 1.0F, 4.0F), class_5603.method_32090(8.0F, -15.0F, 2.0F));
        modelPartData.method_32117("leftLeg", class_5606.method_32108().method_32101(96, 49).method_32097(-3.0F, 0.0F, -4.0F, 6.0F, 13.0F, 7.0F), class_5603.method_32090(-3.9F, 11.0F, 0.0F));
        modelPartData.method_32117("rightLeg", class_5606.method_32108().method_32101(50, 95).method_32097(-3.0F, 0.0F, -4.0F, 6.0F, 13.0F, 7.0F), class_5603.method_32090(3.9F, 11.0F, 0.0F));
        return class_5607.method_32110(modelData, 128, 128);
    }

    @Override
    public Iterable<class_630> method_22960() {
        return ImmutableList.of(this.head, this.body, this.rightLeg, this.leftLeg, this.rightArm, this.leftArm);
    }

    @Override
    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.head.field_3675 = headYaw * 0.0079453292F;
        this.head.field_3654 = headPitch * 0.0027453292F;
        this.leftHorn.field_3675 = -0.3491F;
        this.leftHorn.field_3674 = 1.1345F;
        this.rightHorn.field_3675 = 0.3491F;
        this.rightHorn.field_3674 = -1.1345F;
        this.leftEar.field_3674 = -1.1345F;
        this.rightEar.field_3674 = -1.9199F;
        this.leftArm.field_3674 = 0.2618F;
        this.rightArm.field_3674 = -0.2618F;
        this.flagHolder.field_3654 = -0.2618F;
        this.flag.field_3654 = 0.1745F;
        // Animation
        // Legs
        this.rightLeg.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 1.4F * limbDistance;
        this.leftLeg.field_3654 = class_3532.method_15362(limbAngle * 0.6662F) * 1.4F * limbDistance;
        // Flag
        flag.field_3674 = class_3532.method_15362(animationProgress / 10) / 4;
        // Arms
        this.rightArm.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 2.0F * limbDistance * 0.3F;
        this.leftArm.field_3654 = -class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 2.0F * limbDistance * 0.3F;

        float attackTick = entity.method_5841().method_12789(PiglinBeastEntity.ATTACK_TICK_VISUAL);
        if (attackTick > 0F) {
            float g = attackTick;
            float h = class_3532.method_15374(g * 3.1415927F);
            float i = class_3532.method_15374(attackTick * 3.1415927F) * -(this.head.field_3654 - 0.7F) * 0.75F;
            rightArm.field_3654 = (float) ((double) rightArm.field_3654 - ((double) h * 1.2D + (double) i));
            rightArm.field_3674 += class_3532.method_15374(attackTick * 3.1415927F) * -0.4F - limbDistance;
        }

        float handUp = entity.method_5841().method_12789(PiglinBeastEntity.LEAD_ARM);
        if (handUp > 0.0F) {
            float g = handUp;
            float h = class_3532.method_15374(g * 3.1415927F);
            float i = class_3532.method_15374(handUp * 3.1415927F) * -(this.head.field_3654 - 0.7F) * 0.75F;
            leftArm.field_3654 = (float) ((double) leftArm.field_3654 - ((double) h * 1.2D + (double) i));
        }
        // Ears
        rightEar.field_3674 = rightEar.field_3674 + ((class_3532.method_15362((limbAngle * 0.6662F + 3.1415927F) / 3) * limbDistance) / 2);
        leftEar.field_3674 = leftEar.field_3674 - ((class_3532.method_15362((limbAngle * 0.6662F + 3.1415927F) / 3) * limbDistance) / 2);
    }

}