package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1429;
import net.minecraft.class_3532;
import net.minecraft.class_4592;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(EnvType.CLIENT)
public class SkunkModel<T extends class_1429> extends class_4592<T> {
    private final class_630 body;
    private final class_630 leftFrontLeg;
    private final class_630 leftBackLeg;
    private final class_630 rightBackLeg;
    private final class_630 rightFrontLeg;
    private final class_630 tail;
    private final class_630 head;

    public SkunkModel(class_630 root) {
        super(true, 10.0F, 4.0F);
        this.body = root.method_32086("body");
        this.leftFrontLeg = this.body.method_32086("leftFrontLeg");
        this.leftBackLeg = this.body.method_32086("leftBackLeg");
        this.rightBackLeg = this.body.method_32086("rightBackLeg");
        this.rightFrontLeg = this.body.method_32086("rightFrontLeg");
        this.tail = this.body.method_32086("tail");
        this.head = root.method_32086("head");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 body = modelPartData.method_32117("body", class_5606.method_32108(), class_5603.method_32090(0.0F, 19.0F, 0.0F));

        class_5610 main_r1 = body.method_32117("main_r1", class_5606.method_32108().method_32101(0, 0).method_32098(-4.0F, -5.0F, -7.5F, 7.0F, 6.0F, 12.0F, new class_5605(0.0F)), class_5603.method_32091(0.5F, 1.0F, 0.5F, 0.1745F, 0.0F, 0.0F));

        class_5610 leftFrontLeg = body.method_32117("leftFrontLeg", class_5606.method_32108().method_32101(0, 33).method_32098(-1.0F, -2.0F, -1.0F, 2.0F, 5.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32090(2.0F, 2.0F, -5.0F));

        class_5610 leftBackLeg = body.method_32117("leftBackLeg", class_5606.method_32108().method_32101(30, 27).method_32098(-1.0F, -1.0F, -1.0F, 2.0F, 5.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32090(2.0F, 1.0F, 3.0F));

        class_5610 rightBackLeg = body.method_32117("rightBackLeg", class_5606.method_32108().method_32101(0, 18).method_32098(-1.0F, -1.0F, -1.0F, 2.0F, 5.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32090(-2.0F, 1.0F, 3.0F));

        class_5610 rightFrontLeg = body.method_32117("rightFrontLeg", class_5606.method_32108().method_32101(0, 4).method_32098(-1.0F, -2.0F, -1.0F, 2.0F, 5.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32090(-2.0F, 2.0F, -5.0F));

        class_5610 tail = body.method_32117("tail", class_5606.method_32108().method_32101(0, 18).method_32098(-1.5F, -1.75F, 0.0F, 3.0F, 3.0F, 12.0F, new class_5605(0.0F))
                .method_32101(26, 0).method_32098(-1.5F, 1.25F, 5.0F, 3.0F, 3.0F, 7.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, -2.0F, 4.0F));

        class_5610 head = modelPartData.method_32117("head", class_5606.method_32108().method_32101(18, 18).method_32098(-3.0F, -2.0F, -5.0F, 6.0F, 4.0F, 5.0F, new class_5605(0.0F))
                .method_32101(8, 6).method_32098(2.0F, -3.0F, -1.5F, 2.0F, 2.0F, 0.0F, new class_5605(0.0F))
                .method_32101(6, 4).method_32098(-4.0F, -3.0F, -1.5F, 2.0F, 2.0F, 0.0F, new class_5605(0.0F))
                .method_32101(0, 0).method_32098(-2.0F, 0.0F, -7.0F, 4.0F, 2.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, 16.75F, -7.0F));
        return class_5607.method_32110(modelData, 64, 64);
    }

    @Override
    protected Iterable<class_630> method_22946() {
        return ImmutableList.of(this.head);
    }

    @Override
    protected Iterable<class_630> method_22948() {
        return ImmutableList.of(this.body);
    }

    @Override
    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
//        this.root. = 10f;
        this.head.field_3654 = headPitch * 0.010453292F;
        this.head.field_3675 = headYaw * 0.010453292F;

        this.leftFrontLeg.field_3654 = class_3532.method_15362(limbAngle * 0.6662F) * 1.4F * limbDistance;
        this.rightFrontLeg.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 1.4F * limbDistance;
        this.leftBackLeg.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + 3.1415927F) * 1.4F * limbDistance;
        this.rightBackLeg.field_3654 = class_3532.method_15362(limbAngle * 0.6662F) * 1.4F * limbDistance;
    }

}
