package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;

import net.adventurez.entity.TheEyeEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4595;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(EnvType.CLIENT)
public class TheEyeModel<T extends TheEyeEntity> extends class_4595<T> {
    private final class_630 middle;
    private final class_630 leftSite;
    private final class_630 rightSite;

    public TheEyeModel(class_630 root) {
        this.middle = root.method_32086("middle");
        this.leftSite = root.method_32086("leftSite");
        this.rightSite = root.method_32086("rightSite");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        modelPartData.method_32117("middle", class_5606.method_32108().method_32101(0, 0).method_32097(-1.5F, -6.0F, -1.0F, 3.0F, 13.0F, 2.0F), class_5603.method_32090(0.0F, 15.0F, 0.0F));
        modelPartData.method_32117("leftSite", class_5606.method_32108().method_32101(10, 10).method_32097(-3.5F, -5.0F, -1.0F, 2.0F, 11.0F, 2.0F).method_32101(18, 18).method_32097(-4.5F, -4.0F, -1.0F, 1.0F, 9.0F, 2.0F).method_32101(10, 0)
                .method_32097(-5.5F, -3.0F, -1.0F, 1.0F, 7.0F, 2.0F).method_32101(8, 23).method_32097(-6.5F, -1.0F, -1.0F, 1.0F, 3.0F, 2.0F), class_5603.method_32090(0.0F, 15.0F, 0.0F));
        modelPartData.method_32117("rightSite", class_5606.method_32108().method_32101(0, 15).method_32097(1.5F, -5.0F, -1.0F, 2.0F, 11.0F, 2.0F).method_32101(16, 0).method_32097(3.5F, -4.0F, -1.0F, 1.0F, 9.0F, 2.0F).method_32101(20, 9)
                .method_32097(4.5F, -3.0F, -1.0F, 1.0F, 7.0F, 2.0F).method_32101(22, 0).method_32097(5.5F, -1.0F, -1.0F, 1.0F, 3.0F, 2.0F), class_5603.method_32090(0.0F, 15.0F, 0.0F));
        return class_5607.method_32110(modelData, 32, 32);
    }

    @Override
    public Iterable<class_630> method_22960() {
        return ImmutableList.of(this.middle, this.leftSite, this.rightSite);
    }

    @Override
    public void setAngles(T eye, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.middle.field_3654 = headPitch * 0.017453292F;
        this.leftSite.field_3654 = headPitch * 0.017453292F;
        this.rightSite.field_3654 = headPitch * 0.017453292F;
        // Split

        if (eye.method_6032() < (eye.method_6063() / 3.0F) && !(eye.method_5841().method_12789(TheEyeEntity.INVUL_TIMER) > 0)) {
            this.leftSite.field_3657 = -1.0F;
            this.rightSite.field_3657 = 1.0F;
        } else {
            this.leftSite.field_3657 = 0F;
            this.rightSite.field_3657 = 0F;
        }

    }

}
