package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;

import net.adventurez.entity.VoidShadowEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4595;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(EnvType.CLIENT)
public class VoidShadowModel<T extends VoidShadowEntity> extends class_4595<T> {

    private final class_630 rightArm;
    private final class_630 leftArm;
    private final class_630 body;
    private final class_630 rightParticle;
    private final class_630 bone;
    private final class_630 bone2;
    private final class_630 bone3;
    private final class_630 bone4;
    private final class_630 bone5;
    private final class_630 bone6;
    private final class_630 bone7;
    private final class_630 leftParticle;
    private final class_630 bone8;
    private final class_630 bone9;
    private final class_630 bone10;
    private final class_630 bone11;
    private final class_630 bone12;

    private float throwingBlocksTicker;

    public VoidShadowModel(class_630 root) {
        this.rightArm = root.method_32086("rightArm");
        this.leftArm = root.method_32086("leftArm");
        this.body = root.method_32086("body");
        this.leftParticle = this.body.method_32086("leftParticle");
        this.bone12 = this.leftParticle.method_32086("bone12");
        this.bone11 = this.leftParticle.method_32086("bone11");
        this.bone10 = this.leftParticle.method_32086("bone10");
        this.bone9 = this.leftParticle.method_32086("bone9");
        this.bone8 = this.leftParticle.method_32086("bone8");
        this.rightParticle = this.body.method_32086("rightParticle");
        this.bone7 = this.rightParticle.method_32086("bone7");
        this.bone6 = this.rightParticle.method_32086("bone6");
        this.bone5 = this.rightParticle.method_32086("bone5");
        this.bone4 = this.rightParticle.method_32086("bone4");
        this.bone3 = this.rightParticle.method_32086("bone3");
        this.bone2 = this.rightParticle.method_32086("bone2");
        this.bone = this.rightParticle.method_32086("bone");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        modelPartData.method_32117("rightArm",
                class_5606.method_32108().method_32101(44, 58).method_32097(1.0F, 6.0F, -2.0F, 2.0F, 2.0F, 4.0F).method_32101(0, 50).method_32097(-3.0F, 8.0F, -2.0F, 6.0F, 2.0F, 4.0F).method_32101(20, 62)
                        .method_32097(-1.0F, 8.0F, -4.0F, 4.0F, 2.0F, 2.0F).method_32101(0, 20).method_32097(-1.0F, 14.0F, -4.0F, 2.0F, 2.0F, 2.0F).method_32101(0, 16).method_32097(-1.0F, 14.0F, 2.0F, 2.0F, 2.0F, 2.0F).method_32101(8, 62)
                        .method_32097(-1.0F, 8.0F, 2.0F, 4.0F, 2.0F, 2.0F).method_32101(0, 28).method_32097(-1.0F, 10.0F, -4.0F, 6.0F, 4.0F, 8.0F).method_32101(48, 28).method_32097(-3.0F, 14.0F, -2.0F, 6.0F, 2.0F, 4.0F).method_32101(32, 58)
                        .method_32097(1.0F, 16.0F, -2.0F, 2.0F, 2.0F, 4.0F).method_32101(24, 56).method_32097(-3.0F, 16.0F, -2.0F, 2.0F, 2.0F, 4.0F).method_32101(0, 56).method_32097(-1.0F, 18.0F, -2.0F, 2.0F, 2.0F, 4.0F).method_32101(12, 56)
                        .method_32097(-5.0F, 18.0F, -2.0F, 2.0F, 2.0F, 4.0F).method_32101(26, 16).method_32097(-5.0F, 10.0F, -2.0F, 2.0F, 2.0F, 2.0F),
                class_5603.method_32090(11.0F, 1.0F, 0.0F));
        modelPartData.method_32117("leftArm",
                class_5606.method_32108().method_32101(26, 20).method_32097(3.0F, 10.0F, -2.0F, 2.0F, 2.0F, 2.0F).method_32101(36, 52).method_32097(-3.0F, 8.0F, -2.0F, 6.0F, 2.0F, 4.0F).method_32101(60, 60)
                        .method_32097(-3.0F, 8.0F, 2.0F, 4.0F, 2.0F, 2.0F).method_32101(16, 40).method_32097(-3.0F, 8.0F, -4.0F, 4.0F, 2.0F, 2.0F).method_32101(0, 4).method_32097(-1.0F, 14.0F, -4.0F, 2.0F, 2.0F, 2.0F).method_32101(0, 0)
                        .method_32097(-1.0F, 14.0F, 2.0F, 2.0F, 2.0F, 2.0F).method_32101(0, 62).method_32097(-5.0F, 6.0F, -2.0F, 2.0F, 2.0F, 4.0F).method_32101(28, 28).method_32097(-5.0F, 10.0F, -4.0F, 6.0F, 4.0F, 8.0F).method_32101(60, 34)
                        .method_32097(1.0F, 16.0F, -2.0F, 2.0F, 2.0F, 4.0F).method_32101(52, 60).method_32097(-1.0F, 18.0F, -2.0F, 2.0F, 2.0F, 4.0F).method_32101(58, 44).method_32097(-3.0F, 16.0F, -2.0F, 2.0F, 2.0F, 4.0F).method_32101(20, 50)
                        .method_32097(-3.0F, 14.0F, -2.0F, 6.0F, 2.0F, 4.0F).method_32101(58, 0).method_32097(3.0F, 18.0F, -2.0F, 2.0F, 2.0F, 4.0F),
                class_5603.method_32090(-11.0F, 1.0F, 0.0F));
        class_5610 modelPartData1 = modelPartData.method_32117("body",
                class_5606.method_32108().method_32101(26, 16).method_32097(-6.0F, -11.0F, -4.0F, 6.0F, 2.0F, 8.0F).method_32101(0, 40).method_32097(2.0F, -11.0F, -4.0F, 4.0F, 2.0F, 8.0F).method_32101(50, 34)
                        .method_32097(-8.0F, -9.0F, -3.0F, 2.0F, 4.0F, 6.0F).method_32101(20, 28).method_32097(8.0F, -9.0F, -3.0F, 2.0F, 2.0F, 6.0F).method_32101(0, 0).method_32097(-6.0F, -9.0F, -5.0F, 14.0F, 6.0F, 10.0F).method_32101(0, 16)
                        .method_32097(-4.0F, -3.0F, -5.0F, 8.0F, 2.0F, 10.0F).method_32101(38, 0).method_32097(-2.0F, -1.0F, -4.0F, 6.0F, 2.0F, 8.0F).method_32101(42, 44).method_32097(-2.0F, 1.0F, -3.0F, 5.0F, 2.0F, 6.0F).method_32101(46, 10)
                        .method_32097(-1.0F, 3.0F, -3.0F, 5.0F, 2.0F, 6.0F).method_32101(48, 20).method_32097(-2.0F, 5.0F, -3.0F, 4.0F, 2.0F, 6.0F).method_32101(24, 40).method_32097(-4.0F, 7.0F, -2.0F, 8.0F, 6.0F, 4.0F).method_32101(52, 54)
                        .method_32097(-2.0F, 13.0F, -2.0F, 4.0F, 2.0F, 4.0F),
                class_5603.method_32090(0.0F, 8.0F, 0.0F));
        class_5610 modelPartData2 = modelPartData1.method_32117("rightParticle", class_5606.method_32108(), class_5603.method_32090(8.0F, -9.0F, 0.0F));
        modelPartData2.method_32117("bone", class_5606.method_32108().method_32101(40, 58).method_32097(12.0F, -22.0F, -2.0F, 2.0F, 2.0F, 2.0F), class_5603.method_32090(-8.0F, 24.0F, 0.0F));
        modelPartData2.method_32117("bone2", class_5606.method_32108().method_32101(8, 56).method_32097(10.0F, -26.0F, 0.0F, 2.0F, 2.0F, 2.0F), class_5603.method_32090(-8.0F, 24.0F, 0.0F));
        modelPartData2.method_32117("bone3", class_5606.method_32108().method_32101(20, 56).method_32097(8.0F, -28.0F, -2.0F, 2.0F, 2.0F, 2.0F), class_5603.method_32090(-8.0F, 24.0F, 0.0F));
        modelPartData2.method_32117("bone4", class_5606.method_32108().method_32101(46, 18).method_32097(14.0F, -28.0F, -2.0F, 2.0F, 2.0F, 2.0F), class_5603.method_32090(-8.0F, 24.0F, 0.0F));
        modelPartData2.method_32117("bone5", class_5606.method_32108().method_32101(62, 10).method_32097(8.0F, -18.0F, 0.0F, 2.0F, 2.0F, 2.0F), class_5603.method_32090(-8.0F, 24.0F, 0.0F));
        modelPartData2.method_32117("bone6", class_5606.method_32108().method_32101(16, 50).method_32097(10.0F, -30.0F, 0.0F, 2.0F, 2.0F, 2.0F), class_5603.method_32090(-8.0F, 24.0F, 0.0F));
        modelPartData2.method_32117("bone7", class_5606.method_32108().method_32101(16, 44).method_32097(4.0F, -28.0F, -2.0F, 2.0F, 2.0F, 2.0F), class_5603.method_32090(-8.0F, 24.0F, 0.0F));
        class_5610 modelPartData3 = modelPartData1.method_32117("leftParticle", class_5606.method_32108(), class_5603.method_32090(-6.0F, -9.0F, 0.0F));
        modelPartData3.method_32117("bone8", class_5606.method_32108().method_32101(0, 44).method_32097(-4.0F, -28.0F, -2.0F, 2.0F, 2.0F, 2.0F), class_5603.method_32090(6.0F, 24.0F, 0.0F));
        modelPartData3.method_32117("bone9", class_5606.method_32108().method_32101(0, 40).method_32097(-2.0F, -30.0F, 0.0F, 2.0F, 2.0F, 2.0F), class_5603.method_32090(6.0F, 24.0F, 0.0F));
        modelPartData3.method_32117("bone10", class_5606.method_32108().method_32101(38, 4).method_32097(-8.0F, -28.0F, -2.0F, 2.0F, 2.0F, 2.0F), class_5603.method_32090(6.0F, 24.0F, 0.0F));
        modelPartData3.method_32117("bone11", class_5606.method_32108().method_32101(0, 32).method_32097(-12.0F, -24.0F, 0.0F, 2.0F, 2.0F, 2.0F), class_5603.method_32090(6.0F, 24.0F, 0.0F));
        modelPartData3.method_32117("bone12", class_5606.method_32108().method_32101(0, 28).method_32097(-12.0F, -18.0F, 0.0F, 2.0F, 2.0F, 2.0F), class_5603.method_32090(6.0F, 24.0F, 0.0F));
        modelPartData3.method_32117("bone13", class_5606.method_32108().method_32101(38, 0).method_32097(-15.0F, -30.0F, 0.0F, 2.0F, 2.0F, 2.0F), class_5603.method_32090(6.0F, 24.0F, 0.0F));
        return class_5607.method_32110(modelData, 128, 128);
    }

    @Override
    public Iterable<class_630> method_22960() {
        return ImmutableList.of(this.rightArm, this.leftArm, this.body);
    }

    @Override
    public void setAngles(T shadow, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {

        this.body.field_3656 = 8.0F + class_3532.method_15374(animationProgress / 12.5663706F) / 2.0F;
        this.rightArm.field_3656 = 1.0F + class_3532.method_15374(animationProgress / 12.5663706F) / 1.5F;
        this.leftArm.field_3656 = 1.0F + class_3532.method_15374(animationProgress / 12.5663706F) / 1.5F;
        this.bone.field_3656 = 24F + class_3532.method_15362(2.6F + animationProgress / 12.5663706F) / 1.1F;
        this.bone2.field_3656 = 24F + class_3532.method_15374(2.4F + animationProgress / 12.5663706F) / 1.3F;
        this.bone3.field_3656 = 24F + class_3532.method_15362(2.2F + animationProgress / 12.5663706F) / 1.45F;
        this.bone4.field_3656 = 24F + class_3532.method_15374(2.0F + animationProgress / 12.5663706F) / 1.6F;
        this.bone5.field_3656 = 24F + class_3532.method_15362(1.8F + animationProgress / 12.5663706F) / 1.25F;
        this.bone6.field_3656 = 24F + class_3532.method_15362(1.6F + animationProgress / 12.5663706F) / 1.4F;
        this.bone7.field_3656 = 24F + class_3532.method_15374(1.4F + animationProgress / 12.5663706F);
        this.bone8.field_3656 = 24F + class_3532.method_15374(1.2F + animationProgress / 12.5663706F) / 1.25F;
        this.bone9.field_3656 = 24F + class_3532.method_15362(1.0F + animationProgress / 12.5663706F) / 1.35F;
        this.bone10.field_3656 = 24F + class_3532.method_15362(0.8F + animationProgress / 12.5663706F) / 1.2F;
        this.bone11.field_3656 = 24F + class_3532.method_15374(0.6F + animationProgress / 12.5663706F) / 0.9F;
        this.bone12.field_3656 = 24F + class_3532.method_15362(0.4F + animationProgress / 12.5663706F) / 1.15F;
        this.rightArm.field_3674 = 0.0F;
        this.leftArm.field_3674 = 0.0F;

        if (shadow.method_5841().method_12789(VoidShadowEntity.IS_THROWING_BLOCKS)) {
            throwingBlocksTicker = class_3532.method_15363(throwingBlocksTicker + 0.05817666666666F, 0.0F, 1.7453F);
        } else {
            throwingBlocksTicker = class_3532.method_15363(throwingBlocksTicker - 0.05817666666666F, 0.0F, 1.7453F);
        }

        this.rightArm.field_3654 = -throwingBlocksTicker;
        this.leftArm.field_3654 = this.rightArm.field_3654;
        this.rightArm.field_3675 = -throwingBlocksTicker * 0.20002291869F;
        this.leftArm.field_3675 = throwingBlocksTicker * 0.20002291869F;

        if (shadow.method_5841().method_12789(VoidShadowEntity.HOVERING_MAGIC_HANDS)) {
            this.rightArm.field_3674 = -2.4871F - class_3532.method_15362(animationProgress * 0.3662F) * 0.1F;
            this.leftArm.field_3674 = 2.4871F + class_3532.method_15362(animationProgress * 0.3662F) * 0.1F;
            this.rightArm.field_3654 = -class_3532.method_15362(animationProgress * 0.1662F) * 0.25F;
            this.leftArm.field_3654 = class_3532.method_15362(animationProgress * 0.1662F) * 0.25F;
            // this.rightAttackingArm.pitch = MathHelper.cos(animationProgress * 0.6662F) *
            // 0.25F;
            // this.leftAttackingArm.pitch = MathHelper.cos(animationProgress * 0.6662F) *
            // 0.25F;
        } else if (shadow.method_5841().method_12789(VoidShadowEntity.CIRCLING_HANDS)) {
            this.rightArm.field_3674 = -1.5708F;
            this.leftArm.field_3674 = 1.5708F;
        }

        // this.rightArm.pitch = this.handSwingProgress;

        // Summon attack or change block attack
        // setRotationAngle(leftArm, 0.0F, 0.0F, 2.4871F);
        // setRotationAngle(rightArm, 0.0F, 0.0F, -2.4871F);

        // Throw blocks attack needs floatings
        // setRotationAngle(rightArm, -1.7453F, -0.3491F, 0.0F);
        // setRotationAngle(leftArm, -1.7453F, 0.3491F, 0.0F);
        // 0,011636666666
    }

}
