package net.adventurez.entity.nonliving;

import net.adventurez.init.EntityInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1668;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4770;

public class FireBreathEntity extends class_1668 {

    private int removeTicker;

    public FireBreathEntity(class_1299<? extends class_1668> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Environment(EnvType.CLIENT)
    public FireBreathEntity(class_1937 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        this(EntityInit.FIRE_BREATH, world);
        this.method_5808(x, y, z, this.method_36454(), this.method_36455());
        this.method_18800(velocityX, velocityY, velocityZ);
    }

    public FireBreathEntity(class_1937 world, class_1309 owner, class_243 velocity) {
        super(EntityInit.FIRE_BREATH, owner, velocity, world);
        class_243 newVec3d = this.method_18798().method_1029().method_1031(this.field_5974.method_43059() * 0.1D, -this.field_5974.method_43058() * 0.1D, this.field_5974.method_43059() * 0.1D);
        this.method_18799(newVec3d);
    }

    @Override
    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    @Override
    protected class_2394 method_7467() {
        return new class_2388(class_2398.field_11217, class_2246.field_10124.method_9564());
    }

    @Override
    protected float method_7466() {
        return 0.9F;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            for (int i = 0; i < 10; i++) {
                double d = (double) this.method_37908().method_8409().method_43059() * 0.01D;
                double e = (double) this.method_37908().method_8409().method_43059() * 0.01D;
                double f = (double) this.method_37908().method_8409().method_43059() * 0.01D;
                this.method_37908().method_8406(class_2398.field_11240, this.method_23322(1.0D), this.method_23319(), this.method_23325(1.0D), d, e, f);
            }
        } else {
            removeTicker++;
            if (removeTicker >= 80)
                this.method_31472();
        }
    }

    @Override
    public boolean method_5809() {
        return false;
    }

    @Environment(EnvType.CLIENT)
    public boolean method_5640(double distance) {
        return distance < 16384.0D;
    }

    @Override
    public float method_5718() {
        return 1.0F;
    }

    @Override
    public void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        class_1297 entity = this.method_24921();
        class_1297 hittedEntity = entityHitResult.method_17782();
        if (!this.method_37908().method_8608() && entity != null && hittedEntity instanceof class_1309) {
            hittedEntity.method_5639(8);
            hittedEntity.method_5643(createDamageSource(this), 3.0F);
            this.method_31472();
        }

    }

    private class_1282 createDamageSource(class_1297 entity) {
        return entity.method_48923().method_48796(EntityInit.FIRE_BREATH_KEY, entity);
    }

    @Override
    public void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        if (!this.method_37908().method_8608()) {
            class_1297 entity = this.method_24921();
            if (entity == null || !(entity instanceof class_1308) || this.method_37908().method_8450().method_8355(class_1928.field_19388)) {
                class_2338 blockPos = blockHitResult.method_17777().method_10093(blockHitResult.method_17780());
                if (this.method_37908().method_22347(blockPos)) {
                    this.method_37908().method_8501(blockPos, class_4770.method_24416(this.method_37908(), blockPos));
                }
            }
            this.method_31472();
        }
    }

}
