package net.adventurez.entity.nonliving;

import net.adventurez.init.EffectInit;
import net.adventurez.init.EntityInit;
import net.adventurez.init.SoundInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3857;
import net.minecraft.class_3966;

@SuppressWarnings("deprecation")
public class ThrownRockEntity extends class_3857 {

    public ThrownRockEntity(class_1299<? extends ThrownRockEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public ThrownRockEntity(class_1937 world, class_1309 owner) {
        super(EntityInit.THROWN_ROCK, owner, world);
    }

    public ThrownRockEntity(class_1937 world, double x, double y, double z) {
        super(EntityInit.THROWN_ROCK, x, y, z, world);
    }

    @Override
    public class_1792 method_16942() {
        return class_1802.field_23843;
    }

    // getLandingBlockState found at addSoulSpeedBoostIfNeeded in LivingEntity
    @Environment(EnvType.CLIENT)
    private class_2394 getParticleParameters() {
        class_2680 state = this.method_43261();
        return new class_2388(class_2398.field_11217, state);
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void method_5711(byte status) {
        if (status == 3) {
            class_2394 particleEffect = this.getParticleParameters();
            for (int i = 0; i < 32; ++i)
                this.method_37908().method_8406(particleEffect, this.method_23317() + this.method_37908().method_8409().method_43058() * 0.35D - 0.175D, this.method_23318(),
                        this.method_23321() + this.method_37908().method_8409().method_43058() * 0.35D - 0.175D, 0.0D, 0.1D, 0.0D);
        }

    }

    @Override
    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        class_2680 state = this.method_43261();
        if (this.method_37908().method_8608()) {
            for (int i = 0; i < 32; ++i)
                this.method_37908().method_8406(new class_2388(class_2398.field_11217, state), this.method_23317() + this.method_37908().method_8409().method_43058() * 0.35D - 0.175D, this.method_23318(),
                        this.method_23321() + this.method_37908().method_8409().method_43058() * 0.35D - 0.175D, 0.0D, 0.1D, 0.0D);
        } else {
            if (this.method_24921() instanceof class_1657 playerEntity && playerEntity.method_6059(EffectInit.BLACKSTONED_HEART)) {
                this.method_37908().method_8537(this, this.method_23317(), this.method_23320(), this.method_23321(), 1.5F, false, class_1937.class_7867.field_40890);
            }
            this.method_37908().method_8396(null, this.method_24515(), SoundInit.ROCK_IMPACT_EVENT, class_3419.field_15245, 0.7F, 1F);
            this.method_37908().method_8421(this, (byte) 3);
            this.method_31472();
        }
    }

    // Causes crash if not overridden, maybe due to getStack client?
    // @Override
    // public ItemStack getStack() {
    // // super.getStack()
    // ItemStack itemStack = this.getStack();
    // return itemStack.isEmpty() ? new ItemStack(this.getDefaultItem()) : itemStack;
    // }

    @Override
    protected void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        if (!this.method_37908().method_8608()) {
            class_1297 entity = entityHitResult.method_17782();
            class_1297 owner = this.method_24921();
            class_1282 damageSource = createDamageSource(this, owner == null ? this : owner);
            if (owner instanceof class_1309 livingEntity) {
                if (entity.method_5643(damageSource, 16F)) {
                    if (entity instanceof class_1309 livingEntity2) {
                        livingEntity.method_6114(livingEntity2);
                    }
                }
            }
            if (entity instanceof class_1309 livingEntity) {
                int slownessAddition = 400;

                if (this.method_7495().method_7909() == this.method_16942()) {
                    livingEntity.method_6092(new class_1293(class_1294.field_5901, 2000, 2));
                    slownessAddition = 200;
                }
                livingEntity.method_6092(new class_1293(class_1294.field_5919, 50, 0));
                livingEntity.method_6092(new class_1293(class_1294.field_5909, slownessAddition, slownessAddition / 200 - 1));
                livingEntity.method_6092(new class_1293(class_1294.field_5903, 600, 1));
            }

        }
    }

    private class_1282 createDamageSource(class_1297 entity, class_1297 owner) {
        return entity.method_48923().method_48797(EntityInit.ROCK_KEY, entity, owner);
    }

}
