package net.adventurez.entity.nonliving;

import java.util.UUID;

import net.adventurez.init.EntityInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1317;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1668;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2902;
import net.minecraft.class_2945.class_9222;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public class TinyEyeEntity extends class_1668 {

    private class_1297 target;
    @Nullable
    private class_2350 direction;
    private int stepCount;
    private double targetX;
    private double targetY;
    private double targetZ;
    @Nullable
    private UUID targetUuid;

    public TinyEyeEntity(class_1299<? extends TinyEyeEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Environment(EnvType.CLIENT)
    public TinyEyeEntity(class_1937 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        this(EntityInit.TINY_EYE, world);
        this.method_5808(x, y, z, this.method_36454(), this.method_36455());
        this.method_18800(velocityX, velocityY, velocityZ);
    }

    public TinyEyeEntity(class_1937 world, class_1309 owner, class_1297 target, class_2350.class_2351 axis) {
        this(EntityInit.TINY_EYE, world);
        this.method_7432(owner);
        class_2338 blockPos = owner.method_24515();
        double d = (double) blockPos.method_10263() + 0.5D;
        double e = (double) blockPos.method_10264() + 0.5D;
        double f = (double) blockPos.method_10260() + 0.5D;
        this.method_5808(d, e, f, this.method_36454(), this.method_36455());
        this.target = target;
        this.direction = class_2350.field_11036;
        this.movingAround();
    }

    @Override
    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        if (this.target != null)
            tag.method_25927("Target", this.target.method_5667());
        if (this.direction != null)
            tag.method_10569("Dir", this.direction.method_10146());

        tag.method_10569("Steps", this.stepCount);
        tag.method_10549("TXD", this.targetX);
        tag.method_10549("TYD", this.targetY);
        tag.method_10549("TZD", this.targetZ);
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.stepCount = tag.method_10550("Steps");
        this.targetX = tag.method_10574("TXD");
        this.targetY = tag.method_10574("TYD");
        this.targetZ = tag.method_10574("TZD");
        if (tag.method_10573("Dir", 99))
            this.direction = class_2350.method_10143(tag.method_10550("Dir"));

        if (tag.method_25928("Target"))
            this.targetUuid = tag.method_25926("Target");

    }

    @Override
    protected void method_5693(class_9222 builder) {
    }

    private void movingAround() {
        double d = 0.5D;
        class_2338 blockPos;
        if (this.target == null)
            blockPos = this.method_24515().method_10074();
        else {
            d = (double) this.target.method_17682() * 0.5D;
            blockPos = class_2338.method_49637(this.target.method_23317(), this.target.method_23318() + d, this.target.method_23321());
        }

        double e = (double) blockPos.method_10263() + 0.5D;
        double f = (double) blockPos.method_10264() + d;
        double g = (double) blockPos.method_10260() + 0.5D;
        double h = e - this.method_23317();
        double j = f - this.method_23318();
        double k = g - this.method_23321();
        double l = (double) class_3532.method_15355((float) (h * h + j * j + k * k));
        if (l == 0.0D) {
            this.targetX = 0.0D;
            this.targetY = 0.0D;
            this.targetZ = 0.0D;
        } else {
            this.targetX = h / l * 0.15D;
            this.targetY = j / l * 0.15D;
            this.targetZ = k / l * 0.15D;
        }

        this.field_6007 = true;
        this.stepCount = 10 + this.field_5974.method_43048(5) * 10;
    }

    @Override
    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801)
            this.method_31472();
    }

    @Override
    public void method_5773() {
        class_243 vec3d;
        if (!this.method_37908().method_8608()) {
            if (this.target == null && this.targetUuid != null) {
                this.target = ((class_3218) this.method_37908()).method_14190(this.targetUuid);
                if (this.target == null) {
                    this.targetUuid = null;
                }
            }

            if (this.target == null || !this.target.method_5805() || this.target instanceof class_1657 && ((class_1657) this.target).method_7325()) {
                if (!this.method_5740()) {
                    this.method_18799(this.method_18798().method_1031(0.0D, -0.04D, 0.0D));
                }
            } else {
                this.targetX = class_3532.method_15350(this.targetX * 1.025D, -1.0D, 1.0D);
                this.targetY = class_3532.method_15350(this.targetY * 1.025D, -1.0D, 1.0D);
                this.targetZ = class_3532.method_15350(this.targetZ * 1.025D, -1.0D, 1.0D);
                vec3d = this.method_18798();
                this.method_18799(vec3d.method_1031((this.targetX - vec3d.field_1352) * 0.2D, (this.targetY - vec3d.field_1351) * 0.2D, (this.targetZ - vec3d.field_1350) * 0.2D));
            }

            class_239 hitResult = class_1675.method_49997(this, this::method_26958);
            if (hitResult.method_17783() != class_239.class_240.field_1333) {
                this.method_7488(hitResult);
            }
        }

        this.method_5852();
        vec3d = this.method_18798();
        this.method_30634(this.method_23317() + vec3d.field_1352, this.method_23318() + vec3d.field_1351, this.method_23321() + vec3d.field_1350);
        class_1675.method_7484(this, 0.5F);
        if (this.method_37908().method_8608()) {
        } else if (this.target != null && !this.target.method_31481()) {
            if (this.stepCount > 0) {
                --this.stepCount;
                if (this.stepCount == 0) {
                    this.movingAround();
                }
            }

            if (this.direction != null) {
                class_2338 blockPos = this.method_24515();
                class_2350.class_2351 axis = this.direction.method_10166();
                if (this.method_37908().method_8515(blockPos.method_10093(this.direction), this)) {
                    this.movingAround();
                } else {
                    class_2338 blockPos2 = this.target.method_24515();
                    if (axis == class_2350.class_2351.field_11048 && blockPos.method_10263() == blockPos2.method_10263() || axis == class_2350.class_2351.field_11051 && blockPos.method_10260() == blockPos2.method_10260()
                            || axis == class_2350.class_2351.field_11052 && blockPos.method_10264() == blockPos2.method_10264()) {
                        this.movingAround();
                    }
                }
            }
        }

    }

    @Override
    public boolean method_26958(class_1297 entity) {
        return super.method_26958(entity) && !entity.field_5960;
    }

    @Override
    public boolean method_5809() {
        return false;
    }

    @Environment(EnvType.CLIENT)
    public boolean method_5640(double distance) {
        return distance < 16384.0D;
    }

    @Override
    public float method_5718() {
        return 1.0F;
    }

    @Override
    public void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        class_1297 entity = this.method_24921();
        class_1297 hittedEntity = entityHitResult.method_17782();
        if (!this.method_37908().method_8608() && entity != null && hittedEntity != entity && !(hittedEntity instanceof TinyEyeEntity) || hittedEntity instanceof class_1667) {
            this.method_5783(class_3417.field_15210, 1.0F, 1.0F);
            if (hittedEntity instanceof class_1309) {
                this.teleportEntityRandom((class_1309) hittedEntity);
                hittedEntity.method_5643(createDamageSource(this), 3.0F);
            }
            this.method_31472();
        }

    }

    private class_1282 createDamageSource(class_1297 entity) {
        return entity.method_48923().method_48796(EntityInit.TINY_EYE_KEY, entity);
    }

    @SuppressWarnings("deprecation")
    private void teleportEntityRandom(class_1309 livingEntity) {
        if (!livingEntity.method_37908().method_8608() && livingEntity.method_37908() instanceof class_3218 serverWorld) {
            for (int counter = 0; counter < 100; counter++) {
                float randomFloat = this.method_37908().method_8409().method_43057() * 6.2831855F;
                int posX = livingEntity.method_24515().method_10263() + class_3532.method_15375(class_3532.method_15362(randomFloat) * 9.0F + serverWorld.method_8409().method_43048(30));
                int posZ = livingEntity.method_24515().method_10260() + class_3532.method_15375(class_3532.method_15374(randomFloat) * 9.0F + serverWorld.method_8409().method_43048(30));
                int posY = serverWorld.method_8624(class_2902.class_2903.field_13202, posX, posZ);
                class_2338 teleportPos = new class_2338(posX, posY, posZ);
                if (serverWorld.method_22341(teleportPos.method_10263() - 4, teleportPos.method_10264() - 4, teleportPos.method_10260() - 4, teleportPos.method_10263() + 4, teleportPos.method_10264() + 4, teleportPos.method_10260() + 4)
                        && class_1317.method_20638(class_1299.field_6097, serverWorld, class_3730.field_16467, teleportPos, serverWorld.method_8409())) {
                    if (!this.method_37908().method_8608()) {
                        livingEntity.method_6082(teleportPos.method_10263(), teleportPos.method_10264(), teleportPos.method_10260(), false);
                    }

                    serverWorld.method_47967(null, posX, posY, posZ, class_3417.field_14879, class_3419.field_15251, 1.0f, 1.0f, serverWorld.method_8409().method_43055());
                    break;
                }
            }
        }
    }

    @Override
    public void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        this.method_5783(class_3417.field_15210, 1.0F, 1.0F);
        if (!this.method_37908().method_8608())
            this.method_31472();
    }

    @Override
    public void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
    }

}
