package net.adventurez.entity.nonliving;

import net.adventurez.entity.VoidShadeEntity;
import net.adventurez.init.EntityInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1668;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class VoidBulletEntity extends class_1668 {

    private int removeTicker;

    public VoidBulletEntity(class_1299<? extends class_1668> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Environment(EnvType.CLIENT)
    public VoidBulletEntity(class_1937 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        this(EntityInit.VOID_BULLET, world);
        this.method_5808(x, y, z, this.method_36454(), this.method_36455());
        this.method_18800(velocityX, velocityY, velocityZ);
    }

    public VoidBulletEntity(class_1309 owner, class_243 velocity, class_1937 world) {
        super(EntityInit.VOID_BULLET, owner, velocity, world);
        this.method_5808(owner.method_23317() + velocity.method_10216() * 1.2D, owner.method_23318() + owner.method_5829().method_17940() * 0.6D + velocity.method_10214() * 1.2D, owner.method_23321() + velocity.method_10215() * 1.2D,
                -owner.method_36454(), owner.method_36455());
        this.field_6004 = owner.method_36455();
        this.method_36456(-owner.method_36454());
        this.field_51893 = 0.32D;
    }

    @Override
    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    @Override
    protected class_2394 method_7467() {
        return new class_2388(class_2398.field_11217, class_2246.field_10124.method_9564());
    }

    @Override
    protected float method_7466() {
        return 0.7F;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.removeTicker++;
        if (this.method_37908().method_8608()) {
            if (this.removeTicker > 75)
                for (int i = 0; i < 20; i++) {
                    double d = (double) this.method_19538().method_10216() + 0.3F * this.method_37908().method_8409().method_43057();
                    double e = (double) ((float) this.method_19538().method_10214() + this.method_37908().method_8409().method_43057() * 0.3F);
                    double f = (double) this.method_19538().method_10215() + 0.3F * this.method_37908().method_8409().method_43057();
                    double g = (double) (this.method_37908().method_8409().method_43057() * 0.2D);
                    double h = (double) this.method_37908().method_8409().method_43057() * 0.2D;
                    double l = (double) (this.method_37908().method_8409().method_43057() * 0.2D);
                    this.method_37908().method_8406(class_2398.field_11251, d, e, f, g, h, l);
                }
        } else if (this.removeTicker >= 80) {
            this.method_31472();
        }
    }

    @Override
    public boolean method_5809() {
        return false;
    }

    @Environment(EnvType.CLIENT)
    public boolean method_5640(double distance) {
        return distance < 16384.0D;
    }

    @Override
    public float method_5718() {
        return 1.0F;
    }

    @Override
    public void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        class_1297 hittedEntity = entityHitResult.method_17782();

        if (!this.method_37908().method_8608() && !(hittedEntity instanceof VoidBulletEntity) && !(hittedEntity instanceof VoidShadeEntity)) {
            this.method_5783(class_3417.field_15210, 1.0F, 1.0F);
            hittedEntity.method_5643(createDamageSource(this), 7.0F);
            this.method_31472();
        }

    }

    @Override
    public void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        if (!this.method_37908().method_8608()) {
            for (int i = 0; i < 20; i++) {
                double d = (double) this.method_19538().method_10216() + 0.3F * this.method_37908().method_8409().method_43057();
                double e = (double) ((float) this.method_19538().method_10214() + this.method_37908().method_8409().method_43057() * 0.3F);
                double f = (double) this.method_19538().method_10215() + 0.3F * this.method_37908().method_8409().method_43057();
                double g = (double) (this.method_37908().method_8409().method_43057() * 0.1D);
                double h = (double) this.method_37908().method_8409().method_43057() * 0.1D;
                double l = (double) (this.method_37908().method_8409().method_43057() * 0.1D);
                ((class_3218) this.method_37908()).method_14199(class_2398.field_11251, d, e, f, 3, g, h, l, 0.1D);
            }
            this.method_5783(class_3417.field_15210, 1.0F, 1.0F);
            this.method_31472();
        }
    }

    private class_1282 createDamageSource(class_1297 entity) {
        return entity.method_48923().method_48796(EntityInit.VOID_BULLET_KEY, entity);
    }

}
