package net.adventurez.entity.nonliving;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import net.adventurez.init.EntityInit;
import net.adventurez.init.ParticleInit;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2945.class_9222;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.Nullable;

public class VoidCloudEntity extends class_1297 {
    private static final class_2940<Float> RADIUS;
    private final Map<class_1297, Integer> affectedEntities;
    private int duration;
    private int waitTime;
    private int reapplicationDelay;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusGrowth;
    @Nullable
    private class_1309 owner;
    @Nullable
    private UUID ownerUuid;
    private float particleTicker;

    public VoidCloudEntity(class_1299<? extends VoidCloudEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.affectedEntities = Maps.newHashMap();
        this.duration = 800;
        this.waitTime = 20;
        this.reapplicationDelay = 20;
        this.field_5960 = true;
        this.setRadius(3.0F);
        this.radiusGrowth = -0.01F;
    }

    public VoidCloudEntity(class_1937 world, double x, double y, double z) {
        this(EntityInit.VOID_CLOUD, world);
        this.method_5814(x, y, z);
    }

    @Override
    protected void method_5693(class_9222 builder) {
        builder.method_56912(RADIUS, 0.5F);
    }

    @Override
    public void method_18382() {
        double d = this.method_23317();
        double e = this.method_23318();
        double f = this.method_23321();
        super.method_18382();
        this.method_5814(d, e, f);
    }

    public void setRadius(float radius) {
        if (!this.method_37908().method_8608()) {
            this.method_5841().method_12778(RADIUS, class_3532.method_15363(radius, 0.0F, 32.0F));
        }
    }

    public float getRadius() {
        return (Float) this.method_5841().method_12789(RADIUS);
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        float f = this.getRadius();
        if (this.method_37908().method_8608()) {
            particleTicker += (float) Math.PI / 128F;
            double angle = 2 * Math.PI * particleTicker;
            for (float i = 1.2F; i >= 0.2F; i -= 0.1F) {
                this.method_37908().method_8406(ParticleInit.VOID_CLOUD_PARTICLE, (double) this.method_23317() + this.getRadius() * -(i - 1.2F) * Math.sin(angle + Math.PI * i),
                        (double) this.method_23318() + 0.4F + this.method_37908().method_8409().method_43057() * 0.1F, (double) this.method_23321() + this.getRadius() * -(i - 1.2F) * Math.cos(angle + Math.PI * i), 0.0D,
                        0.0D, 0.0D);
                this.method_37908().method_8406(ParticleInit.VOID_CLOUD_PARTICLE, (double) this.method_23317() + this.getRadius() * -(i - 1.2F) * Math.sin(angle + Math.PI * i + Math.PI),
                        (double) this.method_23318() + 0.4F + this.method_37908().method_8409().method_43057() * 0.1F, (double) this.method_23321() + this.getRadius() * -(i - 1.2F) * Math.cos(angle + Math.PI * i + Math.PI),
                        0.0D, 0.0D, 0.0D);
            }
        } else {
            if (this.field_6012 >= this.waitTime + this.duration) {
                this.method_31472();
                return;
            }

            if (this.radiusGrowth != 0.0F) {
                f += this.radiusGrowth;
                if (f < 0.5F) {
                    this.method_31472();
                    return;
                }

                this.setRadius(f);
            }

            if (this.field_6012 % 5 == 0) {
                this.affectedEntities.entrySet().removeIf((entry) -> {
                    return this.field_6012 >= (Integer) entry.getValue();
                });
                List<class_1657> list2 = this.method_37908().method_18467(class_1657.class, this.method_5829());
                if (!list2.isEmpty()) {
                    Iterator<class_1657> var27 = list2.iterator();

                    while (true) {
                        double aa;
                        class_1657 livingEntity;
                        do {
                            do {
                                do {
                                    if (!var27.hasNext()) {
                                        return;
                                    }

                                    livingEntity = (class_1657) var27.next();
                                } while (this.affectedEntities.containsKey(livingEntity));
                            } while (!livingEntity.method_6086());

                            double y = livingEntity.method_23317() - this.method_23317();
                            double z = livingEntity.method_23321() - this.method_23321();
                            aa = y * y + z * z;
                        } while (!(aa <= (double) (f * f)));
                        this.affectedEntities.put(livingEntity, this.field_6012 + this.reapplicationDelay);
                        livingEntity.method_6092(new class_1293(class_1294.field_5909, 50, 2, false, false, false));
                        if (this.radiusOnUse != 0.0F) {
                            f += this.radiusOnUse;
                            if (f < 0.5F) {
                                this.method_31472();
                                return;
                            }

                            this.setRadius(f);
                        }
                        if (this.durationOnUse != 0) {
                            this.duration += this.durationOnUse;
                            if (this.duration <= 0) {
                                this.method_31472();
                                return;
                            }
                        }
                    }
                }

            }
        }

    }

    @Nullable
    public class_1309 getOwner() {
        if (this.owner == null && this.ownerUuid != null && this.method_37908() instanceof class_3218) {
            class_1297 entity = ((class_3218) this.method_37908()).method_14190(this.ownerUuid);
            if (entity instanceof class_1309) {
                this.owner = (class_1309) entity;
            }
        }

        return this.owner;
    }

    @Override
    protected void method_5749(class_2487 nbt) {
        this.field_6012 = nbt.method_10550("Age");
        this.duration = nbt.method_10550("Duration");
        this.waitTime = nbt.method_10550("WaitTime");
        this.reapplicationDelay = nbt.method_10550("ReapplicationDelay");
        this.durationOnUse = nbt.method_10550("DurationOnUse");
        this.radiusOnUse = nbt.method_10583("RadiusOnUse");
        this.radiusGrowth = nbt.method_10583("RadiusPerTick");
        this.setRadius(nbt.method_10583("Radius"));
        if (nbt.method_25928("Owner"))
            this.ownerUuid = nbt.method_25926("Owner");
    }

    @Override
    protected void method_5652(class_2487 nbt) {
        nbt.method_10569("Age", this.field_6012);
        nbt.method_10569("Duration", this.duration);
        nbt.method_10569("ReapplicationDelay", this.reapplicationDelay);
        nbt.method_10569("DurationOnUse", this.durationOnUse);
        nbt.method_10548("RadiusOnUse", this.radiusOnUse);
        nbt.method_10548("RadiusPerTick", this.radiusGrowth);
        nbt.method_10548("Radius", this.getRadius());
        if (this.ownerUuid != null)
            nbt.method_25927("Owner", this.ownerUuid);
    }

    @Override
    public void method_5674(class_2940<?> data) {
        if (RADIUS.equals(data))
            this.method_18382();
        super.method_5674(data);
    }

    @Override
    public class_3619 method_5657() {
        return class_3619.field_15975;
    }

    @Override
    public class_4048 method_18377(class_4050 pose) {
        return class_4048.method_18384(this.getRadius() * 2.0F, 0.5F);
    }

    static {
        RADIUS = class_2945.method_12791(VoidCloudEntity.class, class_2943.field_13320);
    }
}
