package net.adventurez.entity.render;

import net.adventurez.entity.BlackstoneGolemEntity;
import net.adventurez.entity.model.BlackstoneGolemModel;
import net.adventurez.entity.render.feature.BlackstoneGolemBlueLavaFeatureRenderer;
import net.adventurez.entity.render.feature.StoneGolemLavaFeatureRenderer;
import net.adventurez.init.RenderInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5617;
import net.minecraft.class_927;

@Environment(EnvType.CLIENT)
public class BlackstoneGolemRenderer extends class_927<BlackstoneGolemEntity, BlackstoneGolemModel<BlackstoneGolemEntity>> {
    private static final class_2960 TEXTURE = class_2960.method_60654("adventurez:textures/entity/blackstone_golem.png");

    public BlackstoneGolemRenderer(class_5617.class_5618 context) {
        super(context, new BlackstoneGolemModel<>(context.method_32167(RenderInit.BLACKSTONE_GOLEM_LAYER)), 1.7F);
        this.method_4046(new StoneGolemLavaFeatureRenderer(this));
        this.method_4046(new BlackstoneGolemBlueLavaFeatureRenderer(this));
    }

    @Override
    public void scale(BlackstoneGolemEntity stone, class_4587 matrixStack, float f) {
        matrixStack.method_22905(2.4F, 2.4F, 2.4F);
    }

    @Override
    public class_2960 getTexture(BlackstoneGolemEntity stoneGolem) {
        return TEXTURE;
    }
}
