package net.adventurez.entity.render;

import net.adventurez.entity.DragonEntity;
import net.adventurez.entity.model.DragonModel;
import net.adventurez.entity.render.feature.DragonEyesFeatureRenderer;
import net.adventurez.entity.render.feature.DragonSaddleFeatureRenderer;
import net.adventurez.init.RenderInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_927;

@Environment(EnvType.CLIENT)
public class DragonRenderer extends class_927<DragonEntity, DragonModel<DragonEntity>> {
    private static final class_2960 TEXTURE = class_2960.method_60654("adventurez:textures/entity/dragon.png");
    private static final class_2960 RED_DRAGON_TEXTURE = class_2960.method_60654("adventurez:textures/entity/red_dragon.png");

    public DragonRenderer(class_5617.class_5618 context) {
        super(context, new DragonModel<>(context.method_32167(RenderInit.DRAGON_LAYER)), 0.4F);
        this.method_4046(new DragonEyesFeatureRenderer(this));
        this.method_4046(new DragonSaddleFeatureRenderer(this));
    }

    @Override
    public void render(DragonEntity dragonEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
        this.field_4673 = 0.6F * (float) dragonEntity.getSize();
        super.method_4054(dragonEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    @Override
    public void scale(DragonEntity dragonEntity, class_4587 matrixStack, float f) {
        matrixStack.method_22905((float) dragonEntity.getSize() / 3.0F, (float) dragonEntity.getSize() / 3.0F, (float) dragonEntity.getSize() / 3.0F);
    }

    @Override
    public class_2960 getTexture(DragonEntity dragonEntity) {
        if (dragonEntity.method_5841().method_12789(DragonEntity.RED_DRAGON)) {
            return RED_DRAGON_TEXTURE;
        }
        return TEXTURE;
    }
}
