package net.adventurez.entity.render;

import net.adventurez.entity.OrcEntity;
import net.adventurez.entity.model.OrcModel;
import net.adventurez.entity.render.feature.OrcInventoryFeatureRenderer;
import net.adventurez.init.RenderInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_927;

@Environment(EnvType.CLIENT)
public class OrcRenderer extends class_927<OrcEntity, OrcModel<OrcEntity>> {
    private static final class_2960 TEXTURE = class_2960.method_60654("adventurez:textures/entity/orc.png");

    public OrcRenderer(class_5617.class_5618 context) {
        super(context, new OrcModel<>(context.method_32167(RenderInit.ORC_LAYER)), 0.7F);
        this.method_4046(new OrcInventoryFeatureRenderer(this));
    }

    @Override
    public void render(OrcEntity orcEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
        this.field_4673 = 0.5F * (float) orcEntity.getSize();
        super.method_4054(orcEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    @Override
    public void scale(OrcEntity orcEntity, class_4587 matrixStack, float f) {
        matrixStack.method_22905(0.55F * orcEntity.getSize(), 0.55F * orcEntity.getSize(), 0.55F * orcEntity.getSize());
    }

    @Override
    public class_2960 getTexture(OrcEntity orcEntity) {
        return TEXTURE;
    }
}
