package net.adventurez.entity.render;

import net.adventurez.entity.TheEyeEntity;
import net.adventurez.entity.model.TheEyeModel;
import net.adventurez.init.RenderInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_927;

@Environment(EnvType.CLIENT)
public class TheEyeRenderer extends class_927<TheEyeEntity, TheEyeModel<TheEyeEntity>> {
    private static final class_2960 TEXTURE = class_2960.method_60654("adventurez:textures/entity/the_eye.png");
    private static final class_2960 EXPLOSION_BEAM_TEXTURE = class_2960.method_60654("adventurez:textures/entity/eye_beam.png");
    private static final class_1921 LAYER;

    public TheEyeRenderer(class_5617.class_5618 context) {
        super(context, new TheEyeModel<>(context.method_32167(RenderInit.THE_EYE_LAYER)), 1.0F);

    }

    @Override
    public void scale(TheEyeEntity eye, class_4587 matrixStack, float f) {
        matrixStack.method_22905(4.0F, 4.0F, 4.0F);
    }

    @Override
    public class_2960 getTexture(TheEyeEntity eye) {
        return TEXTURE;
    }

    @Override
    public boolean shouldRender(TheEyeEntity theEyeEntity, class_4604 frustum, double d, double e, double f) {
        if (super.method_3933((TheEyeEntity) theEyeEntity, frustum, d, e, f)) {
            return true;
        } else {
            if (theEyeEntity.hasBeamTarget()) {
                class_1309 livingEntity = theEyeEntity.getBeamTarget();
                if (livingEntity != null) {
                    class_243 vec3d = this.fromLerpedPosition(livingEntity, (double) livingEntity.method_17682() * 0.5D, 1.0F);
                    class_243 vec3d2 = this.fromLerpedPosition(theEyeEntity, (double) theEyeEntity.method_5751(), 1.0F);
                    return frustum.method_23093(new class_238(vec3d2.field_1352, vec3d2.field_1351, vec3d2.field_1350, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350));
                }
            }

            return false;
        }
    }

    private class_243 fromLerpedPosition(class_1309 entity, double yOffset, float delta) {
        double d = class_3532.method_16436((double) delta, entity.field_6038, entity.method_23317());
        double e = class_3532.method_16436((double) delta, entity.field_5971, entity.method_23318()) + yOffset;
        double f = class_3532.method_16436((double) delta, entity.field_5989, entity.method_23321());
        return new class_243(d, e, f);
    }

    @Override
    public void render(TheEyeEntity theEyeEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
        super.method_4054(theEyeEntity, f, g, matrixStack, vertexConsumerProvider, i);
        class_1309 livingEntity = theEyeEntity.getBeamTarget();
        if (livingEntity != null && livingEntity.method_5805() && theEyeEntity.method_5805()) {
            float j = (float) theEyeEntity.method_37908().method_8510() + g;
            float k = j * 0.5F % 1.0F;
            float l = theEyeEntity.method_5751();
            matrixStack.method_22903();
            matrixStack.method_46416(0.0F, l, 0.0F);
            class_243 vec3d = this.fromLerpedPosition(livingEntity, (double) livingEntity.method_17682() * 0.5, g);
            class_243 vec3d2 = this.fromLerpedPosition(theEyeEntity, (double) l, g);
            class_243 vec3d3 = vec3d.method_1020(vec3d2);
            float m = (float) (vec3d3.method_1033() + 1.0);
            vec3d3 = vec3d3.method_1029();
            float n = (float) Math.acos(vec3d3.field_1351);
            float o = (float) Math.atan2(vec3d3.field_1350, vec3d3.field_1352);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(((float) (Math.PI / 2) - o) * (180.0F / (float) Math.PI)));
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(n * (180.0F / (float) Math.PI)));
            float q = j * 0.05F * -1.5F;
            float r = j * j;
            int s = 64 + (int) (r * 191.0F);
            int t = 32 + (int) (r * 191.0F);
            int u = 128 - (int) (r * 64.0F);
            float x = class_3532.method_15362(q + (float) (Math.PI * 3.0 / 4.0)) * 0.282F;
            float y = class_3532.method_15374(q + (float) (Math.PI * 3.0 / 4.0)) * 0.282F;
            float z = class_3532.method_15362(q + (float) (Math.PI / 4)) * 0.282F;
            float aa = class_3532.method_15374(q + (float) (Math.PI / 4)) * 0.282F;
            float ab = class_3532.method_15362(q + ((float) Math.PI * 5.0F / 4.0F)) * 0.282F;
            float ac = class_3532.method_15374(q + ((float) Math.PI * 5.0F / 4.0F)) * 0.282F;
            float ad = class_3532.method_15362(q + ((float) Math.PI * 7.0F / 4.0F)) * 0.282F;
            float ae = class_3532.method_15374(q + ((float) Math.PI * 7.0F / 4.0F)) * 0.282F;
            float af = class_3532.method_15362(q + (float) Math.PI) * 0.2F;
            float ag = class_3532.method_15374(q + (float) Math.PI) * 0.2F;
            float ah = class_3532.method_15362(q + 0.0F) * 0.2F;
            float ai = class_3532.method_15374(q + 0.0F) * 0.2F;
            float aj = class_3532.method_15362(q + (float) (Math.PI / 2)) * 0.2F;
            float ak = class_3532.method_15374(q + (float) (Math.PI / 2)) * 0.2F;
            float al = class_3532.method_15362(q + (float) (Math.PI * 3.0 / 2.0)) * 0.2F;
            float am = class_3532.method_15374(q + (float) (Math.PI * 3.0 / 2.0)) * 0.2F;
            float aq = -1.0F + k;
            float ar = m * 2.5F + aq;
            class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(LAYER);
            class_4587.class_4665 entry = matrixStack.method_23760();
            vertex(vertexConsumer, entry, af, m, ag, s, t, u, 0.4999F, ar);
            vertex(vertexConsumer, entry, af, 0.0F, ag, s, t, u, 0.4999F, aq);
            vertex(vertexConsumer, entry, ah, 0.0F, ai, s, t, u, 0.0F, aq);
            vertex(vertexConsumer, entry, ah, m, ai, s, t, u, 0.0F, ar);
            vertex(vertexConsumer, entry, aj, m, ak, s, t, u, 0.4999F, ar);
            vertex(vertexConsumer, entry, aj, 0.0F, ak, s, t, u, 0.4999F, aq);
            vertex(vertexConsumer, entry, al, 0.0F, am, s, t, u, 0.0F, aq);
            vertex(vertexConsumer, entry, al, m, am, s, t, u, 0.0F, ar);
            float as = 0.0F;
            if (theEyeEntity.field_6012 % 2 == 0) {
                as = 0.5F;
            }

            vertex(vertexConsumer, entry, x, m, y, s, t, u, 0.5F, as + 0.5F);
            vertex(vertexConsumer, entry, z, m, aa, s, t, u, 1.0F, as + 0.5F);
            vertex(vertexConsumer, entry, ad, m, ae, s, t, u, 1.0F, as);
            vertex(vertexConsumer, entry, ab, m, ac, s, t, u, 0.5F, as);
            matrixStack.method_22909();
        }

    }

    private static void vertex(class_4588 vertexConsumer, class_4587.class_4665 matrix, float x, float y, float z, int red, int green, int blue, float u, float v) {
        vertexConsumer.method_56824(matrix, x, y, z).method_1336(red, green, blue, 255).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(class_765.field_32767).method_60831(matrix, 0.0F,
                1.0F, 0.0F);
    }

    static {
        LAYER = class_1921.method_23578(EXPLOSION_BEAM_TEXTURE);
    }
}
