package net.adventurez.entity.render;

import net.adventurez.entity.model.RockModel;
import net.adventurez.entity.nonliving.ThrownRockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3856;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_897;

@Environment(EnvType.CLIENT)
public class ThrownRockRenderer extends class_897<ThrownRockEntity> {
    private static final class_2960 GOLEM_TEXTURE = class_2960.method_60654("adventurez:textures/entity/thrown_golem_rock.png");
    private static final class_2960 VOID_TEXTURE = class_2960.method_60654("adventurez:textures/entity/thrown_void_rock.png");
    private final RockModel model = new RockModel(RockModel.getTexturedModelData().method_32109());

    public ThrownRockRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public int getBlockLight(ThrownRockEntity ThrownRockEntity, class_2338 blockPos) {
        return ThrownRockEntity.method_37908().method_22339(blockPos);
    }

    @Override
    public void render(ThrownRockEntity thrownRockEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {

        matrixStack.method_22903();
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(this.model.method_23500(this.getTexture(thrownRockEntity)));
        model.method_60879(matrixStack, vertexConsumer, i, class_4608.field_21444);
        matrixStack.method_22905(1.5F, 1.5F, 1.5F);
        matrixStack.method_22909();
        super.method_3936(thrownRockEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    @Override
    public class_2960 getTexture(ThrownRockEntity thrownRockEntity) {
        if (((class_3856) thrownRockEntity).method_7495().method_7909() == thrownRockEntity.method_16942()) {
            return GOLEM_TEXTURE;
        } else
            return VOID_TEXTURE;
    }
}