package net.adventurez.entity.render;

import org.joml.Quaternionf;
import org.joml.Vector3f;

import net.adventurez.entity.VoidShadowEntity;
import net.adventurez.entity.model.VoidShadowModel;
import net.adventurez.entity.render.feature.VoidShadowBlackFeatureRenderer;
import net.adventurez.entity.render.feature.VoidShadowEyesFeatureRenderer;
import net.adventurez.init.RenderInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5617;
import net.minecraft.class_5819;
import net.minecraft.class_927;

@Environment(EnvType.CLIENT)
public class VoidShadowRenderer extends class_927<VoidShadowEntity, VoidShadowModel<VoidShadowEntity>> {
    private static final class_2960 TEXTURE = class_2960.method_60654("adventurez:textures/entity/void_shadow.png");

    public VoidShadowRenderer(class_5617.class_5618 context) {
        super(context, new VoidShadowModel<>(context.method_32167(RenderInit.VOID_SHADOW_LAYER)), 1.7F);
        this.method_4046(new VoidShadowEyesFeatureRenderer(this));
        this.method_4046(new VoidShadowBlackFeatureRenderer(this));
    }

    @Override
    public void scale(VoidShadowEntity voidShadowEntity, class_4587 matrixStack, float f) {
        matrixStack.method_22905(9.0F, 9.0F, 9.0F);
    }

    @Override
    public class_2960 getTexture(VoidShadowEntity voidShadowEntity) {
        return TEXTURE;
    }

    @Override
    public void render(VoidShadowEntity voidShadowEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
        if (voidShadowEntity.ticksSinceDeath > 40) {
            matrixStack.method_22903();
            class_4588 vertexConsumer2 = vertexConsumerProvider.getBuffer(class_1921.method_23586(TEXTURE));
            this.field_4737.method_60879(matrixStack, vertexConsumer2, i, class_4608.method_23624(0.0F, false));

            float m = ((float) voidShadowEntity.ticksSinceDeath + g) / 200.0F;
            matrixStack.method_46416(0.0F, 8.0F, -2.0F);
            renderDeathAnimation(matrixStack, m, vertexConsumerProvider.getBuffer(class_1921.method_61046()));
            renderDeathAnimation(matrixStack, m, vertexConsumerProvider.getBuffer(class_1921.method_61157()));

            matrixStack.method_22909();
        }
        super.method_4054(voidShadowEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    private static void renderDeathAnimation(class_4587 matrices, float animationProgress, class_4588 vertexCOnsumer) {
        matrices.method_22903();
        float f = Math.min(animationProgress > 0.8F ? (animationProgress - 0.8F) / 0.2F : 0.0F, 1.0F);
        int i = class_5253.class_5254.method_59554(1.0F - f, 1.0F, 1.0F, 1.0F);
        class_5819 random = class_5819.method_43049(432L);
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        Quaternionf quaternionf = new Quaternionf();
        int k = class_3532.method_15375((animationProgress + animationProgress * animationProgress) / 2.0F * 60.0F);

        for (int l = 0; l < k; l++) {
            quaternionf.rotationXYZ(random.method_43057() * (float) (Math.PI * 2), random.method_43057() * (float) (Math.PI * 2), random.method_43057() * (float) (Math.PI * 2)).rotateXYZ(
                    random.method_43057() * (float) (Math.PI * 2), random.method_43057() * (float) (Math.PI * 2), random.method_43057() * (float) (Math.PI * 2) + animationProgress * (float) (Math.PI / 2));
            matrices.method_22907(quaternionf);
            float g = random.method_43057() * 20.0F + 5.0F + f * 10.0F;
            float h = random.method_43057() * 2.0F + 1.0F + f * 2.0F;
            vector3f2.set(-(float) (Math.sqrt(3.0) / 2.0) * h, g, -0.5F * h);
            vector3f3.set((float) (Math.sqrt(3.0) / 2.0) * h, g, -0.5F * h);
            vector3f4.set(0.0F, g, h);
            class_4587.class_4665 entry = matrices.method_23760();
            vertexCOnsumer.method_61032(entry, vector3f).method_39415(i);
            vertexCOnsumer.method_61032(entry, vector3f2).method_39415(16777215);
            vertexCOnsumer.method_61032(entry, vector3f3).method_39415(16777215);
            vertexCOnsumer.method_61032(entry, vector3f).method_39415(i);
            vertexCOnsumer.method_61032(entry, vector3f3).method_39415(16777215);
            vertexCOnsumer.method_61032(entry, vector3f4).method_39415(16777215);
            vertexCOnsumer.method_61032(entry, vector3f).method_39415(i);
            vertexCOnsumer.method_61032(entry, vector3f4).method_39415(16777215);
            vertexCOnsumer.method_61032(entry, vector3f2).method_39415(16777215);
        }

        matrices.method_22909();
    }

}
