package net.adventurez.entity.render.feature;

import net.adventurez.entity.EnderwarthogEntity;
import net.adventurez.entity.model.EnderwarthogModel;
import net.adventurez.entity.render.feature.layer.ExtraRenderLayer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;

@Environment(EnvType.CLIENT)
public class EnderwarthogEyesFeatureRenderer extends class_3887<EnderwarthogEntity, EnderwarthogModel<EnderwarthogEntity>> {
    private static final class_1921 EYE_LAYER = ExtraRenderLayer.getGlowing(class_2960.method_60654("adventurez:textures/entity/feature/enderwarthog_eyes_feature.png"));
    private static final class_1921 RARE_LAYER = class_1921.method_23578(class_2960.method_60654("adventurez:textures/entity/feature/rare_enderwarthog.png"));

    public EnderwarthogEyesFeatureRenderer(class_3883<EnderwarthogEntity, EnderwarthogModel<EnderwarthogEntity>> featureRendererContext) {
        super(featureRendererContext);
    }

    @Override
    public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, EnderwarthogEntity enderwarthogEntity, float f, float g, float h, float j, float k, float l) {
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(EYE_LAYER);
        this.method_17165().method_60879(matrixStack, vertexConsumer, 15728640, class_4608.field_21444);
        if (enderwarthogEntity.method_5841().method_12789(EnderwarthogEntity.RARE_VARIANT)) {
            class_4588 otherVertexConsumer = vertexConsumerProvider.getBuffer(RARE_LAYER);
            this.method_17165().method_60879(matrixStack, otherVertexConsumer, 20, class_4608.field_21444);
        }
    }

}