package net.adventurez.init;

import net.adventurez.AdventureMain;
import net.adventurez.entity.*;
import net.adventurez.entity.nonliving.*;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_1826;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;

@SuppressWarnings("unchecked")
public class EntityInit {
    // Hostile
    public static final class_1299<BlackstoneGolemEntity> BLACKSTONE_GOLEM = register("blackstone_golem", 2956072, 1445648,
            class_1299.class_1300.method_5903(BlackstoneGolemEntity::new, class_1311.field_6302).method_19947().method_17687(3.36F, 4.44F).build());
    public static final class_1299<MiniBlackstoneGolemEntity> MINI_BLACKSTONE_GOLEM = register("mini_blackstone_golem", 4077380, 4400440,
            class_1299.class_1300.method_5903(MiniBlackstoneGolemEntity::new, class_1311.field_6302).method_19947().method_17687(1.2F, 1.2F).build());
    public static final class_1299<PiglinBeastEntity> PIGLIN_BEAST = register("piglin_beast", 5121815, 14192743,
            class_1299.class_1300.method_5903(PiglinBeastEntity::new, class_1311.field_6302).method_19947().method_17687(1.55F, 3.35F).build());
    public static final class_1299<SoulReaperEntity> SOUL_REAPER = register("soul_reaper", 1381653, 5329747,
            class_1299.class_1300.method_5903(SoulReaperEntity::new, class_1311.field_6302).method_19947().method_17687(0.7F, 2.4F).method_55691(-0.6F).build());
    public static final class_1299<NecromancerEntity> NECROMANCER = register("necromancer", 1447446, 15514145,
            class_1299.class_1300.method_5903(NecromancerEntity::new, class_1311.field_6302).method_19947().method_17687(0.9F, 2.4F).build());
    public static final class_1299<WitherPuppetEntity> WITHER_PUPPET = register("wither_puppet", 1250067, 3092271,
            class_1299.class_1300.method_5903(WitherPuppetEntity::new, class_1311.field_6302).method_19947().method_17687(0.7F, 1.32F).build());
    public static final class_1299<SkeletonVanguardEntity> SKELETON_VANGUARD = register("skeleton_vanguard", 12369084, 11766305,
            class_1299.class_1300.method_5903(SkeletonVanguardEntity::new, class_1311.field_6302).method_17687(0.7F, 2.1F).build());
    public static final class_1299<SummonerEntity> SUMMONER = register("summoner", 12369084, 5847892,
            class_1299.class_1300.method_5903(SummonerEntity::new, class_1311.field_6302).method_17687(0.9F, 2.65F).build());
    public static final class_1299<BlazeGuardianEntity> BLAZE_GUARDIAN = register("blaze_guardian", 16766248, 9122817,
            class_1299.class_1300.method_5903(BlazeGuardianEntity::new, class_1311.field_6302).method_19947().method_17687(0.8F, 2.25F).build());
    public static final class_1299<TheEyeEntity> THE_EYE = register("the_eye", 1984565, 1059889,
            class_1299.class_1300.method_5903(TheEyeEntity::new, class_1311.field_6302).method_19947().method_17687(2.8F, 3.5F).method_55687(2.0F).build());
    public static final class_1299<VoidShadowEntity> VOID_SHADOW = register("void_shadow", 1441901, 393244,
            class_1299.class_1300.method_5903(VoidShadowEntity::new, class_1311.field_6302).method_19947().method_17687(10.2F, 15.3F).build());
    public static final class_1299<OrcEntity> ORC = register("orc", 2255437, 3512689, class_1299.class_1300.method_5903(OrcEntity::new, class_1311.field_6302).method_17687(1.35F, 2.2F).build());
    public static final class_1299<VoidShadeEntity> VOID_SHADE = register("void_shade", 1179727, 2956161,
            class_1299.class_1300.method_5903(VoidShadeEntity::new, class_1311.field_6302).method_17687(1.0F, 2.1F).build());
    public static final class_1299<AmethystGolemEntity> AMETHYST_GOLEM = register("amethyst_golem", 5395026, 9267916,
            class_1299.class_1300.method_5903(AmethystGolemEntity::new, class_1311.field_6302).method_17687(1.8F, 2.2F).build());
    public static final class_1299<DesertRhinoEntity> DESERT_RHINO = register("desert_rhino", 7884087, 12031588,
            class_1299.class_1300.method_5903(DesertRhinoEntity::new, class_1311.field_6302).method_17687(2.3F, 2.35F).build());
    public static final class_1299<ShamanEntity> SHAMAN = register("shaman", 210734, 8739394, class_1299.class_1300.method_5903(ShamanEntity::new, class_1311.field_6302).method_17687(0.9F, 2.01F).build());
    public static final class_1299<EnderwarthogEntity> ENDERWARTHOG = register("enderwarthog", 2828080, 6553725,
            class_1299.class_1300.method_5903(EnderwarthogEntity::new, class_1311.field_6302).method_17687(2.3F, 2.15F).build());

    // Passive
    public static final class_1299<RedFungusEntity> RED_FUNGUS = register("red_fungus", 13084791, 13183785,
            class_1299.class_1300.method_5903(RedFungusEntity::new, class_1311.field_6294).method_17687(1.05F, 1.4F).method_55687(0.7F).build());
    public static final class_1299<BrownFungusEntity> BROWN_FUNGUS = register("brown_fungus", 13084791, 9925201,
            class_1299.class_1300.method_5903(BrownFungusEntity::new, class_1311.field_6294).method_17687(1.35F, 1.8F).method_55687(0.9F).build());
    public static final class_1299<NightmareEntity> NIGHTMARE = register("nightmare", 1381653, 3012863,
            class_1299.class_1300.method_5903(NightmareEntity::new, class_1311.field_6294).method_19947().method_17687(1.4F, 1.6F).method_55689(1.4F).build());
    public static final class_1299<DragonEntity> DRAGON = register("dragon", 1842204, 14711290,
            class_1299.class_1300.method_5903(DragonEntity::new, class_1311.field_6294).method_17687(4.8F, 3.3F).method_55687(2.4F).method_55689(2.7F).method_19947().build());
    public static final class_1299<MammothEntity> MAMMOTH = register("mammoth", 4732462, 6376763, class_1299.class_1300.method_5903(MammothEntity::new, class_1311.field_6294).method_17687(2.8F, 3.5F).build());
    public static final class_1299<EnderWhaleEntity> ENDER_WHALE = register("ender_whale", 1711667, 6179950,
            class_1299.class_1300.method_5903(EnderWhaleEntity::new, class_1311.field_6294).method_17687(4.0F, 2.5F).build());
    public static final class_1299<IguanaEntity> IGUANA = register("iguana", 11485475, 8988193, class_1299.class_1300.method_5903(IguanaEntity::new, class_1311.field_6294).method_17687(1.5F, 0.5F).build());
    public static final class_1299<DeerEntity> DEER = register("deer", 5780491, 9725748, class_1299.class_1300.method_5903(DeerEntity::new, class_1311.field_6294).method_17687(1.4F, 1.8F).build());
    public static final class_1299<SkunkEntity> SKUNK = register("skunk", 3091500, 15525848, class_1299.class_1300.method_5903(SkunkEntity::new, class_1311.field_6294).method_17687(1.1F, 0.7F).build());

    // Nonliving Entity
    public static final class_1299<ThrownRockEntity> THROWN_ROCK = register("thrown_rock", 0, 0,
            class_1299.class_1300.<ThrownRockEntity>method_5903(ThrownRockEntity::new, class_1311.field_17715).method_17687(1.5F, 1.5F).build());
    public static final class_1299<GildedBlackstoneShardEntity> GILDED_BLACKSTONE_SHARD = register("gilded_blackstone_shard", 0, 0,
            class_1299.class_1300.<GildedBlackstoneShardEntity>method_5903(GildedBlackstoneShardEntity::new, class_1311.field_17715).method_17687(0.4F, 0.7F).build());
    public static final class_1299<TinyEyeEntity> TINY_EYE = register("tiny_eye", 0, 0, class_1299.class_1300.<TinyEyeEntity>method_5903(TinyEyeEntity::new, class_1311.field_17715).method_17687(0.4F, 0.4F).build());
    public static final class_1299<VoidBulletEntity> VOID_BULLET = register("void_bullet", 0, 0,
            class_1299.class_1300.<VoidBulletEntity>method_5903(VoidBulletEntity::new, class_1311.field_17715).method_17687(0.5F, 0.5F).build());
    public static final class_1299<FireBreathEntity> FIRE_BREATH = register("fire_breath", 0, 0,
            class_1299.class_1300.<FireBreathEntity>method_5903(FireBreathEntity::new, class_1311.field_17715).method_17687(0.3F, 0.3F).build());
    public static final class_1299<BlazeGuardianShieldEntity> BLAZE_GUARDIAN_SHIELD = register("blaze_guardian_shield", 0, 0,
            class_1299.class_1300.<BlazeGuardianShieldEntity>method_5903(BlazeGuardianShieldEntity::new, class_1311.field_17715).method_19947().method_17687(0.65F, 1.6F).build());
    public static final class_1299<AmethystShardEntity> AMETHYST_SHARD = register("amethyst_shard", 0, 0,
            class_1299.class_1300.<AmethystShardEntity>method_5903(AmethystShardEntity::new, class_1311.field_17715).method_17687(0.6F, 0.8F).build());
    public static final class_1299<VoidCloudEntity> VOID_CLOUD = register("void_cloud", 0, 0,
            class_1299.class_1300.<VoidCloudEntity>method_5903(VoidCloudEntity::new, class_1311.field_17715).method_17687(6.0F, 0.5F).method_19947().build());
    public static final class_1299<VoidFragmentEntity> VOID_FRAGMENT = register("void_fragment", 1376335, 3670138,
            class_1299.class_1300.method_5903(VoidFragmentEntity::new, class_1311.field_6302).method_17687(1.0F, 1.0F).build());

    // Damage Types
    public static final class_5321<class_8110> AMETHYST_SHARD_KEY = class_5321.method_29179(class_7924.field_42534, AdventureMain.identifierOf("amethyst_shard"));
    public static final class_5321<class_8110> VOID_BULLET_KEY = class_5321.method_29179(class_7924.field_42534, AdventureMain.identifierOf("void_bullet"));
    public static final class_5321<class_8110> FIRE_BREATH_KEY = class_5321.method_29179(class_7924.field_42534, AdventureMain.identifierOf("fire_breath"));
    public static final class_5321<class_8110> TINY_EYE_KEY = class_5321.method_29179(class_7924.field_42534, AdventureMain.identifierOf("tiny_eye"));
    public static final class_5321<class_8110> ROCK_KEY = class_5321.method_29179(class_7924.field_42534, AdventureMain.identifierOf("rock"));

    private static <T extends class_1297> class_1299<T> register(String id, int primaryColor, int secondaryColor, class_1299<T> entityType) {
        if (primaryColor != 0) {
            class_1792 item = class_2378.method_10230(class_7923.field_41178, AdventureMain.identifierOf("spawn_" + id),
                    new class_1826((class_1299<? extends class_1308>) entityType, primaryColor, secondaryColor, new class_1792.class_1793()));
            ItemGroupEvents.modifyEntriesEvent(ItemInit.ADVENTUREZ_ITEM_GROUP).register(entries -> entries.method_45421(item));
        }
        return class_2378.method_10230(class_7923.field_41177, AdventureMain.identifierOf(id), entityType);
    }

    public static void init() {
        // Attributes
        FabricDefaultAttributeRegistry.register(BLACKSTONE_GOLEM, BlackstoneGolemEntity.createStoneGolemAttributes());
        FabricDefaultAttributeRegistry.register(MINI_BLACKSTONE_GOLEM, MiniBlackstoneGolemEntity.createSmallStoneGolemAttributes());
        FabricDefaultAttributeRegistry.register(PIGLIN_BEAST, PiglinBeastEntity.createPiglinBeastAttributes());
        FabricDefaultAttributeRegistry.register(NIGHTMARE, NightmareEntity.createNightmareAttributes());
        FabricDefaultAttributeRegistry.register(SOUL_REAPER, SoulReaperEntity.createSoulReaperAttributes());
        FabricDefaultAttributeRegistry.register(NECROMANCER, NecromancerEntity.createNecromancerAttributes());
        FabricDefaultAttributeRegistry.register(WITHER_PUPPET, WitherPuppetEntity.createWitherPuppetAttributes());
        FabricDefaultAttributeRegistry.register(SKELETON_VANGUARD, SkeletonVanguardEntity.createSkeletonVanguardAttributes());
        FabricDefaultAttributeRegistry.register(SUMMONER, SummonerEntity.createSummonerAttributes());
        FabricDefaultAttributeRegistry.register(BLAZE_GUARDIAN, BlazeGuardianEntity.createBlazeGuardianAttributes());
        FabricDefaultAttributeRegistry.register(THE_EYE, TheEyeEntity.createTheEntityAttributes());
        FabricDefaultAttributeRegistry.register(VOID_SHADOW, VoidShadowEntity.createVoidShadowAttributes());
        FabricDefaultAttributeRegistry.register(RED_FUNGUS, RedFungusEntity.createRedFungusAttributes());
        FabricDefaultAttributeRegistry.register(BROWN_FUNGUS, BrownFungusEntity.createBrownFungusAttributes());
        FabricDefaultAttributeRegistry.register(ORC, OrcEntity.createOrcAttributes());
        FabricDefaultAttributeRegistry.register(DRAGON, DragonEntity.createDragonAttributes());
        FabricDefaultAttributeRegistry.register(MAMMOTH, MammothEntity.createMammothAttributes());
        FabricDefaultAttributeRegistry.register(VOID_FRAGMENT, VoidFragmentEntity.createVoidFragmentAttributes());
        FabricDefaultAttributeRegistry.register(VOID_SHADE, VoidShadeEntity.createVoidShadeAttributes());
        FabricDefaultAttributeRegistry.register(ENDER_WHALE, EnderWhaleEntity.createEnderWhaleAttributes());
        FabricDefaultAttributeRegistry.register(IGUANA, IguanaEntity.createIguanaAttributes());
        FabricDefaultAttributeRegistry.register(AMETHYST_GOLEM, AmethystGolemEntity.createAmethystGolemAttributes());
        FabricDefaultAttributeRegistry.register(DESERT_RHINO, DesertRhinoEntity.createDesertRhinoAttributes());
        FabricDefaultAttributeRegistry.register(SHAMAN, ShamanEntity.createShamanAttributes());
        FabricDefaultAttributeRegistry.register(DEER, DeerEntity.createDeerAttributes());
        FabricDefaultAttributeRegistry.register(SKUNK, SkunkEntity.createSkunkAttributes());
        FabricDefaultAttributeRegistry.register(ENDERWARTHOG, EnderwarthogEntity.createEnderwarthogAttributes());
    }
}