package net.adventurez.init;

import java.util.List;
import java.util.function.UnaryOperator;

import com.mojang.serialization.Codec;

import net.adventurez.AdventureMain;
import net.adventurez.item.*;
import net.adventurez.item.component.GildedActivationComponent;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.registry.FabricBrewingRecipeRegistryBuilder;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1738;
import net.minecraft.class_1744;
import net.minecraft.class_1758;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1847;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8052;
import net.minecraft.class_9135;
import net.minecraft.class_9331;

public class ItemInit {

    // Item Group
    public static final class_5321<class_1761> ADVENTUREZ_ITEM_GROUP = class_5321.method_29179(class_7924.field_44688, class_2960.method_60655("adventurez", "item_group"));

    // Components
    public static final class_9331<Boolean> VOID_DROP = registerComponent("void_drop", builder -> builder.method_57881(Codec.BOOL).method_57882(class_9135.field_48547));
    public static final class_9331<Boolean> LAVA_LIGHT = registerComponent("lava_light", builder -> builder.method_57881(Codec.BOOL).method_57882(class_9135.field_48547));
    public static final class_9331<GildedActivationComponent> GILDED_DATA = registerComponent("gilded_data",
            builder -> builder.method_57881(GildedActivationComponent.CODEC).method_57882(GildedActivationComponent.PACKET_CODEC));

    // Items
    public static final class_1792 GILDED_BLACKSTONE_SHARD = register("gilded_blackstone_shard", new GildedBlackstoneShard(new class_1792.class_1793().method_24359(), () -> EntityInit.GILDED_BLACKSTONE_SHARD));
    public static final class_1792 BLACKSTONE_GOLEM_HEART = register("blackstone_golem_heart", new BlackstoneGolemHeart(new class_1792.class_1793().method_24359()));
    public static final class_1792 BLACKSTONE_GOLEM_ARM = register("blackstone_golem_arm", new BlackstoneGolemArm(new class_1792.class_1793().method_7895(2506).method_24359()));
    public static final class_1792 GILDED_NETHERITE_FRAGMENT = register("gilded_netherite_fragment", new GildedNetheriteFragment(new class_1792.class_1793().method_24359()));
    public static final class_1792 PRIME_EYE = register("prime_eye", new PrimeEyeItem(new class_1792.class_1793().method_7895(64)));
    public static final class_1792 ORC_SKIN = register("orc_skin", new class_1792(new class_1792.class_1793()));
    public static final class_1792 DRAGON_SADDLE = register("dragon_saddle", new class_1792(new class_1792.class_1793().method_7889(1)));
    public static final class_1792 SOURCE_STONE = register("source_stone", new SourceStone(new class_1792.class_1793().method_7889(1)));
    public static final class_1792 CHORUS_FRUIT_ON_A_STICK = register("chorus_fruit_on_a_stick", new class_1758<>((new class_1792.class_1793()).method_7895(100), EntityInit.ENDER_WHALE, 1));
    public static final class_1792 ENDER_FLUTE = register("ender_flute", new EnderFlute(new class_1792.class_1793().method_7895(32)));
    public static final class_1792 IGUANA_HIDE = register("iguana_hide", new class_1792(new class_1792.class_1793()));
    public static final class_1792 MAMMOTH_LEATHER = register("mammoth_fur", new class_1792(new class_1792.class_1793()));
    public static final class_1792 ENDER_WHALE_SKIN = register("ender_whale_skin", new class_1792(new class_1792.class_1793()));
    public static final class_1792 IVORY_ARROW = register("ivory_arrow", new class_1744(new class_1792.class_1793()));
    public static final class_1792 MAMMOTH_TUSK = register("mammoth_tusk", new class_1792(new class_1792.class_1793()));
    public static final class_1792 RHINO_LEATHER = register("rhino_leather", new class_1792(new class_1792.class_1793()));
    public static final class_1792 WARTHOG_SHELL_PIECE = register("warthog_shell_piece", new class_1792(new class_1792.class_1793()));
    public static final class_1792 HANDBOOK = register("handbook", new Handbook(new class_1792.class_1793().method_7889(1)));
    public static final class_1792 GILDED_UPGRADE_SMITHING_TEMPLATE = register("gilded_upgrade_smithing_template",
            new class_8052(class_2561.method_43471("item.minecraft.smithing_template.gilded_upgrade.applies_to").method_27692(class_124.field_1078),
                    class_2561.method_43471("item.minecraft.smithing_template.gilded_upgrade.ingredients").method_27692(class_124.field_1078),
                    class_2561.method_43471("item.adventurez.gilded_upgrade").method_27692(class_124.field_1080), class_2561.method_43471("item.smithing_template.gilded_upgrade.base_slot_description"),
                    class_2561.method_43471("item.adventurez.smithing_template.gilded_upgrade.additions_slot_description"), List.of(class_2960.method_60654("item/empty_armor_slot_helmet"),
                    class_2960.method_60654("item/empty_armor_slot_chestplate"), class_2960.method_60654("item/empty_armor_slot_leggings"), class_2960.method_60654("item/empty_armor_slot_boots")),
                    List.of(class_2960.method_60654("adventurez:item/empty_slot_gilded_netherite_fragment"))));

    // Food
    public static final class_1792 MAMMOTH_MEAT = register("mammoth_meat", new class_1792(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(3).method_19237(0.3F).method_19242())));
    public static final class_1792 COOKED_MAMMOTH_MEAT = register("cooked_mammoth_meat", new class_1792(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(8).method_19237(0.8F).method_19242())));
    public static final class_1792 IGUANA_MEAT = register("iguana_meat",
            new class_1792(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(2).method_19237(0.3F).method_19239(new class_1293(class_1294.field_5903, 600, 0), 0.3F).method_19242())));
    public static final class_1792 COOKED_IGUANA_MEAT = register("cooked_iguana_meat", new class_1792(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(6).method_19237(0.6F).method_19242())));
    public static final class_1792 ENDER_WHALE_MEAT = register("ender_whale_meat", new class_1792(
            new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(3).method_19237(0.3F).method_19239(new class_1293(class_1294.field_5919, 100, 0), 0.5F).method_19242())));
    public static final class_1792 COOKED_ENDER_WHALE_MEAT = register("cooked_ender_whale_meat", new class_1792(
            new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(8).method_19237(0.9F).method_19239(new class_1293(class_1294.field_5906, 600, 0), 1.0F).method_19242())));
    public static final class_1792 RHINO_MEAT = register("rhino_meat", new class_1792(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(3).method_19237(0.3F).method_19242())));
    public static final class_1792 COOKED_RHINO_MEAT = register("cooked_rhino_meat", new class_1792(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(8).method_19237(0.8F).method_19242())));
    public static final class_1792 RAW_VENISON = register("raw_venison", new class_1792(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(3).method_19237(0.3F).method_19242())));
    public static final class_1792 COOKED_VENISON = register("cooked_venison", new class_1792(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(6).method_19237(0.8F).method_19242())));
    public static final class_1792 WARTHOG_MEAT = register("warthog_meat", new class_1792(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(3).method_19237(0.3F).method_19242())));
    public static final class_1792 COOKED_WARTHOG_MEAT = register("cooked_warthog_meat",
            new class_1792(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(6).method_19237(0.8F).method_19239(new class_1293(class_1294.field_5904, 600, 0), 1.0F).method_19242())));
    public static final class_1792 SKUNK_MEAT = register("skunk_meat", new class_1792(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(2).method_19237(0.3F).method_19242())));
    public static final class_1792 COOKED_SKUNK_MEAT = register("cooked_skunk_meat", new class_1792(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(4).method_19237(0.8F).method_19242())));

    // Armor
    public static final class_1792 GILDED_NETHERITE_HELMET = register("gilded_netherite_helmet",
            new GildedNetheriteArmor(AdventureArmorMaterials.GILDED_NETHERITE, class_1738.class_8051.field_41934, new class_1792.class_1793().method_7895(class_1738.class_8051.field_41934.method_56690(37)).method_24359()));
    public static final class_1792 GILDED_NETHERITE_CHESTPLATE = register("gilded_netherite_chestplate",
            new GildedNetheriteArmor(AdventureArmorMaterials.GILDED_NETHERITE, class_1738.class_8051.field_41935, new class_1792.class_1793().method_7895(class_1738.class_8051.field_41935.method_56690(37)).method_24359()));
    public static final class_1792 GILDED_NETHERITE_LEGGINGS = register("gilded_netherite_leggings",
            new GildedNetheriteArmor(AdventureArmorMaterials.GILDED_NETHERITE, class_1738.class_8051.field_41936, new class_1792.class_1793().method_7895(class_1738.class_8051.field_41936.method_56690(37)).method_24359()));
    public static final class_1792 GILDED_NETHERITE_BOOTS = register("gilded_netherite_boots",
            new GildedNetheriteArmor(AdventureArmorMaterials.GILDED_NETHERITE, class_1738.class_8051.field_41937, new class_1792.class_1793().method_7895(class_1738.class_8051.field_41937.method_56690(37)).method_24359()));

    private static class_1792 register(String id, class_1792 item) {
        return register(AdventureMain.identifierOf(id), item);
    }

    private static class_1792 register(class_2960 id, class_1792 item) {
        ItemGroupEvents.modifyEntriesEvent(ADVENTUREZ_ITEM_GROUP).register(entries -> entries.method_45421(item));
        return class_2378.method_10230(class_7923.field_41178, id, item);
    }

    private static <T> class_9331<T> registerComponent(String id, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return class_2378.method_10226(class_7923.field_49658, id, builderOperator.apply(class_9331.method_57873()).method_57880());
    }

    public static void init() {
        class_2378.method_39197(class_7923.field_44687, ADVENTUREZ_ITEM_GROUP,
                FabricItemGroup.builder().method_47320(() -> new class_1799(ItemInit.HANDBOOK)).method_47321(class_2561.method_43471("item.adventurez.item_group")).method_47324());

        FabricBrewingRecipeRegistryBuilder.BUILD.register((builder) -> {
            builder.method_59705(class_1847.field_8999, ItemInit.ORC_SKIN, class_1847.field_8990);
            builder.method_59705(class_1847.field_8999, ItemInit.ENDER_WHALE_SKIN, class_1847.field_8974);
        });
    }

}