package net.adventurez.init;

import org.lwjgl.glfw.GLFW;

import net.adventurez.entity.DragonEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_3675;

@Environment(EnvType.CLIENT)
public class KeybindInit {

    public static class_304 dragonFlyDownKeyBind;
    public static class_304 dragonFireBreathBind;

    public static void init() {
        // Keybinds
        dragonFlyDownKeyBind = new class_304("key.adventurez.dragonflydown", class_3675.class_307.field_1668, GLFW.GLFW_KEY_LEFT_ALT, "category.adventurez.keybind");
        dragonFireBreathBind = new class_304("key.adventurez.dragonfirebreath", class_3675.class_307.field_1668, GLFW.GLFW_KEY_GRAVE_ACCENT, "category.adventurez.keybind");
        // Registering
        KeyBindingHelper.registerKeyBinding(dragonFlyDownKeyBind);
        KeyBindingHelper.registerKeyBinding(dragonFireBreathBind);
        // Callback
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (dragonFlyDownKeyBind.method_1434()) {
                DragonEntity.flyDragonDown(client.field_1724, dragonFlyDownKeyBind.method_1428());
                return;
            } else if (dragonFireBreathBind.method_1436()) {
                DragonEntity.dragonFireBreath(client.field_1724);
                return;
            }
        });
    }

}
