package net.adventurez.init;

import net.adventurez.AdventureMain;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.particle.v1.FabricSpriteProvider;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_2378;
import net.minecraft.class_2400;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_638;
import net.minecraft.class_673;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7923;
import net.minecraft.client.particle.*;
import java.util.Random;

public class ParticleInit {

    public static final class_2400 AMETHYST_SHARD_PARTICLE = FabricParticleTypes.simple();
    public static final class_2400 VOID_CLOUD_PARTICLE = FabricParticleTypes.simple();
    public static final class_2400 SPRINT_PARTICLE = FabricParticleTypes.simple();
    public static final class_2400 FART_PARTICLE = FabricParticleTypes.simple();

    public static void init() {
        class_2378.method_10230(class_7923.field_41180, AdventureMain.identifierOf("amethyst_shard_particle"), AMETHYST_SHARD_PARTICLE);
        class_2378.method_10230(class_7923.field_41180, AdventureMain.identifierOf("void_cloud_particle"), VOID_CLOUD_PARTICLE);
        class_2378.method_10230(class_7923.field_41180, AdventureMain.identifierOf("sprint_particle"), SPRINT_PARTICLE);
        class_2378.method_10230(class_7923.field_41180, AdventureMain.identifierOf("fart_particle"), FART_PARTICLE);
    }

    @Environment(EnvType.CLIENT)
    public static class FartParticle extends class_673 {

        public FartParticle(class_638 clientWorld, double d, double e, double f, double g, double h, double i, class_4002 spriteProvider) {
            super(clientWorld, d, e, f, g, h, i, spriteProvider);
            this.field_3844 = 0.5F;
            this.field_3861 = 0f;
            this.field_3842 = 0f;
            this.field_3859 = 0f;
        }

        @Environment(EnvType.CLIENT)
        public static class Factory implements class_707<class_2400> {
            private final class_4002 spriteProvider;

            public Factory(class_4002 spriteProvider) {
                this.spriteProvider = spriteProvider;
            }

            @Override
            public class_703 createParticle(class_2400 simpleParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
                return new FartParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
            }
        }
    }

    @Environment(EnvType.CLIENT)
    public static class ShardParticle extends class_4003 {
        static final Random RANDOM = new Random();
        private final class_4002 spriteProvider;

        public ShardParticle(class_638 clientWorld, double d, double e, double f, double g, double h, double i, class_4002 spriteProvider) {
            super(clientWorld, d, e, f, g, h, i);
            this.field_28786 = 0.96F;
            this.field_28787 = true;
            this.spriteProvider = spriteProvider;
            this.field_17867 *= 0.75F;
            this.field_3862 = false;
            this.method_18142(spriteProvider);
        }

        @Override
        public class_3999 method_18122() {
            return class_3999.field_17829;
        }

        @Override
        public int method_3068(float tint) {
            float f = ((float) this.field_3866 + tint) / (float) this.field_3847;
            f = class_3532.method_15363(f, 0.0F, 1.0F);
            int i = super.method_3068(tint);
            int j = i & 255;
            int k = i >> 16 & 255;
            j += (int) (f * 15.0F * 16.0F);
            if (j > 240) {
                j = 240;
            }

            return j | k << 16;
        }

        @Override
        public void method_3070() {
            super.method_3070();
            this.method_18142(this.spriteProvider);
        }

        @Environment(EnvType.CLIENT)
        public static class ShardFactory implements class_707<class_2400> {
            private final class_4002 spriteProvider;

            public ShardFactory(FabricSpriteProvider sprites) {
                this.spriteProvider = sprites;
            }

            @Override
            public class_703 createParticle(class_2400 defaultParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
                ShardParticle shardParticle = new ShardParticle(clientWorld, d, e, f, 0.5D - ShardParticle.RANDOM.nextDouble(), h, 0.5D - ShardParticle.RANDOM.nextDouble(), this.spriteProvider);
                int rand = clientWorld.field_9229.method_43048(4);
                if (rand == 0)
                    shardParticle.method_3084(1.0F, 0.796F, 0.9F);
                else if (rand == 1)
                    shardParticle.method_3084(0.392F, 0.278F, 0.619F);
                else if (rand == 2)
                    shardParticle.method_3084(0.65F, 0.47F, 0.945F);
                else if (rand == 3)
                    shardParticle.method_3084(0.784F, 0.564F, 0.941F);

                shardParticle.field_3869 *= 0.20000000298023224D;
                if (g == 0.0D && i == 0.0D) {
                    shardParticle.field_3852 *= 0.10000000149011612D;
                    shardParticle.field_3850 *= 0.10000000149011612D;
                }

                shardParticle.method_3077((int) (8.0D / (clientWorld.field_9229.method_43058() * 0.8D + 0.2D)));
                return shardParticle;
            }
        }

    }

    @Environment(EnvType.CLIENT)
    public static class VoidCloudParticle extends class_4003 {
        private final double startX;
        private final double startY;
        private final double startZ;

        private VoidCloudParticle(class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            super(clientWorld, d, e, f);
            this.field_3852 = g;
            this.field_3869 = h;
            this.field_3850 = i;
            this.field_3874 = d;
            this.field_3854 = e;
            this.field_3871 = f;
            this.startX = this.field_3874;
            this.startY = this.field_3854;
            this.startZ = this.field_3871;
            this.field_17867 = 0.5F * (this.field_3840.method_43057() * 0.05F + 0.4F);
            this.field_3861 = this.field_3840.method_43057() * 0.2F;
            this.field_3842 = this.field_3840.method_43057() * 0.2F;
            this.field_3859 = this.field_3840.method_43057() * 0.2F;
            this.field_3847 = (int) (this.field_3840.method_43057() * 2.0F) + 10;
        }

        @Override
        public class_3999 method_18122() {
            return class_3999.field_17828;
        }

        @Override
        public void method_3069(double dx, double dy, double dz) {
            this.method_3067(this.method_3064().method_989(dx, dy, dz));
            this.method_3072();
        }

        @Override
        public float method_18132(float tickDelta) {
            float f = ((float) this.field_3866 + tickDelta) / (float) this.field_3847;
            f = 1.0F - f;
            f *= f;
            f = 1.0F - f;
            return this.field_17867 * f;
        }

        @Override
        public int method_3068(float tint) {
            int i = super.method_3068(tint);
            float f = (float) this.field_3866 / (float) this.field_3847;
            f *= f;
            f *= f;
            int j = i & 255;
            int k = i >> 16 & 255;
            k += (int) (f * 15.0F * 16.0F);
            if (k > 240) {
                k = 240;
            }

            return j | k << 16;
        }

        @Override
        public void method_3070() {
            this.field_3858 = this.field_3874;
            this.field_3838 = this.field_3854;
            this.field_3856 = this.field_3871;
            if (this.field_3866++ >= this.field_3847) {
                this.method_3085();
            } else {
                float f = (float) this.field_3866 / (float) this.field_3847;
                float g = f;
                f = -f + f * f * 2.0F;
                f = 1.0F - f;
                this.field_3874 = this.startX + this.field_3852 * (double) f;
                this.field_3854 = this.startY + this.field_3869 * (double) f + (double) (1.0F - g);
                this.field_3871 = this.startZ + this.field_3850 * (double) f;
            }
        }

        @Environment(EnvType.CLIENT)
        public static class CloudFactory implements class_707<class_2400> {
            private final class_4002 spriteProvider;

            public CloudFactory(class_4002 spriteProvider) {
                this.spriteProvider = spriteProvider;
            }

            @Override
            public class_703 createParticle(class_2400 defaultParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
                VoidCloudParticle portalParticle = new VoidCloudParticle(clientWorld, d, e, f, g, h, i);
                portalParticle.method_18140(this.spriteProvider);
                return portalParticle;
            }
        }
    }

    @Environment(EnvType.CLIENT)
    static class SprintParticle extends class_4003 {
        static final Random RANDOM = new Random();
        private final class_4002 spriteProvider;

        public SprintParticle(class_638 clientWorld, double d, double e, double f, double g, double h, double i, class_4002 spriteProvider) {
            super(clientWorld, d, e, f);
            this.field_28786 = 1.0F;
            this.field_28787 = false;
            this.field_3844 = 0.0F;
            this.spriteProvider = spriteProvider;
            this.field_3862 = false;
            this.method_18142(spriteProvider);
        }

        @Override
        public class_3999 method_18122() {
            return class_3999.field_17829;
        }

        @Override
        public void method_3070() {
            super.method_3070();
            this.method_18142(this.spriteProvider);
        }

        @Environment(EnvType.CLIENT)
        public static class SprintFactory implements class_707<class_2400> {
            private final class_4002 spriteProvider;

            public SprintFactory(FabricSpriteProvider sprites) {
                this.spriteProvider = sprites;
            }

            @Override
            public class_703 createParticle(class_2400 defaultParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
                SprintParticle sprintParticle = new SprintParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
                sprintParticle.field_3852 = -g * 1.5D;
                sprintParticle.field_3850 = -i * 1.5D;
                sprintParticle.method_3077(8);
                return sprintParticle;
            }
        }

    }
}
