package net.adventurez.init;

import net.adventurez.AdventureMain;
import net.adventurez.block.renderer.*;
import net.adventurez.entity.model.*;
import net.adventurez.entity.render.*;
import net.adventurez.init.ParticleInit.ShardParticle;
import net.adventurez.init.ParticleInit.SprintParticle;
import net.adventurez.init.ParticleInit.VoidCloudParticle;
import net.adventurez.init.ParticleInit.FartParticle;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5601;
import net.minecraft.class_5616;
import net.minecraft.class_6344;
import net.minecraft.class_826;

@Environment(EnvType.CLIENT)
public class RenderInit {

    private static final class_2960 WITHERED_TEXTURE = AdventureMain.identifierOf("textures/misc/withered.png");
    private static final class_2960 ACTIVE_ARMOR_TEXTURE = AdventureMain.identifierOf("textures/misc/active_armor.png");

    public static final boolean isCanvasLoaded = FabricLoader.getInstance().isModLoaded("canvas");
    public static final boolean isIrisLoaded = FabricLoader.getInstance().isModLoaded("iris");
    public static final boolean isSodiumLoaded = FabricLoader.getInstance().isModLoaded("sodium");

    public static final class_5601 BLACKSTONE_GOLEM_LAYER = new class_5601(AdventureMain.identifierOf("blackstone_golem_render_layer"), "blackstone_golem_render_layer");
    public static final class_5601 THROWN_ROCK_LAYER = new class_5601(AdventureMain.identifierOf("thrown_rock_render_layer"), "thrown_rock_render_layer");
    public static final class_5601 GILDED_STONE_LAYER = new class_5601(AdventureMain.identifierOf("gilded_stone_render_layer"), "gilded_stone_render_layer");
    public static final class_5601 MINI_BLACKSTONE_GOLEM_LAYER = new class_5601(AdventureMain.identifierOf("mini_blackstone_golem_render_layer"), "mini_blackstone_golem_render_layer");
    public static final class_5601 PIGLIN_BEAST_LAYER = new class_5601(AdventureMain.identifierOf("piglin_beast_render_layer"), "piglin_beast_render_layer");
    public static final class_5601 NIGHTMARE_LAYER = new class_5601(AdventureMain.identifierOf("nightmare_render_layer"), "nightmare_render_layer");
    public static final class_5601 SOUL_REAPER_LAYER = new class_5601(AdventureMain.identifierOf("soul_reaper_render_layer"), "soul_reaper_render_layer");
    public static final class_5601 NECROMANCER_LAYER = new class_5601(AdventureMain.identifierOf("necromancer_render_layer"), "necromancer_render_layer");
    public static final class_5601 WITHER_PUPPET_LAYER = new class_5601(AdventureMain.identifierOf("wither_puppet_render_layer"), "wither_puppet_render_layer");
    public static final class_5601 SKELETON_VANGUARD_LAYER = new class_5601(AdventureMain.identifierOf("skeleton_vanguard_render_layer"), "skeleton_vanguard_render_layer");
    public static final class_5601 SUMMONER_LAYER = new class_5601(AdventureMain.identifierOf("summoner_render_layer"), "summoner_render_layer");
    public static final class_5601 BLAZE_GUARDIAN_LAYER = new class_5601(AdventureMain.identifierOf("blaze_guardian_render_layer"), "blaze_guardian_render_layer");
    public static final class_5601 THE_EYE_LAYER = new class_5601(AdventureMain.identifierOf("the_eye_render_layer"), "the_eye_render_layer");
    public static final class_5601 VOID_SHADOW_LAYER = new class_5601(AdventureMain.identifierOf("void_shadow_render_layer"), "void_shadow_render_layer");
    public static final class_5601 TINY_EYE_LAYER = new class_5601(AdventureMain.identifierOf("tiny_eye_render_layer"), "tiny_eye_render_layer");
    public static final class_5601 RED_FUNGUS_LAYER = new class_5601(AdventureMain.identifierOf("red_fungus_render_layer"), "red_fungus_render_layer");
    public static final class_5601 BROWN_FUNGUS_LAYER = new class_5601(AdventureMain.identifierOf("brown_fungus_render_layer"), "brown_fungus_render_layer");
    public static final class_5601 ORC_LAYER = new class_5601(AdventureMain.identifierOf("orc_render_layer"), "orc_render_layer");
    public static final class_5601 DRAGON_LAYER = new class_5601(AdventureMain.identifierOf("dragon_render_layer"), "dragon_render_layer");
    public static final class_5601 MAMMOTH_LAYER = new class_5601(AdventureMain.identifierOf("mammoth_render_layer"), "mammoth_render_layer");
    public static final class_5601 VOID_FRAGMENT_LAYER = new class_5601(AdventureMain.identifierOf("void_fragment_render_layer"), "void_fragment_render_layer");
    public static final class_5601 VOID_SHADE_LAYER = new class_5601(AdventureMain.identifierOf("void_shade_render_layer"), "void_shade_render_layer");
    public static final class_5601 VOID_BULLET_LAYER = new class_5601(AdventureMain.identifierOf("void_bullet_render_layer"), "void_bullet_render_layer");
    public static final class_5601 PIGLIN_FLAG_LAYER = new class_5601(AdventureMain.identifierOf("piglin_flag_render_layer"), "piglin_flag_render_layer");
    public static final class_5601 ENDER_WHALE_LAYER = new class_5601(AdventureMain.identifierOf("ender_whale_render_layer"), "ender_whale_render_layer");
    public static final class_5601 IGUANA_LAYER = new class_5601(AdventureMain.identifierOf("iguana_render_layer"), "iguana_render_layer");
    public static final class_5601 AMETHYST_GOLEM_LAYER = new class_5601(AdventureMain.identifierOf("amethyst_golem_render_layer"), "amethyst_golem_render_layer");
    public static final class_5601 AMETHYST_SHARD_LAYER = new class_5601(AdventureMain.identifierOf("amethyst_shard_render_layer"), "amethyst_shard_render_layer");
    public static final class_5601 DESERT_RHINO_LAYER = new class_5601(AdventureMain.identifierOf("desert_rhino_render_layer"), "desert_rhino_render_layer");
    public static final class_5601 SHAMAN_LAYER = new class_5601(AdventureMain.identifierOf("shaman_render_layer"), "shaman_render_layer");
    public static final class_5601 DEER_LAYER = new class_5601(AdventureMain.identifierOf("deer_render_layer"), "deer_render_layer");
    public static final class_5601 SKUNK_LAYER = new class_5601(AdventureMain.identifierOf("skunk_render_layer"), "skunk_render_layer");
    public static final class_5601 ENDERWARTHOG_LAYER = new class_5601(AdventureMain.identifierOf("enderwarthog_render_layer"), "enderwarthog_render_layer");

    public static void init() {
        // Entity Renderer
        EntityRendererRegistry.register(EntityInit.BLACKSTONE_GOLEM, BlackstoneGolemRenderer::new);
        EntityRendererRegistry.register(EntityInit.THROWN_ROCK, ThrownRockRenderer::new);
        EntityRendererRegistry.register(EntityInit.GILDED_BLACKSTONE_SHARD, GildedStoneRenderer::new);
        EntityRendererRegistry.register(EntityInit.MINI_BLACKSTONE_GOLEM, MiniBlackstoneGolemRenderer::new);
        EntityRendererRegistry.register(EntityInit.PIGLIN_BEAST, PiglinBeastRenderer::new);
        EntityRendererRegistry.register(EntityInit.NIGHTMARE, NightmareRenderer::new);
        EntityRendererRegistry.register(EntityInit.SOUL_REAPER, SoulReaperRenderer::new);
        EntityRendererRegistry.register(EntityInit.NECROMANCER, NecromancerRenderer::new);
        EntityRendererRegistry.register(EntityInit.WITHER_PUPPET, WitherPuppetRenderer::new);
        EntityRendererRegistry.register(EntityInit.SKELETON_VANGUARD, SkeletonVanguardRenderer::new);
        EntityRendererRegistry.register(EntityInit.SUMMONER, SummonerRenderer::new);
        EntityRendererRegistry.register(EntityInit.BLAZE_GUARDIAN, BlazeGuardianRenderer::new);
        EntityRendererRegistry.register(EntityInit.THE_EYE, TheEyeRenderer::new);
        EntityRendererRegistry.register(EntityInit.VOID_SHADOW, VoidShadowRenderer::new);
        EntityRendererRegistry.register(EntityInit.TINY_EYE, TinyEyeRenderer::new);
        EntityRendererRegistry.register(EntityInit.RED_FUNGUS, RedFungusRenderer::new);
        EntityRendererRegistry.register(EntityInit.BROWN_FUNGUS, BrownFungusRenderer::new);
        EntityRendererRegistry.register(EntityInit.ORC, OrcRenderer::new);
        EntityRendererRegistry.register(EntityInit.DRAGON, DragonRenderer::new);
        EntityRendererRegistry.register(EntityInit.MAMMOTH, MammothRenderer::new);
        EntityRendererRegistry.register(EntityInit.VOID_FRAGMENT, VoidFragmentRenderer::new);
        EntityRendererRegistry.register(EntityInit.VOID_SHADE, VoidShadeRenderer::new);
        EntityRendererRegistry.register(EntityInit.VOID_BULLET, VoidBulletRenderer::new);
        EntityRendererRegistry.register(EntityInit.FIRE_BREATH, class_6344::new);
        EntityRendererRegistry.register(EntityInit.BLAZE_GUARDIAN_SHIELD, class_6344::new);
        EntityRendererRegistry.register(EntityInit.ENDER_WHALE, EnderWhaleRenderer::new);
        EntityRendererRegistry.register(EntityInit.IGUANA, IguanaRenderer::new);
        EntityRendererRegistry.register(EntityInit.AMETHYST_GOLEM, AmethystGolemRenderer::new);
        EntityRendererRegistry.register(EntityInit.AMETHYST_SHARD, AmethystShardRenderer::new);
        EntityRendererRegistry.register(EntityInit.DESERT_RHINO, DesertRhinoRenderer::new);
        EntityRendererRegistry.register(EntityInit.VOID_CLOUD, class_6344::new);
        EntityRendererRegistry.register(EntityInit.SHAMAN, ShamanRenderer::new);
        EntityRendererRegistry.register(EntityInit.DEER, DeerRenderer::new);
        EntityRendererRegistry.register(EntityInit.SKUNK, SkunkRenderer::new);
        EntityRendererRegistry.register(EntityInit.ENDERWARTHOG, EnderwarthogRenderer::new);

        // Entity Layer
        EntityModelLayerRegistry.registerModelLayer(BLACKSTONE_GOLEM_LAYER, BlackstoneGolemModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(THROWN_ROCK_LAYER, RockModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(GILDED_STONE_LAYER, GildedStoneModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(MINI_BLACKSTONE_GOLEM_LAYER, MiniBlackstoneGolemModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(PIGLIN_BEAST_LAYER, PiglinBeastModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(SOUL_REAPER_LAYER, SoulReaperModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(NECROMANCER_LAYER, NecromancerModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(WITHER_PUPPET_LAYER, WitherPuppetModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(SKELETON_VANGUARD_LAYER, SkeletonVanguardModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(SUMMONER_LAYER, SummonerModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(BLAZE_GUARDIAN_LAYER, BlazeGuardianModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(THE_EYE_LAYER, TheEyeModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(VOID_SHADOW_LAYER, VoidShadowModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(TINY_EYE_LAYER, TinyEyeModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(RED_FUNGUS_LAYER, RedFungusModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(BROWN_FUNGUS_LAYER, BrownFungusModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(ORC_LAYER, OrcModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(DRAGON_LAYER, DragonModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(MAMMOTH_LAYER, MammothModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(VOID_FRAGMENT_LAYER, VoidFragmentModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(VOID_SHADE_LAYER, VoidShadeModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(VOID_BULLET_LAYER, VoidBulletModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(PIGLIN_FLAG_LAYER, PiglinFlagRenderer::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(ENDER_WHALE_LAYER, EnderWhaleModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(IGUANA_LAYER, IguanaModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(AMETHYST_GOLEM_LAYER, AmethystGolemModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(AMETHYST_SHARD_LAYER, AmethystShardModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(DESERT_RHINO_LAYER, DesertRhinoModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(SHAMAN_LAYER, ShamanModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(DEER_LAYER, DeerModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(SKUNK_LAYER, SkunkModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(ENDERWARTHOG_LAYER, EnderwarthogModel::getTexturedModelData);

        // Blocks
        class_5616.method_32144(BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER_ENTITY, ChiseledPolishedBlackstoneHolderRenderer::new);
        BlockRenderLayerMap.INSTANCE.putBlock(BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER, class_1921.method_23581());
        class_5616.method_32144(BlockInit.PIGLIN_FLAG_ENTITY, PiglinFlagRenderer::new);
        BlockRenderLayerMap.INSTANCE.putBlock(BlockInit.PIGLIN_FLAG, class_1921.method_23581());
        class_5616.method_32144(BlockInit.SHADOW_CHEST_ENTITY, class_826::new);

        // Particles
        ParticleFactoryRegistry.getInstance().register(ParticleInit.AMETHYST_SHARD_PARTICLE, ShardParticle.ShardFactory::new);
        ParticleFactoryRegistry.getInstance().register(ParticleInit.VOID_CLOUD_PARTICLE, VoidCloudParticle.CloudFactory::new);
        ParticleFactoryRegistry.getInstance().register(ParticleInit.SPRINT_PARTICLE, SprintParticle.SprintFactory::new);
        ParticleFactoryRegistry.getInstance().register(ParticleInit.FART_PARTICLE, FartParticle.Factory::new);

        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            class_310 client = class_310.method_1551();
            if (!client.field_1690.field_1842&& !client.field_1724.method_7337()&& !client.field_1724.method_7325()) {
                class_1799 itemStack = client.field_1724.method_6118(class_1304.field_6174);
                if (!itemStack.method_7960() && itemStack.method_31574(ItemInit.GILDED_NETHERITE_CHESTPLATE)) {
                    if (itemStack.method_57824(ItemInit.GILDED_DATA) != null && itemStack.method_57824(ItemInit.GILDED_DATA).activated()) {
                        int scaledWidth = client.method_22683().method_4486();
                        int scaledHeight = client.method_22683().method_4502();
                        int worldTime = (int) client.field_1724.method_37908().method_8510();
                        int savedTagInt = itemStack.method_57824(ItemInit.GILDED_DATA).time();
                        float effectDuration = ConfigInit.CONFIG.gilded_netherite_armor_effect_duration;
                        drawContext.method_51448().method_22903();
                        if (savedTagInt + effectDuration > worldTime) {
                            int multiplier = 2;
                            if (savedTagInt + Math.max(effectDuration - 100, 0) < worldTime) {
                                multiplier = 4;
                            }

                            float pulsating = (float) Math.sin((float) ((worldTime * multiplier) - (savedTagInt - 1)) / 6.2831855F);
                            drawContext.method_51422(1.0F, 1.0F, 1.0F, pulsating + 0.5F);
                            drawContext.method_25293(ACTIVE_ARMOR_TEXTURE, (scaledWidth / 2) - 5, scaledHeight - 49, 10, 10, 0, 0, 16, 16, 16, 16);
                        } else {
                            float fading = (1F - (((float) (worldTime - (savedTagInt + (effectDuration - 1f))) / effectDuration) - 0.4F));
                            drawContext.method_51422(1.0F, 0.65F, 0.65F, fading);
                            drawContext.method_25293(ACTIVE_ARMOR_TEXTURE, (scaledWidth / 2) - 5, scaledHeight - 49, 10, 10, 0, 0, 16, 16, 16, 16);
                        }
                        drawContext.method_51448().method_22909();
                        drawContext.method_51422(1.0F, 1.0F, 1.0F, 1.0F);
                    }
                }
                if (client.field_1724.method_6059(EffectInit.WITHERING)) {
                    drawContext.method_51422(1.0F, 1.0F, 1.0F, client.field_1724.method_6112(EffectInit.WITHERING).method_5584() / 280F);
                    int scaledWidth = client.method_22683().method_4486();
                    int scaledHeight = client.method_22683().method_4502();
                    drawContext.method_25290(WITHERED_TEXTURE, scaledWidth / 2 - 64, scaledHeight / 2 - 64, 0.0F, 0.0F, 128, 128, 128, 128);
                    drawContext.method_51422(1.0F, 1.0F, 1.0F, 1.0F);
                }
            }
        });
    }
}