package net.adventurez.init;

import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1429;
import net.minecraft.class_1588;
import net.minecraft.class_1972;
import net.minecraft.class_2902;
import net.minecraft.class_6908;
import net.minecraft.class_9169;
import net.adventurez.entity.*;

public class SpawnInit {

    public static void init() {
        setSpawnRestriction();
        addSpawnEntries();
    }

    // MONSTER tries to spawn often, CREATURE tries more rarely to spawn + in groups
    private static void addSpawnEntries() {
        BiomeModifications.addSpawn(BiomeSelectors.includeByKey(class_1972.field_23859), class_1311.field_6302, EntityInit.MINI_BLACKSTONE_GOLEM, ConfigInit.CONFIG.mini_blackstone_golem_spawn_weight,
                1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.foundInTheNether().and(BiomeSelectors.excludeByKey(class_1972.field_23859)), class_1311.field_6302, EntityInit.BLAZE_GUARDIAN,
                ConfigInit.CONFIG.blaze_guardian_spawn_weight, 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.tag(class_6908.field_36504), class_1311.field_6302, EntityInit.SOUL_REAPER, ConfigInit.CONFIG.nightmare_spawn_weight, 1, 1);

        BiomeModifications.addSpawn(BiomeSelectors.tag(TagInit.IS_MUSHROOM), class_1311.field_6294, EntityInit.RED_FUNGUS, ConfigInit.CONFIG.fungus_spawn_weight, 2, 3);
        BiomeModifications.addSpawn(BiomeSelectors.tag(TagInit.IS_MUSHROOM), class_1311.field_6294, EntityInit.BROWN_FUNGUS, ConfigInit.CONFIG.fungus_spawn_weight, 2, 3);
        BiomeModifications.addSpawn(BiomeSelectors.tag(class_6908.field_36497), class_1311.field_6302, EntityInit.ORC, ConfigInit.CONFIG.orc_spawn_weight, 2, 4);
        BiomeModifications.addSpawn(BiomeSelectors.tag(class_6908.field_36521), class_1311.field_6294, EntityInit.MAMMOTH, ConfigInit.CONFIG.mammoth_spawn_weight, 2, 2);
        BiomeModifications.addSpawn(BiomeSelectors.foundInTheEnd(), class_1311.field_6294, EntityInit.ENDER_WHALE, ConfigInit.CONFIG.ender_whale_spawn_weight, 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.tag(class_6908.field_36513), class_1311.field_6294, EntityInit.IGUANA, ConfigInit.CONFIG.iguana_spawn_weight, 1, 2);
        BiomeModifications.addSpawn(BiomeSelectors.tag(class_6908.field_36520), class_1311.field_6302, EntityInit.DESERT_RHINO, ConfigInit.CONFIG.desert_rhino_spawn_weight, 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.tag(class_6908.field_36495), class_1311.field_6302, EntityInit.SHAMAN, ConfigInit.CONFIG.shaman_spawn_weight, 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.foundInTheEnd().and(BiomeSelectors.excludeByKey(class_1972.field_9411, class_1972.field_9465)), class_1311.field_6302, EntityInit.ENDERWARTHOG,
                ConfigInit.CONFIG.enderwarthog_spawn_weight, 1, 1);
        BiomeModifications.addSpawn(BiomeSelectors.tag(class_6908.field_36517), class_1311.field_6294, EntityInit.DEER, ConfigInit.CONFIG.deer_spawn_weight, 2, 3);
        BiomeModifications.addSpawn(BiomeSelectors.tag(class_6908.field_36517), class_1311.field_6294, EntityInit.SKUNK, ConfigInit.CONFIG.skunk_spawn_weight, 1, 2);
    }

    private static void setSpawnRestriction() {
        class_1317.method_20637(EntityInit.MINI_BLACKSTONE_GOLEM, class_9169.field_48745, class_2902.class_2903.field_13203, MiniBlackstoneGolemEntity::canSpawn);
        class_1317.method_20637(EntityInit.NECROMANCER, class_9169.field_48745, class_2902.class_2903.field_13203, NecromancerEntity::canSpawn);
        class_1317.method_20637(EntityInit.SUMMONER, class_9169.field_48745, class_2902.class_2903.field_13203, SummonerEntity::canSpawn);
        class_1317.method_20637(EntityInit.BLAZE_GUARDIAN, class_9169.field_48745, class_2902.class_2903.field_13203, BlazeGuardianEntity::canSpawn);
        class_1317.method_20637(EntityInit.PIGLIN_BEAST, class_9169.field_48745, class_2902.class_2903.field_13203, class_1588::method_20681);
        class_1317.method_20637(EntityInit.SOUL_REAPER, class_9169.field_48745, class_2902.class_2903.field_13203, SoulReaperEntity::canSpawn);
        class_1317.method_20637(EntityInit.RED_FUNGUS, class_9169.field_48745, class_2902.class_2903.field_13203, RedFungusEntity::canSpawn);
        class_1317.method_20637(EntityInit.BROWN_FUNGUS, class_9169.field_48745, class_2902.class_2903.field_13203, BrownFungusEntity::canSpawn);
        class_1317.method_20637(EntityInit.ORC, class_9169.field_48745, class_2902.class_2903.field_13203, OrcEntity::canSpawn);
        class_1317.method_20637(EntityInit.MAMMOTH, class_9169.field_48745, class_2902.class_2903.field_13203, class_1429::method_20663);
        class_1317.method_20637(EntityInit.ENDER_WHALE, class_9169.field_48742, class_2902.class_2903.field_13203, EnderWhaleEntity::canSpawn);
        class_1317.method_20637(EntityInit.IGUANA, class_9169.field_48745, class_2902.class_2903.field_13203, IguanaEntity::method_20663);
        class_1317.method_20637(EntityInit.DESERT_RHINO, class_9169.field_48745, class_2902.class_2903.field_13203, DesertRhinoEntity::canSpawn);
        class_1317.method_20637(EntityInit.SHAMAN, class_9169.field_48745, class_2902.class_2903.field_13203, ShamanEntity::canSpawn);
        class_1317.method_20637(EntityInit.DEER, class_9169.field_48745, class_2902.class_2903.field_13203, class_1429::method_20663);
        class_1317.method_20637(EntityInit.SKUNK, class_9169.field_48745, class_2902.class_2903.field_13203, class_1429::method_20663);
        class_1317.method_20637(EntityInit.ENDERWARTHOG, class_9169.field_48745, class_2902.class_2903.field_13203, EnderwarthogEntity::canSpawn);
    }

}
