package net.adventurez.item;

import java.util.List;

import net.adventurez.entity.nonliving.ThrownRockEntity;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.ItemInit;
import net.adventurez.init.SoundInit;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3675;

public class BlackstoneGolemArm extends class_1792 {

    public BlackstoneGolemArm(class_1793 settings) {
        super(settings);
    }

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        if (ConfigInit.CONFIG.allow_extra_tooltips) {
            tooltip.add(class_2561.method_43471("item.adventurez.moreinfo.tooltip"));
            if (class_3675.method_15987(class_310.method_1551().method_22683().method_4490(), 340)) {
                tooltip.remove(class_2561.method_43471("item.adventurez.moreinfo.tooltip"));
                tooltip.add(class_2561.method_43471("item.adventurez.blackstone_golem_arm.tooltip"));
            }
        }
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657 playerEntity) {
            int stoneCounter = this.method_7881(stack, user) - remainingUseTicks;
            if (stoneCounter >= 30) {
                stack.method_57379(ItemInit.LAVA_LIGHT, false);
                if (!world.method_8608()) {
                    float strength = getStoneStrength(stoneCounter);
                    stack.method_7970(1, playerEntity, class_1309.method_56079(user.method_6058()));
                    ThrownRockEntity thrownRockEntity = new ThrownRockEntity(world, playerEntity);
                    thrownRockEntity.method_24919(playerEntity, playerEntity.method_36455(), playerEntity.method_36454(), 0.0F, strength * 1.2F, 1.0F);
                    world.method_8649(thrownRockEntity);
                    world.method_43129((class_1657) null, thrownRockEntity, SoundInit.ROCK_THROW_EVENT, class_3419.field_15248, 1.0F, 1.0F);
                }
            }
        }
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (itemStack.method_7919() >= itemStack.method_7936() - 1) {
            return class_1271.method_22431(itemStack);
        } else {
            user.method_6019(hand);
            return class_1271.method_22427(itemStack);
        }
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1657 player = (class_1657) entity;
        class_1293 slowness = new class_1293(class_1294.field_5909, 9, 0, false, false, false);
        if (selected && !world.method_8608()) {
            player.method_6092(slowness);
        }

        if (world.method_8608()) {
            if (player.method_6014() < 71970 && player.method_6014() != 0
                    && player.method_6118(player.method_6058() == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171) == stack) {
                stack.method_57379(ItemInit.LAVA_LIGHT, true);
            }

            if (stack.method_57824(ItemInit.LAVA_LIGHT) != null && stack.method_57824(ItemInit.LAVA_LIGHT)
                    && player.method_6118(player.method_6058() == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171) != stack) {
                stack.method_57379(ItemInit.LAVA_LIGHT, false);
            }
        }
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8952;
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 user) {
        return 72000;
    }

    @Override
    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return ingredient.method_7909() == class_1802.field_22021;
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        class_243 vec3d_1 = attacker.method_5828(1.0F);
        double x_vector = vec3d_1.field_1352 / 2D;
        double z_vector = vec3d_1.field_1350 / 2D;
        stack.method_7970(1, attacker, class_1309.method_56079(attacker.method_6058()));
        target.method_5762(x_vector, 0.45D, z_vector);
        return true;
    }

    public static float getStoneStrength(int useTicks) {
        float f = (float) useTicks / 20.0F;
        f = (f * f + f * 2.0F) / 3.0F;
        if (f > 1.0F) {
            f = 1.0F;
        }
        return f;
    }

}