package net.adventurez.item;

import java.util.List;

import net.adventurez.init.ConfigInit;
import net.adventurez.init.EffectInit;
import net.adventurez.init.SoundInit;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3675;

public class BlackstoneGolemHeart extends class_1792 {

    public BlackstoneGolemHeart(class_1793 settings) {
        super(settings);
    }

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        if (ConfigInit.CONFIG.allow_extra_tooltips) {
            tooltip.add(class_2561.method_43471("item.adventurez.moreinfo.tooltip"));
            if (class_3675.method_15987(class_310.method_1551().method_22683().method_4490(), 340)) {
                tooltip.remove(class_2561.method_43471("item.adventurez.moreinfo.tooltip"));
                tooltip.add(class_2561.method_43471("item.adventurez.blackstone_golem_heart.tooltip"));
            }
        }
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if ((int) world.method_8510() % 100 == 0) {
            world.method_8396(null, entity.method_24515(), SoundInit.HEART_BEAT_EVENT, class_3419.field_15256, 1F, 1F);
        }
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (user.method_5715()) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), SoundInit.GOLEM_AWAKENS_EVENT, class_3419.field_15248, 1.4F, 1.0F);
            if (!world.method_8608()) {
                user.method_6092(new class_1293(EffectInit.BLACKSTONED_HEART, ConfigInit.CONFIG.stoned_heart_duration, ConfigInit.CONFIG.stoned_heart_amplifier, false, false, true));
                itemStack.method_7934(1);
            }
            return class_1271.method_29237(itemStack, world.method_8608());
        } else {
            return class_1271.method_22430(itemStack);
        }
    }
}