package net.adventurez.item;

import java.util.List;

import net.adventurez.entity.EnderWhaleEntity;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.SoundInit;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3675;

public class EnderFlute extends class_1792 {

    public EnderFlute(class_1793 settings) {
        super(settings);
    }

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        if (ConfigInit.CONFIG.allow_extra_tooltips) {
            tooltip.add(class_2561.method_43471("item.adventurez.moreinfo.tooltip"));
            if (class_3675.method_15987(class_310.method_1551().method_22683().method_4490(), 340)) {
                tooltip.remove(class_2561.method_43471("item.adventurez.moreinfo.tooltip"));
                tooltip.add(class_2561.method_43471("item.adventurez.ender_flute.tooltip"));
            }
        }
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), SoundInit.FLUTE_CALL_EVENT, class_3419.field_15248, 1.0F, world.field_9229.method_43057() * 0.2F + 0.9F);
        if (!world.method_8608()) {
            itemStack.method_7970(1, user, class_1309.method_56079(hand));
            List<EnderWhaleEntity> list = world.method_8390(EnderWhaleEntity.class, new class_238(user.method_24515()).method_1014(100D), class_1301.field_6155);
            if (!list.isEmpty()) {
                list.get(0).method_5962().method_6239(user.method_23317(), user.method_23318(), user.method_23321(), 1.0D);
            }
        }

        user.method_7357().method_7906(itemStack.method_7909(), 40);
        return class_1271.method_29237(itemStack, world.method_8608());
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (world.method_8608() && entity instanceof class_1657) {
            class_1657 playerEntity = (class_1657) entity;
            float cooldownProgress = playerEntity.method_7357().method_7905(stack.method_7909(), 0.0F);
            if (cooldownProgress > 0.0F) {
                world.method_8406(class_2398.field_11224, (double) playerEntity.method_23317() + playerEntity.method_5663().method_10216() + world.field_9229.method_43058() * 0.4D,
                        (double) playerEntity.method_23318() + playerEntity.method_17682() * 0.8D, (double) playerEntity.method_23321() + playerEntity.method_5663().method_10215() + world.field_9229.method_43058() * 0.4D,
                        playerEntity.method_5663().method_10216() * world.field_9229.method_43058(), 0.0D, 0.0D);
            }
        }
    }
}
