package net.adventurez.item;

import java.util.List;

import net.adventurez.init.ConfigInit;
import net.adventurez.init.ItemInit;
import net.adventurez.item.component.GildedActivationComponent;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_6880;

public class GildedNetheriteArmor extends class_1738 {

    public GildedNetheriteArmor(class_6880<class_1741> material, class_8051 type, class_1793 settings) {
        super(material, type, settings);
    }

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        if (ConfigInit.CONFIG.allow_extra_tooltips) {
            tooltip.add(class_2561.method_43471("item.adventurez.moreinfo.tooltip"));
            if (class_3675.method_15987(class_310.method_1551().method_22683().method_4490(), 340)) {
                tooltip.remove(class_2561.method_43471("item.adventurez.moreinfo.tooltip"));
                tooltip.add(class_2561.method_43471("item.adventurez.gilded_netherite_armor.tooltip"));
                tooltip.add(class_2561.method_43471("item.adventurez.gilded_netherite_armor.tooltip2"));
                tooltip.add(class_2561.method_43471("item.adventurez.gilded_netherite_armor.tooltip3"));
                tooltip.add(class_2561.method_43471("item.adventurez.gilded_netherite_armor.tooltip4"));
            }
        }
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (stack.method_7909() == ItemInit.GILDED_NETHERITE_CHESTPLATE) {
            GildedActivationComponent component = stack.method_57825(ItemInit.GILDED_DATA, GildedActivationComponent.DEFAULT);

            if (component.activated() && component.time() + (ConfigInit.CONFIG.gilded_netherite_armor_effect_duration * 2) < (int) world.method_8510()) {
                stack.method_57379(ItemInit.GILDED_DATA, new GildedActivationComponent(false, component.time(), component.visuals()));
            }
            if (component.activated() && component.time() + ConfigInit.CONFIG.gilded_netherite_armor_effect_duration < (int) world.method_8510()) {
                entity.method_20803(0);
                stack.method_57379(ItemInit.GILDED_DATA, new GildedActivationComponent(component.activated(), component.time(), false));
            }
        }
    }

    public static void activateStoneGolemArmor(class_1657 player, class_1799 stack) {
        if (!stack.method_31574(ItemInit.GILDED_NETHERITE_CHESTPLATE)) {
            return;
        }

        GildedActivationComponent component = stack.method_57825(ItemInit.GILDED_DATA, GildedActivationComponent.DEFAULT);
        if (!component.activated()) {
            stack.method_57379(ItemInit.GILDED_DATA, new GildedActivationComponent(true, (int) player.method_37908().method_8510(), true));
            if (!player.method_37908().method_8608()) {
                player.method_6092(new class_1293(class_1294.field_5918, ConfigInit.CONFIG.gilded_netherite_armor_effect_duration, 0, false, false));
            }
            player.method_5783(class_3417.field_15102, 1.0F, 1.0F);
        }
    }

    public static boolean isStoneGolemArmorActive(class_1799 stack) {
        if (!stack.method_31574(ItemInit.GILDED_NETHERITE_CHESTPLATE)) {
            return false;
        }

        GildedActivationComponent component = stack.method_57825(ItemInit.GILDED_DATA, GildedActivationComponent.DEFAULT);
        return component.activated() && component.visuals();
    }

    public static boolean fullGolemArmor(class_1657 playerEntity) {
        if (playerEntity.method_6118(class_1304.field_6169).method_7909().equals(ItemInit.GILDED_NETHERITE_HELMET)
                && playerEntity.method_6118(class_1304.field_6174).method_7909().equals(ItemInit.GILDED_NETHERITE_CHESTPLATE)
                && playerEntity.method_6118(class_1304.field_6172).method_7909().equals(ItemInit.GILDED_NETHERITE_LEGGINGS)
                && playerEntity.method_6118(class_1304.field_6166).method_7909().equals(ItemInit.GILDED_NETHERITE_BOOTS)) {
            return true;
        } else {
            return false;
        }
    }

}