package net.adventurez.item.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

import io.netty.buffer.ByteBuf;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record GildedActivationComponent(boolean activated, int time, boolean visuals) {
    public static final GildedActivationComponent DEFAULT = new GildedActivationComponent(false, 0, false);

    public static final Codec<GildedActivationComponent> CODEC = RecordCodecBuilder
            .create(instance -> instance.group(Codec.BOOL.fieldOf("activated").forGetter(GildedActivationComponent::activated), Codec.INT.fieldOf("time").forGetter(GildedActivationComponent::time),
                    Codec.BOOL.fieldOf("visuals").forGetter(GildedActivationComponent::visuals)).apply(instance, GildedActivationComponent::new));

    public static final class_9139<ByteBuf, GildedActivationComponent> PACKET_CODEC = class_9139.method_56436(class_9135.field_48547, GildedActivationComponent::activated, class_9135.field_49675,
            GildedActivationComponent::time, class_9135.field_48547, GildedActivationComponent::visuals, GildedActivationComponent::new);

}
