package net.adventurez.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import net.adventurez.entity.DesertRhinoEntity;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.EntityInit;
import net.minecraft.class_1317;
import net.minecraft.class_2338;
import net.minecraft.class_3005;
import net.minecraft.class_3111;
import net.minecraft.class_3730;
import net.minecraft.class_5821;

@Mixin(class_3005.class)
public class DesertWellFeatureMixin {

    @Inject(method = "generate", at = @At(value = "RETURN"))
    private void generateMixin(class_5821<class_3111> context, CallbackInfoReturnable<Boolean> info) {
        if (info.getReturnValue()) {
            int rhinoSpawnChance = ConfigInit.CONFIG.desert_rhino_well_spawn_chance;
            if (!context.method_33652().method_8608() && rhinoSpawnChance != 0) {
                int spawnChanceInt = context.method_33654().method_43048(rhinoSpawnChance) + 1;
                class_2338 spawnPos = context.method_33655().method_10077(3).method_10067();
                if (spawnChanceInt == 1) {
                    for (int i = 0; i < 4; i++) {
                        if (i == 1) {
                            spawnPos = spawnPos.method_10089(9);
                        }
                        if (i == 2) {
                            spawnPos = spawnPos.method_10077(5).method_10089(4);
                        }
                        if (i == 3) {
                            spawnPos = spawnPos.method_10076(5).method_10089(3);
                        }
                        if (context.method_33652().method_22347(spawnPos)
                                && class_1317.method_20638(EntityInit.DESERT_RHINO, context.method_33652(), class_3730.field_16472, spawnPos, context.method_33654())) {
                            DesertRhinoEntity desertRhinoEntity = EntityInit.DESERT_RHINO.method_5883(context.method_33652().method_8410());
                            desertRhinoEntity.method_5725(spawnPos, context.method_33654().method_43057() * 360F, 0.0F);
                            context.method_33652().method_8649(desertRhinoEntity);
                            break;
                        }
                    }
                }
            }
        }
    }
}
