package net.adventurez.mixin;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.At;

import net.adventurez.init.ConfigInit;
import net.minecraft.class_1510;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2881;
import net.minecraft.class_2902;
import net.minecraft.class_3033;
import net.minecraft.class_3218;

@Mixin(class_2881.class)
public class EnderDragonFightMixin {

    @Shadow
    private boolean previouslyKilled;
    @Shadow
    @Mutable
    @Final
    private class_3218 world;
    @Shadow
    @Mutable
    @Final
    private class_2338 origin;

    @Inject(method = "dragonKilled", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/boss/dragon/EnderDragonFight;generateNewEndGateway()V"))
    public void dragonKilledMixin(class_1510 dragon, CallbackInfo info) {
        if (!this.world.field_9236 && ConfigInit.CONFIG.resummoned_ender_dragon_drops_egg && this.previouslyKilled
                && this.world.method_8320(this.world.method_8598(class_2902.class_2903.field_13197, class_3033.method_51862(this.origin))).method_26204() != class_2246.field_10081) {
            this.world.method_8501(this.world.method_8598(class_2902.class_2903.field_13197, class_3033.method_51862(this.origin)), class_2246.field_10081.method_9564());
        }
    }

}
