package net.adventurez.mixin;

import org.spongepowered.asm.mixin.Mixin;

import net.adventurez.entity.PiglinBeastEntity;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.EntityInit;
import net.minecraft.class_1301;
import net.minecraft.class_1317;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2431;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3730;

@SuppressWarnings("deprecation")
@Mixin(class_2431.class)
public abstract class ExperienceDroppingBlockMixin extends class_2248 {

    public ExperienceDroppingBlockMixin(class_2251 settings) {
        super(settings);
    }

    @Override
    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity, class_1799 tool) {
        if (!world.method_8608() && world instanceof class_3218 serverWorld && state.method_27852(class_2246.field_23077) && ConfigInit.CONFIG.piglin_beast_ore_spawn_chance != 0) {
            if (!player.method_7337() && world.method_27983() == class_1937.field_25180
                    && player.method_6047().method_58657().method_57534().stream().filter(entry -> entry.method_40226(class_1893.field_9099.method_41185())).findAny().isPresent()) {
                if (world.method_18023(EntityInit.PIGLIN_BEAST, player.method_5829().method_1014(40D), class_1301.field_6155).isEmpty()) {
                    int spawnChanceInt = world.method_8409().method_43048(ConfigInit.CONFIG.piglin_beast_ore_spawn_chance) + 1;
                    if (spawnChanceInt == 1) {

                        PiglinBeastEntity beastEntity = EntityInit.PIGLIN_BEAST.method_5883(world);
                        int posYOfPlayer = player.method_24515().method_10264();
                        for (int counter = 0; counter < 100; counter++) {
                            float randomFloat = world.method_8409().method_43057() * 6.2831855F;
                            int posX = pos.method_10263() + class_3532.method_15375(class_3532.method_15362(randomFloat) * 18.0F + world.method_8409().method_43048(16));
                            int posZ = pos.method_10260() + class_3532.method_15375(class_3532.method_15374(randomFloat) * 18.0F + world.method_8409().method_43048(16));
                            // int posY = world.getTopY(Heightmap.Type.WORLD_SURFACE_WG, posX, posZ); doesnt work in nether
                            int posY = posYOfPlayer - 20 + world.method_8409().method_43048(40);
                            class_2338 spawnPos = new class_2338(posX, posY, posZ);

                            if (world.method_22341(spawnPos.method_10263() - 4, spawnPos.method_10264() - 4, spawnPos.method_10260() - 4, spawnPos.method_10263() + 4, spawnPos.method_10264() + 4, spawnPos.method_10260() + 4)
                                    && class_1317.method_20638(EntityInit.PIGLIN_BEAST, serverWorld, class_3730.field_16467, spawnPos, world.method_8409())) {
                                beastEntity.method_5725(spawnPos, 0.0F, 0.0F);
                                beastEntity.method_5943(serverWorld, world.method_8404(spawnPos), class_3730.field_16467, null);
                                world.method_8649(beastEntity);
                                beastEntity.method_5990();
                                break;
                            }
                        }
                    }
                }
            }
        }
        super.method_9556(world, player, pos, state, blockEntity, tool);
    }

}
