package net.adventurez.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.At.Shift;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.injection.At;

import net.adventurez.entity.BlazeGuardianEntity;
import net.adventurez.entity.VoidFragmentEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1927;
import net.minecraft.class_2338;

@Mixin(class_1927.class)
public class ExplosionMixin {
    @Shadow
    @Mutable
    @Final
    private class_1297 entity;

    public ExplosionMixin(@Nullable class_1297 entity) {
        this.entity = entity;
    }

    @Inject(method = "collectBlocksAndDamageEntities", at = @At(value = "INVOKE_ASSIGN", target = "Lnet/minecraft/world/World;getOtherEntities(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/Box;)Ljava/util/List;", shift = Shift.AFTER), locals = LocalCapture.CAPTURE_FAILSOFT)
    public void collectBlocksAndDamageEntitiesMixin(CallbackInfo info, Set<class_2338> set, int i, float q, int k, int l, int r, int s, int t, int u, List<class_1297> list) {
        if (this.entity != null) {
            if (this.entity instanceof BlazeGuardianEntity || this.entity instanceof VoidFragmentEntity) {
                List<class_1297> removeList = new ArrayList<class_1297>();
                for (int o = 0; o < list.size(); ++o) {
                    class_1297 entityFromList = (class_1297) list.get(o);
                    if (!(entityFromList instanceof class_1657)) {
                        removeList.add(entityFromList);
                    }
                }
                list.removeAll(removeList);
            }
        }
    }
}
