package net.adventurez.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.At;

import net.adventurez.init.ConfigInit;
import net.adventurez.init.ItemInit;
import net.adventurez.item.GildedNetheriteArmor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_8103;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 {

    public PlayerEntityMixin(class_1299<class_1657> type, class_1937 world) {
        super(type, world);
    };

    @Inject(method = "damage", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/damage/DamageSource;isScaledWithDifficulty()Z"), cancellable = true)
    private void damageMixin(class_1282 source, float amount, CallbackInfoReturnable<Boolean> info) {
        if (this.method_6118(class_1304.field_6174).method_7909() == ItemInit.GILDED_NETHERITE_CHESTPLATE && GildedNetheriteArmor.fullGolemArmor((class_1657) (Object) this)) {
            if (source.method_48789(class_8103.field_42246) && !GildedNetheriteArmor.isStoneGolemArmorActive(this.method_6118(class_1304.field_6174))) {
                GildedNetheriteArmor.activateStoneGolemArmor((class_1657) (Object) this, this.method_6118(class_1304.field_6174));
                info.setReturnValue(false);
            } else if (this.method_37908().method_8409().method_43057() <= ConfigInit.CONFIG.gilded_netherite_armor_dodge_chance) {
                info.setReturnValue(false);
            }
        }
    }

    @Environment(EnvType.CLIENT)
    @Override
    public boolean method_5862() {
        class_1799 golemChestplate = this.method_6118(class_1304.field_6174);
        boolean fireActivated = golemChestplate.method_7909().equals(ItemInit.GILDED_NETHERITE_CHESTPLATE) && GildedNetheriteArmor.isStoneGolemArmorActive(golemChestplate);
        return this.method_5809() && !this.method_7325() && !fireActivated;
    }

}