package net.adventurez.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.At.Shift;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.At;

import net.adventurez.entity.DragonEntity;
import net.adventurez.entity.EnderWhaleEntity;
import net.minecraft.class_2848;
import net.minecraft.class_3222;
import net.minecraft.class_3244;

@Mixin(class_3244.class)
public class ServerPlayNetworkHandlerMixin {

    @Shadow
    public class_3222 player;

    @Shadow
    private int vehicleFloatingTicks;

    @Inject(method = "onClientCommand", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/ServerPlayerEntity;updateLastActionTime()V"))
    private void onClientCommandMixin(class_2848 packet, CallbackInfo info) {
        if (player.method_5854() != null && player.method_5854() instanceof DragonEntity && ((DragonEntity) this.player.method_5854()).hasChest()) {
            ((DragonEntity) this.player.method_5854()).openInventory(this.player);
        }
    }

    @Inject(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/Entity;getControllingPassenger()Lnet/minecraft/entity/LivingEntity;", shift = Shift.AFTER, ordinal = 1))
    private void tickMixin(CallbackInfo info) {
        if (vehicleFloatingTicks >= 70 && player.method_5854() != null && (player.method_5854() instanceof DragonEntity || player.method_5854() instanceof EnderWhaleEntity)) {
            vehicleFloatingTicks = 0;
        }
    }

}