package net.adventurez.mixin;

import java.util.function.Supplier;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.At.Shift;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.At;

import net.adventurez.entity.SummonerEntity;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.EntityInit;
import net.minecraft.class_1317;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_2874;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;

@Mixin(class_3218.class)
public abstract class ServerWorldMixin extends class_1937 {

    public ServerWorldMixin(class_5269 properties, class_5321<class_1937> registryRef, class_5455 registryManager, class_6880<class_2874> dimensionEntry,
            Supplier<class_3695> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
    }

    @Inject(method = "tickChunk", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/LightningEntity;setCosmetic(Z)V", shift = Shift.AFTER))
    public void tickChunk(class_2818 chunk, int randomTickSpeed, CallbackInfo info) {
        int summonerSpawnChance = ConfigInit.CONFIG.summoner_thunder_spawn_chance;
        if (summonerSpawnChance != 0) {
            int spawnChanceInt = this.method_8409().method_43048(summonerSpawnChance) + 1;
            if (spawnChanceInt == 1) {
                class_1923 chunkPos = chunk.method_12004();
                int i = chunkPos.method_8326();
                int j = chunkPos.method_8328();

                class_2338 blockPos = this.method_8598(class_2902.class_2903.field_13197, this.method_8536(i, 0, j, 15));
                if (class_1317.method_20638(EntityInit.SUMMONER, (class_3218) (Object) this, class_3730.field_16467, blockPos, this.method_8409())) {
                    SummonerEntity summonerEntity = EntityInit.SUMMONER.method_5883(this);
                    summonerEntity.method_30634((double) blockPos.method_10263(), (double) blockPos.method_10264(), (double) blockPos.method_10260());
                    summonerEntity.method_5943((class_3218) (Object) this, this.method_8404(blockPos), class_3730.field_16467, null);
                    this.method_8649(summonerEntity);
                    summonerEntity.method_5990();
                }
            }
        }
    }

}